/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class PayableBillTradeSplitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("draftbilltranstatus");
        sic.add("draftbillstatus");
        sic.add("issplit");
        sic.add("subbillquantity");
        sic.add("lockedamount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        int selectedRows = dataEntities.length;
        CdmBizResource cdmBizResource = new CdmBizResource();
        if (selectedRows > 1) {
            for (int i = 0; i < selectedRows; ++i) {
                this.addErrorMessage(dataEntities[i], cdmBizResource.getOnlyOneSelectedBillSplitValidatorMsg());
            }
            return;
        }
        ExtendedDataEntity billDataEntity = dataEntities[0];
        DynamicObject receivableBillDO = billDataEntity.getDataEntity();
        BigDecimal lockedAmount = receivableBillDO.getBigDecimal("lockedamount");
        if (BigDecimal.ZERO.compareTo(lockedAmount) != 0) {
            this.addErrorMessage(billDataEntity, cdmBizResource.getLockAmountTradeCheck());
        }
        String draftBillTranStatus = receivableBillDO.getString("draftbilltranstatus");
        String draftBillStatus = receivableBillDO.getString("draftbillstatus");
        Boolean isSplit = receivableBillDO.getBoolean("issplit");
        long subBillQuantity = receivableBillDO.getLong("subbillquantity");
        DynamicObject payableBill = TmcDataServiceHelper.loadSingle((Object)receivableBillDO.getPkValue(), (String)"cdm_payablebill", (String)"id,locksourcebilltype,locksourcebillid");
        if (!StringUtils.equals((CharSequence)draftBillStatus, (CharSequence)DraftBillStatusEnum.REGISTERED.getValue()) || !StringUtils.equals((CharSequence)draftBillTranStatus, (CharSequence)DraftTranStatusEnum.SUCCESS.getValue()) || !isSplit.booleanValue() || subBillQuantity <= 1L || payableBill == null || StringUtils.isNotEmpty((CharSequence)payableBill.getString("locksourcebilltype")) || StringUtils.isNotEmpty((CharSequence)payableBill.getString("locksourcebillid")) && !"0".equals(payableBill.getString("locksourcebillid"))) {
            this.addErrorMessage(billDataEntity, cdmBizResource.getPayableBillTradeSplitValidatorMsg());
        }
    }
}

