/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class PayablePayInterestValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("company");
        sic.add("currency");
        sic.add("isendorsepay");
        sic.add("draftbilltype");
        sic.add("draftbillstatus");
        sic.add("electag");
        sic.add("draftbilltranstatus");
        sic.add("billstatus");
        sic.add("ispayinterest");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        HashSet<Long> companySet = new HashSet<Long>();
        HashSet<Long> currencySet = new HashSet<Long>();
        HashSet<String> draftbilltypeSet = new HashSet<String>();
        CdmBizResource cdmBizResource = new CdmBizResource();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject receivableBillDO = dataEntity.getDataEntity();
            DynamicObject recBill = TmcDataServiceHelper.loadSingle((Object)receivableBillDO.getPkValue(), (String)"cdm_payablebill", (String)"id,draftbilltranstatus,electag,ispayinterest");
            boolean electag = recBill.getBoolean("electag");
            String draftBillTranStatus = recBill.getString("draftbilltranstatus");
            if (electag && draftBillTranStatus.equals("handleing")) {
                this.addErrorMessage(dataEntity, cdmBizResource.getEleFlagValidatorMsg());
            }
            String billStatus = receivableBillDO.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(dataEntity, cdmBizResource.getRbTradeStausCheck());
            }
            DynamicObject company = receivableBillDO.getDynamicObject("company");
            DynamicObject currency = receivableBillDO.getDynamicObject("currency");
            String draftbilltype = receivableBillDO.getDynamicObject("draftbilltype").getString("settlementtype");
            if (StringUtils.equals((CharSequence)draftbilltype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue()) || StringUtils.equals((CharSequence)draftbilltype, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                this.addErrorMessage(dataEntity, cdmBizResource.getBillTypeCheck());
            }
            if (companySet.isEmpty()) {
                companySet.add(company.getLong("id"));
            } else if (!companySet.contains(company.getLong("id"))) {
                this.addErrorMessage(dataEntity, cdmBizResource.getRbTradeCompanyCheck());
            }
            if (currencySet.isEmpty()) {
                currencySet.add(currency.getLong("id"));
            } else if (!currencySet.contains(currency.getLong("id"))) {
                this.addErrorMessage(dataEntity, cdmBizResource.getRbTradeCurrencyCheck());
            }
            if (draftbilltypeSet.isEmpty()) {
                draftbilltypeSet.add(draftbilltype);
            } else if (!draftbilltypeSet.contains(draftbilltype)) {
                this.addErrorMessage(dataEntity, cdmBizResource.getRbTradeDraftbillTypeCheck());
                break;
            }
            if (recBill.getBoolean("ispayinterest")) {
                this.addErrorMessage(dataEntity, cdmBizResource.getPBTradePayInterestCheck());
            }
            boolean success = StringUtils.equals((CharSequence)receivableBillDO.getString("draftbilltranstatus"), (CharSequence)"success");
            boolean isRegisted = StringUtils.equals((CharSequence)DraftBillStatusEnum.REGISTERED.getValue(), (CharSequence)receivableBillDO.getString("draftbillstatus"));
            if (success && isRegisted) continue;
            this.addErrorMessage(dataEntity, cdmBizResource.getPITradeDraftBillStatusRemitCheck());
        }
    }
}

