/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.receivablebill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import org.apache.commons.lang3.StringUtils;

public class ReceivableAutoGenRecBillValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(4);
        selector.add("claimnoticebillno");
        selector.add("draftbillno");
        selector.add("company");
        selector.add("draftbillstatus");
        selector.add("rectype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long id;
            QFilter[] filter;
            boolean isExist;
            DynamicObject receivableBillDO = dataEntity.getDataEntity();
            String claimNoticeBillNo = receivableBillDO.getString("claimnoticebillno");
            String draftBillNo = receivableBillDO.getString("draftbillno");
            String recType = receivableBillDO.getString("rectype");
            if (StringUtils.isNotEmpty((CharSequence)claimNoticeBillNo)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5df2\u53d1\u8d77\u8fc7\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u4e0d\u80fd\u64cd\u4f5c\u5355\u636e\u8f6c\u6362\u751f\u5355\u3002", (String)"ReceivableAutoGenRecBillValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillNo));
            }
            if ((isExist = TmcDataServiceHelper.exists((String)"cas_recbill", (QFilter[])(filter = new QFilter[]{new QFilter("draftbill.fbasedataid.id", "in", (Object)(id = receivableBillDO.getLong("id"))), new QFilter("billstatus", "not in", (Object)new String[]{"D", "H"})}))) || StringUtils.isNotEmpty((CharSequence)recType)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5df2\u5173\u8054\u6536\u6b3e\uff0c\u4e0d\u80fd\u64cd\u4f5c\u5355\u636e\u8f6c\u6362\u751f\u5355\u3002", (String)"ReceivableAutoGenRecBillValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillNo));
            }
            long companyId = receivableBillDO.getDynamicObject("company").getLong("id");
            String draftBillStatus = receivableBillDO.getString("draftbillstatus");
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            String noticeClaimAllowStatus = (String)TmcParameterHelper.getAppParameter((String)appId, (Long)companyId, (String)"noticeclaimallowstatus");
            if (noticeClaimAllowStatus.contains(draftBillStatus)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u7968\u636e\u72b6\u6001\u4e0d\u652f\u6301\u5355\u636e\u8f6c\u6362\u751f\u5355\u3002", (String)"ReceivableAutoGenRecBillValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillNo));
        }
    }
}

