/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.receivablebill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class ReceivableBillOnlineUpdateValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("draftbillstatus");
        sic.add("draftbilltype");
        sic.add("sourcebillid");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject recBill = dataEntity.getDataEntity();
            String draftBillStatus = recBill.getString("draftbillstatus");
            DynamicObject draftBillType = recBill.getDynamicObject("draftbilltype");
            String billMedium = draftBillType.getString("billmedium");
            if (!"2".equals(billMedium) || !"registered".equals(draftBillStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5728\u7ebf\u66f4\u65b0\u5df2\u767b\u8bb0\u7684\u7535\u7968\u6570\u636e", (String)"ReceivableBillOnlineUpdateValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            Long sourceBillId = recBill.getLong("sourcebillid");
            boolean isExist = QueryServiceHelper.exists((String)"cdm_electronic_rec_deal", (Object)sourceBillId);
            if (isExist) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u7684\u8be5\u6761\u5e94\u6536\u7968\u636e\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7535\u7968\u6570\u636e", (String)"ReceivableBillOnlineUpdateValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

