/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.receivablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceivableBillSaveValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(ReceivableBillSaveValidator.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("company");
        sic.add("receivername");
        sic.add("delivername");
        sic.add("drawername");
        sic.add("sourcebillid");
        sic.add("draftbilltype");
        sic.add("issuedate");
        sic.add("draftbillexpiredate");
        sic.add("issuepromisertype");
        sic.add("issuepromiserdate");
        sic.add("acceptpromisertype");
        sic.add("acceptpromiserdate");
        sic.add("issueticketexpiredate");
        sic.add("promiseexpiredate");
        sic.add("bankaccount");
        sic.add("draftbillno");
        sic.add("sourcedraft");
        sic.add("drawerbank");
        sic.add("accepterbebank");
        sic.add("amount");
        sic.add("supperbillamount");
        sic.add("issplit");
        sic.add("amount");
        sic.add("subbillstartflag");
        sic.add("subbillendflag");
        sic.add("subbillrange");
        sic.add("subbillquantity");
        sic.add("supperbillid");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        logger.info("ReceivableBillSaveValidator save validate is start");
        CdmBizResource cdmBizResource = new CdmBizResource();
        logger.info("use appid=0=GV6L3QZ3D+ check limits");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject receivableBillDO = dataEntity.getDataEntity();
            String company = receivableBillDO.getDynamicObject("company").getString("name");
            String receiver = receivableBillDO.getString("receivername");
            String delivername = receivableBillDO.getString("delivername");
            String drawername = receivableBillDO.getString("drawername");
            String draftBillNo = receivableBillDO.getString("draftbillno");
            boolean split = receivableBillDO.getBoolean("issplit");
            if (split) {
                BigDecimal newAmount;
                long newSubbillquantity;
                long subbillquantity;
                BigDecimal amount = receivableBillDO.getBigDecimal("supperbillamount");
                BigDecimal subAmount = receivableBillDO.getBigDecimal("amount");
                if (BigDecimal.ZERO.compareTo(amount) < 0 && amount.compareTo(subAmount) < 0) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getSubAmountWrong());
                }
                long subStartFlag = receivableBillDO.getLong("subbillstartflag");
                long subEndFlag = receivableBillDO.getLong("subbillendflag");
                if (0L == subStartFlag) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getSubStartFlagWrong());
                }
                if (0L == subEndFlag) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getSubEndFlagWrong());
                }
                if ((subbillquantity = receivableBillDO.getLong("subbillquantity")) != (newSubbillquantity = subEndFlag - subStartFlag + 1L)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b50\u7968\u5305\u533a\u95f4\u4e0e\u5bf9\u5e94\u7684\u5b50\u7968\u5305\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CdmBizResource_107_6_2", (String)"tmc-cdm-common", (Object[])new Object[0]));
                }
                if (subAmount.compareTo(newAmount = BigDecimal.valueOf(newSubbillquantity).multiply(new BigDecimal("0.01"))) != 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b50\u7968\u5305\u533a\u95f4\u4e0e\u5b50\u7968\u5305\u91d1\u989d\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CdmBizResource_107_6_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
                }
            }
            long supperbillid = receivableBillDO.getLong("supperbillid");
            long sourcebillid = receivableBillDO.getLong("sourcebillid");
            if (EmptyUtil.isNoEmpty((Long)sourcebillid) && sourcebillid > 0L) {
                DynamicObject tBill = TmcBotpHelper.getTargetBill((String)"cas_recbill", (Object)receivableBillDO.get("sourcebillid"), (String)"cdm_receivablebill");
                logger.info("supperbillid:" + supperbillid + ",sourcebillid:" + receivableBillDO.get("sourcebillid") + ",tBill:" + SerializationUtils.toJsonString((Object)tBill));
                if (EmptyUtil.isEmpty((Long)supperbillid) && tBill != null && !tBill.getPkValue().equals(receivableBillDO.getPkValue())) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getTipRecDrafts());
                }
            }
            DynamicObject draftbilltypeDO = receivableBillDO.getDynamicObject("draftbilltype");
            if (!this.getOption().getVariables().containsKey("op_from_isc") && this.getOption().getVariables().containsKey("op_from_edit")) {
                if (EmptyUtil.isNoEmpty((String)receiver) && !StringUtils.equals((CharSequence)company, (CharSequence)receiver) && this.nonBackInfo(receivableBillDO)) {
                    this.addMessage(dataEntity, cdmBizResource.getRbSecondbillCheck(), ErrorLevel.Warning);
                } else {
                    String settlementtype = draftbilltypeDO.getString("settlementtype");
                    if (EmptyUtil.isNoEmpty((String)drawername) && !StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue()) && !StringUtils.equals((CharSequence)delivername, (CharSequence)drawername) && this.nonBackInfo(receivableBillDO)) {
                        this.addMessage(dataEntity, cdmBizResource.getRbSecondbillCheck(), ErrorLevel.Warning);
                    }
                }
            }
            Object issuePromiseDate = receivableBillDO.get("issuepromiserdate");
            Object accPromiseDate = receivableBillDO.get("acceptpromiserdate");
            Date issueDate = receivableBillDO.getDate("issuedate");
            Date draftBillExpireDate = receivableBillDO.getDate("draftbillexpiredate");
            Object issueTicketExpireDate = receivableBillDO.get("issueticketexpiredate");
            Object promiseExpireDate = receivableBillDO.get("promiseexpiredate");
            if (issuePromiseDate != null && (issueDate.after((Date)issuePromiseDate) || draftBillExpireDate.before((Date)issuePromiseDate))) {
                this.addMessage(dataEntity, cdmBizResource.getIssuePromiseDateCheck(), ErrorLevel.Error);
            }
            if (accPromiseDate != null && (issueDate.after((Date)accPromiseDate) || draftBillExpireDate.before((Date)accPromiseDate))) {
                this.addMessage(dataEntity, cdmBizResource.getAcceptPromiseDateCheck(), ErrorLevel.Error);
            }
            if (issueTicketExpireDate != null && issueDate.after((Date)issueTicketExpireDate)) {
                this.addMessage(dataEntity, cdmBizResource.getIssueGradeExpireDateCheck(), ErrorLevel.Error);
            }
            if (promiseExpireDate != null && issueDate.after((Date)promiseExpireDate)) {
                this.addMessage(dataEntity, cdmBizResource.getPromiseGradeExpireDateCheck(), ErrorLevel.Error);
            }
            DynamicObject receivableBill = dataEntity.getDataEntity();
            DynamicObject[] receivableBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)String.join((CharSequence)",", "billpool", "bankaccount"), (QFilter[])new QFilter("id", "=", receivableBill.getPkValue()).toArray());
            if (receivableBills.length > 0) {
                DynamicObject receivableBillByLoad = receivableBills[0];
                DynamicObject bankAccountFromDB = receivableBillByLoad.getDynamicObject("bankaccount");
                DynamicObject bankAccount = receivableBillDO.getDynamicObject("bankaccount");
                if (Objects.nonNull(receivableBillByLoad.get("billpool")) && (Objects.nonNull(bankAccountFromDB) && Objects.nonNull(bankAccount) && !Objects.equals(bankAccountFromDB.getPkValue(), bankAccount.getPkValue()) || Objects.isNull(bankAccountFromDB) && Objects.nonNull(bankAccount) || Objects.nonNull(bankAccountFromDB) && Objects.isNull(bankAccount))) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getInPoolChangeBankAccountCheck());
                }
            }
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            DynamicObject drawerBankObj = receivableBillDO.getDynamicObject("drawerbank");
            if (EmptyUtil.isEmpty((DynamicObject)drawerBankObj)) continue;
            QFilter filters = new QFilter("draftbillno", "=", (Object)draftBillNo);
            if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementtype) || SettleMentTypeEnum.BANK.getValue().equals(settlementtype)) {
                String[] types = new String[]{SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue()};
                filters.and(new QFilter("draftbilltype.settlementtype", "in", (Object)types));
            } else {
                filters.and(new QFilter("draftbilltype.settlementtype", "=", (Object)settlementtype));
            }
            filters.and(new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue()));
            filters.and(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
            filters.and(new QFilter("id", "!=", receivableBillDO.getPkValue()));
            Long sourceDraft = receivableBillDO.getLong("sourcedraft");
            if (!EmptyUtil.isNoEmpty((Long)sourceDraft)) continue;
            filters.and(new QFilter("id", "!=", receivableBillDO.get("sourcedraft")));
        }
        logger.info("ReceivableBillSaveValidator save validate is end");
    }

    private boolean nonBackInfo(DynamicObject receivableBill) {
        DynamicObjectCollection backInfoCollection = receivableBill.getDynamicObjectCollection("endorseentry");
        return CollectionUtils.isEmpty((Collection)backInfoCollection);
    }
}

