/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.receivablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang.StringUtils;

public class ReceivableUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("isendorsepay");
        sic.add("billno");
        sic.add("company");
        sic.add("claimnoticebillno");
        sic.add("allocbillentryid");
        sic.add("billpool");
        sic.add("electag");
        sic.add("draftbilltranstatus");
        sic.add("source");
        sic.add("sourcebillid");
        sic.add("draftbillno");
        sic.add("supperbillid");
        sic.add("locksourcebilltype");
        sic.add("locksourcebillid");
        sic.add("lockedamount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        QFilter qFilterRecer;
        QFilter draftIdQFilter;
        DynamicObjectCollection casRecbillDyns;
        DynamicObject receivableBillDO;
        CdmBizResource cdmBizResource = new CdmBizResource();
        String tipUnAuditClaim = cdmBizResource.getTipUnAuditClaim();
        HashSet<Long> draftIdSet = new HashSet<Long>(16);
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        Map<Object, Object> draftIdAndRecMap = new HashMap(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            receivableBillDO = dataEntity.getDataEntity();
            long id = receivableBillDO.getLong("id");
            long companyId = receivableBillDO.getDynamicObject("company").getLong("id");
            String sourceStr = receivableBillDO.getString("source");
            if (sourceStr.startsWith("cas_")) continue;
            orgIdSet.add(companyId);
            draftIdSet.add(id);
        }
        if (EmptyUtil.isNoEmpty(draftIdSet) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(casRecbillDyns = QueryServiceHelper.query((String)"cas_recbill", (String)"id,org,draftbill.fbasedataid", (QFilter[])new QFilter[]{draftIdQFilter = new QFilter("draftbill.fbasedataid.id", "in", draftIdSet), qFilterRecer = new QFilter("org", "in", orgIdSet)})))) {
            draftIdAndRecMap = casRecbillDyns.stream().collect(Collectors.groupingBy(e -> e.getLong("draftbill.fbasedataid")));
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long draftId;
            List casRecBillDys;
            String claimnoticebillno;
            Long draftEntryId;
            receivableBillDO = dataEntity.getDataEntity();
            BigDecimal lockedamount = receivableBillDO.getBigDecimal("lockedamount");
            if (EmptyUtil.isNoEmpty((BigDecimal)lockedamount)) {
                this.addErrorMessage(dataEntity, cdmBizResource.getLockAmountCheck());
            }
            if (EmptyUtil.isNoEmpty((Long)(draftEntryId = Long.valueOf(receivableBillDO.getLong("allocbillentryid"))))) {
                this.addErrorMessage(dataEntity, cdmBizResource.getRecDraftAllocationCheck());
            }
            if (receivableBillDO.getBoolean("isendorsepay")) {
                String message = String.format(cdmBizResource.getRbTradeUnauditCheck(), receivableBillDO.getString("billno"));
                this.addErrorMessage(dataEntity, message);
            }
            if ((claimnoticebillno = receivableBillDO.getString("claimnoticebillno")) != null && !"".equals(claimnoticebillno)) {
                this.addMessage(dataEntity, tipUnAuditClaim, ErrorLevel.Error);
            }
            if (Objects.nonNull(receivableBillDO.get("billpool"))) {
                this.addErrorMessage(dataEntity, cdmBizResource.getBillPoolCheck());
            }
            long supperbillid = receivableBillDO.getLong("supperbillid");
            String sourceStr = receivableBillDO.getString("source");
            if (EmptyUtil.isNoEmpty((String)sourceStr) && "cdm".equalsIgnoreCase(sourceStr) && EmptyUtil.isNoEmpty((Long)supperbillid)) {
                this.addErrorMessage(dataEntity, cdmBizResource.getSplitBillCheck());
            }
            boolean electTag = receivableBillDO.getBoolean("electag");
            String draftbilltranstatus = receivableBillDO.getString("draftbilltranstatus");
            if (electTag && "handleing".equalsIgnoreCase(draftbilltranstatus)) {
                this.addErrorMessage(dataEntity, cdmBizResource.getEleReceiveBillUnAuditMsg());
            }
            if (sourceStr.startsWith("cas_") || !EmptyUtil.isNoEmpty((Object)(casRecBillDys = (List)draftIdAndRecMap.get(draftId = receivableBillDO.getLong("id"))))) continue;
            long billOrgid = receivableBillDO.getDynamicObject("company").getLong("id");
            boolean isMatch = casRecBillDys.stream().anyMatch(e -> billOrgid == e.getLong("org"));
            if (!isMatch || StringUtils.equals((String)sourceStr, (String)SourceEnum.CAS.getValue())) continue;
            String message = String.format(cdmBizResource.getBillLockCheck(), receivableBillDO.getString("billno"));
            this.addErrorMessage(dataEntity, message);
        }
    }
}

