/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.tradebill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillDelValidator
extends AbstractTmcBizOppValidator {
    private static Log logger = LogFactory.getLog(TradeBillDelValidator.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("source");
        selector.add("sourcebillid");
        selector.add("isrepay");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        logger.info("validate is start");
        CdmBizResource cdmBizResource = new CdmBizResource();
        Map variablesMap = this.getOption().getVariables();
        boolean isFromApply = false;
        if (EmptyUtil.isNoEmpty((Object)variablesMap) && variablesMap.containsKey("isFromApply")) {
            isFromApply = true;
        }
        for (ExtendedDataEntity data : dataEntity) {
            Set pkValues;
            DynamicObject dy = data.getDataEntity();
            Map botpMap = new HashMap(16);
            ArrayList<Long> idSet = new ArrayList<Long>();
            long drafttradeId = dy.getLong("id");
            idSet.add(drafttradeId);
            Map botpMapById = TmcBotpHelper.getSourceBillIdMap((String)"cdm_drafttradebill", idSet, null, null, (boolean)true);
            if (EmptyUtil.isNoEmpty((Object)botpMapById) && botpMapById.size() > 0) {
                botpMap = (Map)botpMapById.get(drafttradeId);
            }
            if (EmptyUtil.isEmpty(botpMap) || botpMap.size() <= 0) continue;
            logger.info("botpMap is start:" + SerializationUtils.toJsonString(botpMap));
            if (botpMap.containsKey("cdm_receivablebill")) {
                botpMap.remove("cdm_receivablebill");
            }
            if (botpMap.containsKey("cdm_payablebill")) {
                botpMap.remove("cdm_payablebill");
            }
            if (botpMap.containsKey("cdm_discount_apply")) {
                pkValues = (Set)botpMap.get("cdm_discount_apply");
                if (null != pkValues && pkValues.size() > 0 && !isFromApply) {
                    DynamicObject[] discountApplyBills;
                    for (DynamicObject discountApply : discountApplyBills = TmcDataServiceHelper.load((String)"cdm_discount_apply", (String)"id,ispushtradebill", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkValues.toArray())})) {
                        discountApply.set("ispushtradebill", (Object)false);
                    }
                    SaveServiceHelper.save((DynamicObject[])discountApplyBills);
                }
                botpMap.remove("cdm_discount_apply");
            }
            if (botpMap.containsKey("cdm_pledge_apply")) {
                pkValues = (Set)botpMap.get("cdm_pledge_apply");
                if (null != pkValues && pkValues.size() > 0 && !isFromApply) {
                    DynamicObject[] pledgeApplyBills;
                    for (DynamicObject pledgeApply : pledgeApplyBills = TmcDataServiceHelper.load((String)"cdm_pledge_apply", (String)"id,ispushtradebill", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkValues.toArray())})) {
                        pledgeApply.set("ispushtradebill", (Object)false);
                    }
                    SaveServiceHelper.save((DynamicObject[])pledgeApplyBills);
                }
                botpMap.remove("cdm_pledge_apply");
            }
            if (botpMap.size() <= 0) continue;
            Long sourcebillId = data.getDataEntity().getLong("sourcebillid");
            boolean rejectOrRepay = dy.getBoolean("isrejectrefundgen") || dy.getBoolean("isrepaygen");
            String source = data.getDataEntity().getString("source");
            if (!EmptyUtil.isNoEmpty((Long)sourcebillId) || SourceEnum.CAS.getValue().equals(source) || rejectOrRepay) continue;
            this.addErrorMessage(data, cdmBizResource.getTipExistSourceBill());
        }
    }
}

