/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.tradebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TrdBillCancelDrawValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(TrdBillCancelDrawValidator.class);
    private List<String> successLockDraftIdList = new ArrayList<String>(8);
    private Set<String> casPayStr = Stream.of("cas_payapplybill", "cas_paybill").collect(Collectors.toSet());
    public static final String BILLTYPE = "draw";

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("allocbillentryid");
        selector.add("draftbilltranstatus");
        selector.add("electag");
        selector.add("billstatus");
        selector.add("tradetype");
        selector.add("entrys");
        selector.add("draftbill");
        selector.add("ispayinterest");
        selector.add("depositdeduct");
        selector.add("deductamount");
        selector.add("isrepay");
        selector.add("sourcebilltype");
        selector.add("isgenbysplit");
        selector.add("drafttype");
        selector.add("euqaldifferetype");
        selector.add("rptype");
        selector.add("isequalsplit");
        selector.add("source");
        selector.add("sourcebillid");
        selector.add("isrepaygen");
        selector.add("isdrawfail");
        selector.add("createtime");
        selector.add("draftbill.subbillstartflag");
        return selector;
    }

    public TrdBillCancelDrawValidator(List<String> lockDraftIdList) {
        this.successLockDraftIdList = lockDraftIdList;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Set succLockSet = new HashSet(8);
        Set notNeedDealTradeBIllSet = new HashSet(8);
        OperateOption option = this.getOption();
        boolean isFromRejectRefundGenDelete = Boolean.parseBoolean(option.getVariableValue("rejectRefundGenDelete", "false"));
        try {
            DynamicObject[] draftBillArr;
            CdmBizResource cdmBizResource = new CdmBizResource();
            boolean isFromCasCancel = false;
            String cancelbycas = this.getOption().getVariableValue("cancelbycas", "");
            if (null != cancelbycas && "y".equals(cancelbycas)) {
                isFromCasCancel = true;
            }
            logger.info("isFromCasCancel is:" + isFromCasCancel);
            HashSet draftIds = new HashSet();
            HashMap<Long, Long> billIdAndTradeBillIdMap = new HashMap<Long, Long>();
            HashSet<Long> draftAllBillIdSet = new HashSet<Long>(8);
            ArrayList<DynamicObject> tradeBillDyList = new ArrayList<DynamicObject>(8);
            for (ExtendedDataEntity dataDy : dataEntity) {
                DynamicObject data = dataDy.getDataEntity();
                tradeBillDyList.add(data);
                String billno = data.getString("billno");
                logger.info("TradeBillDrawBillValidator validate billno is" + billno);
                DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
                for (DynamicObject entry : entrys) {
                    DynamicObject draftbill = entry.getDynamicObject("draftbill");
                    long draftBillId = draftbill.getLong("id");
                    String draftBillno = draftbill.getString("billno");
                    if (draftAllBillIdSet.contains(draftBillId)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u540c\u4e00\u6279\u6b21\u7684\u4e1a\u52a1\u5904\u7406\u5355\u786e\u8ba4\u5b8c\u6210\u65f6\u4e0d\u80fd\u5305\u542b\u540c\u4e00\u5f20\u7968\u636e%2$s\u3002", (String)"TradeBillDrawBillValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]), billno, draftBillno));
                    }
                    draftAllBillIdSet.add(draftBillId);
                    billIdAndTradeBillIdMap.put(draftBillId, data.getLong("id"));
                }
            }
            HashMap<Long, DynamicObject> draftIdToReceivableBillMap = new HashMap<Long, DynamicObject>(8);
            for (DynamicObject draftBill : draftBillArr = TmcDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,draftbilltranstatus,availableamount,draftbillstatus,rptype", (QFilter[])new QFilter[]{new QFilter("id", "in", draftAllBillIdSet)})) {
                draftIdToReceivableBillMap.put(draftBill.getLong("id"), draftBill);
            }
            Map resultMap = TradeBillHelper.lockByBillId((DynamicObject[])tradeBillDyList.toArray(new DynamicObject[0]), (String)BILLTYPE);
            succLockSet = (Set)resultMap.get("succLockSet");
            notNeedDealTradeBIllSet = (Set)resultMap.get("notNeedDealTradeBIllSet");
            Set billIdSet = billIdAndTradeBillIdMap.keySet();
            HashSet tradeBillIdSet = new HashSet(billIdAndTradeBillIdMap.values());
            Map splittradebillidMap = TradeBillHelper.getTradeBillIdAndSubBillMap(billIdSet, tradeBillIdSet);
            HashSet<String> needSkpiSet = new HashSet<String>(8);
            boolean isNeedSkip = false;
            for (ExtendedDataEntity data : dataEntity) {
                DynamicObjectCollection pledgebillArr;
                long registerCount;
                HashSet hashSet;
                QFilter qFilterId;
                QFilter qFilterStatus;
                Object[] dynamicObjects;
                HashSet hashSet2;
                Object[] occDraftsBills;
                Map botpMap;
                DynamicObjectCollection paybills;
                DynamicObject entry;
                String draftBillStatus;
                DynamicObjectCollection entryColl;
                Set draftIdSet;
                DynamicObjectCollection recBillSet;
                DynamicObjectCollection endorseEntryColl;
                String draftbillstatus;
                String billStatus;
                DynamicObject tradeBill = data.getDataEntity();
                boolean isEqualSplit = tradeBill.getBoolean("isequalsplit");
                boolean isDrawFail = tradeBill.getBoolean("isdrawfail");
                String tradeTypeStr = tradeBill.getString("tradetype");
                if (!DraftTradeTypeEnum.ENDORSE.getValue().equalsIgnoreCase(tradeTypeStr) && !DraftTradeTypeEnum.DISCOUNT.getValue().equalsIgnoreCase(tradeTypeStr) && !DraftTradeTypeEnum.PLEDGE.getValue().equalsIgnoreCase(tradeTypeStr) && isDrawFail) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u7c7b\u578b\u4e0d\u652f\u6301\u786e\u8ba4\u5931\u8d25", (String)"TradeBillDrawBillValidator_5_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
                String draftTradeBillId = tradeBill.getString("id");
                if (notNeedDealTradeBIllSet.contains(draftTradeBillId)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5bf9\u5e94\u7684\u7968\u636e\u6b63\u5728\u786e\u8ba4\u5b8c\u6210\u6216\u8005\u63d0\u4ea4\u7535\u7968\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"TradeBillDrawBillValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
                boolean elecTag = tradeBill.getBoolean("electag");
                String tradeBillBillno = tradeBill.getString("billno");
                if (!isFromRejectRefundGenDelete && elecTag) {
                    if (!isDrawFail) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u672a\u63d0\u4ea4\u7684\u7535\u7968\u624d\u5141\u8bb8\u53d6\u6d88\u5b8c\u6210\u3002", (String)"TrdBillCancelDrawValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    } else {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u662f\u5426\u63d0\u4ea4\u7535\u7968\u4e3a\u5426\u624d\u5141\u8bb8\u53d6\u6d88\u5931\u8d25", (String)"TradeBillDrawBillValidator_3_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                }
                if (!"C".equals(billStatus = tradeBill.getString("billstatus"))) {
                    if (isDrawFail) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u5141\u8bb8\u53d6\u6d88\u5931\u8d25", (String)"TrdBillCancelDrawValidator_1_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    } else {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u5141\u8bb8\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                }
                if (DraftTradeTypeEnum.ENDORSE.getValue().equalsIgnoreCase(tradeTypeStr) && !isDrawFail) {
                    boolean isFromCas;
                    String souceStr = tradeBill.getString("source");
                    boolean isrepaygen = tradeBill.getBoolean("isrepaygen");
                    Long sourcebillId = tradeBill.getLong("sourcebillid");
                    boolean isFromCasSource = SourceEnum.CAS.getValue().equals(souceStr);
                    boolean existsPayBill = QueryServiceHelper.exists((String)"cas_paybill", (Object)sourcebillId);
                    boolean bl = isFromCas = isFromCasSource || isrepaygen && existsPayBill;
                    if (!isFromCas) {
                        boolean isHasCasBill;
                        Map botpMap2;
                        ArrayList<Long> idSet = new ArrayList<Long>();
                        long drafttradeId = tradeBill.getLong("id");
                        idSet.add(drafttradeId);
                        Map botpMapById = TmcBotpHelper.getSourceBillIdMap((String)"cdm_drafttradebill", idSet, null, null, (boolean)true);
                        if (EmptyUtil.isNoEmpty((Object)botpMapById) && botpMapById.size() > 0 && EmptyUtil.isNoEmpty((Object)(botpMap2 = (Map)botpMapById.get(drafttradeId))) && botpMap2.size() > 0 && (isHasCasBill = botpMap2.containsKey("cas_paybill"))) {
                            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e %s \u5df2\u88ab\u51fa\u7eb3\u4ed8\u6b3e\u5355\u5173\u8054,\u4e0d\u5141\u8bb8\u53d6\u6d88\u5b8c\u6210\u3002", (String)"TrdBillCancelDrawValidator_14", (String)"tmc-cdm-business", (Object[])new Object[0]), tradeBillBillno));
                        }
                    }
                }
                String draftBillTranStatus = tradeBill.getString("draftbilltranstatus");
                if (!(isFromRejectRefundGenDelete || DraftTranStatusEnum.SUCCESS.getValue().equals(draftBillTranStatus) || isDrawFail)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e3a\u4ea4\u6613\u6210\u529f\u624d\u5141\u8bb8\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                if (!DraftTranStatusEnum.FAILING.getValue().equals(draftBillTranStatus) && isDrawFail) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e3a\u4ea4\u6613\u6210\u529f\u624d\u5141\u8bb8\u53d6\u6d88\u5931\u8d25", (String)"TrdBillCancelDrawValidator_0_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                DynamicObjectCollection entrys = tradeBill.getDynamicObjectCollection("entrys");
                DynamicObject drafttype = tradeBill.getDynamicObject("drafttype");
                HashSet<Long> draftBillIdSet = new HashSet<Long>(16);
                for (DynamicObject entry2 : entrys) {
                    DynamicObject draftbill = entry2.getDynamicObject("draftbill");
                    long billLogId = entry2.getLong("billlogid");
                    long draftBillId = draftbill.getLong("id");
                    draftBillIdSet.add(draftBillId);
                    String billmedium = drafttype.getString("billmedium");
                    DynamicObject draftBillDy = (DynamicObject)draftIdToReceivableBillMap.get(draftBillId);
                    String draftBillno = draftbill.getString("billno");
                    if ("2".equals(billmedium)) {
                        String draftBillTranstatus = draftBillDy.getString("draftbilltranstatus");
                        boolean isHandling = DraftTranStatusEnum.HANDLEING.getValue().equals(draftBillTranstatus);
                        if (isHandling) {
                            if (isDrawFail) {
                                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5bf9\u5e94\u7684\u7968\u636e %s \u72b6\u6001\u4e3a\u7535\u7968\u5904\u7406\u4e2d\uff0c\u4e0d\u80fd\u53d6\u6d88\u5931\u8d25", (String)"TradeBillDrawBillValidator_0_1_6", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                            } else {
                                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5bf9\u5e94\u7684\u7968\u636e %s \u72b6\u6001\u4e3a\u7535\u7968\u5904\u7406\u4e2d\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TradeBillDrawBillValidator_0_1_3", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                            }
                            needSkpiSet.add(draftTradeBillId);
                        }
                    }
                    if (DraftTradeTypeEnum.PAYINTEREST.getValue().equalsIgnoreCase(tradeTypeStr)) {
                        String draftStatusStr = draftBillDy.getString("draftbillstatus");
                        String rpTypeStr = draftBillDy.getString("rptype");
                        if ("receivebill".equals(rpTypeStr)) {
                            if (!"endorsed".equals(draftStatusStr)) {
                                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5bf9\u5e94\u7684\u7968\u636e %s \u4e0d\u662f\u5df2\u80cc\u4e66\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TradeBillDrawBillValidator_0_1_9", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                            }
                        } else if (!"registered".equals(draftStatusStr)) {
                            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5bf9\u5e94\u7684\u7968\u636e %s \u4e0d\u662f\u5df2\u767b\u8bb0\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TradeBillDrawBillValidator_0_1_8", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                        }
                    }
                    BigDecimal availableamount = draftBillDy.getBigDecimal("availableamount");
                    if (isFromRejectRefundGenDelete || BigDecimal.ZERO.compareTo(availableamount) <= 0) continue;
                    if (isDrawFail) {
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5bf9\u5e94\u7684\u7968\u636e %s \u53ef\u7528\u91d1\u989d\u5c0f\u4e8e0\uff0c\u4e0d\u80fd\u53d6\u6d88\u5931\u8d25", (String)"TradeBillDrawBillValidator_0_1_7", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                    } else {
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5bf9\u5e94\u7684\u7968\u636e %s \u53ef\u7528\u91d1\u989d\u5c0f\u4e8e0\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TradeBillDrawBillValidator_0_1_2", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                    }
                    needSkpiSet.add(draftTradeBillId);
                }
                if (EmptyUtil.isNoEmpty(needSkpiSet)) {
                    needSkpiSet.clear();
                    continue;
                }
                Map<Long, DynamicObject> tradeDraftIdAndDyMap = this.getTradeDraftMap(entrys);
                Map<Object, Object> draftIdAndLogIdColl = new HashMap(16);
                Map<Object, Object> logIdAndCreateMap = new HashMap(16);
                if (DraftTradeTypeEnum.REFUND.getValue().equalsIgnoreCase(tradeTypeStr)) {
                    DynamicObjectCollection allDraftIdLogColl = QueryServiceHelper.query((String)"cdm_draftbill_log", (String)"id,draftid,createtime,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("draftid", "in", draftBillIdSet), new QFilter("deleteflag", "!=", (Object)"1")});
                    draftIdAndLogIdColl = allDraftIdLogColl.stream().collect(Collectors.groupingBy(e -> e.getLong("draftid")));
                    logIdAndCreateMap = allDraftIdLogColl.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getDate("createtime")));
                }
                for (DynamicObject entry3 : entrys) {
                    String claimnoticebillnoSup;
                    String claimnoticebillnoSub;
                    long supBillStartFlag;
                    long subBillEndFlag;
                    boolean isSerial;
                    DynamicObject maxCreateTimeDy;
                    List billLogColl;
                    DynamicObject draftbill = entry3.getDynamicObject("draftbill");
                    long logId = entry3.getLong("billlogid");
                    long draftBillId = draftbill.getLong("id");
                    draftbill = tradeDraftIdAndDyMap.get(draftBillId);
                    String draftBillno = draftbill.getString("billno");
                    if (EmptyUtil.isNoEmpty(draftIdAndLogIdColl) && EmptyUtil.isNoEmpty((Object)draftIdAndLogIdColl.get(draftBillId)) && (billLogColl = (List)draftIdAndLogIdColl.get(draftBillId)).size() > 1 && null != (maxCreateTimeDy = (DynamicObject)billLogColl.stream().filter(e -> this.casPayStr.contains(e.getString("sourcebilltype"))).max(Comparator.comparing(e -> e.getDate("createtime"))).orElse(null))) {
                        Date createtime = maxCreateTimeDy.getDate("createtime");
                        Date date = (Date)logIdAndCreateMap.get(logId);
                        if (null != createtime && null != date && createtime.after(date)) {
                            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5df2\u9009\u7968\u636e %s \u5728\u9000\u7968\u540e\u53c8\u53d1\u751f\u4e86\u4e1a\u52a1\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TradeBillDrawBillValidator_7_4", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                        }
                    }
                    long tradeBillId = tradeBill.getLong("id");
                    long billId = entry3.getDynamicObject("draftbill").getLong("id");
                    String keyStr = tradeBillId + "_" + billId;
                    Object[] subRecBillDy = (Object[])splittradebillidMap.get(keyStr);
                    if (!EmptyUtil.isNoEmpty((DynamicObject)subRecBillDy) || !isEqualSplit) continue;
                    BigDecimal bigDecimal = subRecBillDy.getBigDecimal("lockedamount");
                    DynamicObjectCollection hasDeal = QueryServiceHelper.query((String)"cdm_draftbill_log", (String)"id,draftid,updatebizbillid", (QFilter[])new QFilter[]{new QFilter("draftid", "=", (Object)subRecBillDy.getLong("id")), new QFilter("deleteflag", "!=", (Object)"1")});
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)hasDeal)) {
                        if (BigDecimal.ZERO.compareTo(bigDecimal) != 0) {
                            if (isDrawFail) {
                                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5df2\u9009\u7968\u636e %s \u7b49\u5206\u5316\u751f\u6210\u7684\u7968\u636e\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u53d6\u6d88\u5931\u8d25", (String)"TradeBillDrawBillValidator_7_3", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                            } else {
                                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5df2\u9009\u7968\u636e %s \u7b49\u5206\u5316\u751f\u6210\u7684\u7968\u636e\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TradeBillDrawBillValidator_7", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                            }
                            isNeedSkip = true;
                            break;
                        }
                        if (isDrawFail) {
                            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5df2\u9009\u7968\u636e %s \u7b49\u5206\u5316\u751f\u6210\u7684\u7968\u636e\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u53d6\u6d88\u5931\u8d25", (String)"TradeBillDrawBillValidator_7_6", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                            isNeedSkip = true;
                            break;
                        }
                    }
                    boolean bl = isSerial = (subBillEndFlag = subRecBillDy.getLong("subbillendflag")) + 1L == (supBillStartFlag = draftbill.getLong("subbillstartflag"));
                    if (!isSerial) {
                        if (isDrawFail) {
                            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5df2\u9009\u7968\u636e %s \u7b49\u5206\u5316\u751f\u6210\u7684\u7968\u636e\u4e0e\u539f\u7968\u636e\u533a\u95f4\u4e0d\u8fde\u7eed\uff0c\u4e0d\u80fd\u53d6\u6d88\u5931\u8d25", (String)"TradeBillDrawBillValidator_8_4", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                        } else {
                            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5df2\u9009\u7968\u636e %s \u7b49\u5206\u5316\u751f\u6210\u7684\u7968\u636e\u4e0e\u539f\u7968\u636e\u533a\u95f4\u4e0d\u8fde\u7eed\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TradeBillDrawBillValidator_8", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                        }
                        isNeedSkip = true;
                        break;
                    }
                    draftbillstatus = draftbill.getString("draftbillstatus");
                    if (!DraftBillStatusEnum.REGISTERED.getValue().equals(draftbillstatus)) {
                        if (isDrawFail) {
                            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5df2\u9009\u7968\u636e %s \u7b49\u5206\u5316\u62c6\u5206\u540e\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u767b\u8bb0\uff0c\u4e0d\u80fd\u53d6\u6d88\u5931\u8d25", (String)"TradeBillDrawBillValidator_9_1", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                        } else {
                            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5df2\u9009\u7968\u636e %s \u7b49\u5206\u5316\u62c6\u5206\u540e\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u767b\u8bb0\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TradeBillDrawBillValidator_9", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                        }
                        isNeedSkip = true;
                        break;
                    }
                    String rptype = subRecBillDy.getString("rptype");
                    if ("receivebill".equals(rptype) && !(claimnoticebillnoSub = subRecBillDy.getString("claimnoticebillno")).equals(claimnoticebillnoSup = draftbill.getString("claimnoticebillno"))) {
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5df2\u9009\u7968\u636e %s \u7b49\u5206\u5316\u62c6\u5206\u540e\u5355\u636e\u5df2\u7ecf\u91cd\u65b0\u53d1\u751f\u901a\u77e5\u8ba4\u9886\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TradeBillDrawBillValidator_9_2", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                    }
                    if (!DraftTradeTypeEnum.BILLSPLIT.getValue().equalsIgnoreCase(tradeTypeStr) && !isDrawFail) continue;
                    String subDraftbillstatus = subRecBillDy.getString("draftbillstatus");
                    String subBillno = subRecBillDy.getString("billno");
                    if (DraftBillStatusEnum.REGISTERED.getValue().equals(subDraftbillstatus)) continue;
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b49\u5206\u5316\u62c6\u5206\u540e\u7684\u5b50\u7968 %s  \u7684\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u767b\u8bb0\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210\u3002", (String)"TrdBillCancelDrawValidator_12", (String)"tmc-cdm-business", (Object[])new Object[0]), subBillno));
                    isNeedSkip = true;
                    break;
                }
                if (isNeedSkip) {
                    isNeedSkip = false;
                    logger.info("will skip this tradebill{}", (Object)tradeBillBillno);
                    continue;
                }
                Long draftEntryId = tradeBill.getLong("allocbillentryid");
                if (EmptyUtil.isNoEmpty((Long)draftEntryId)) {
                    if (isDrawFail) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u7968\u636e\u8c03\u5ea6\u4ea7\u751f\u7684\u80cc\u4e66\u4ea4\u6613\u4e0d\u80fd\u53d6\u6d88\u5931\u8d25\u3002", (String)"TrdBillCancelDrawValidator_13", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    } else {
                        this.addErrorMessage(data, cdmBizResource.getTraDraftAllocationCheck());
                    }
                }
                String tradeType = tradeBill.getString("tradetype");
                boolean isReFund = DraftTradeTypeEnum.REFUND.getValue().equals(tradeType);
                boolean isSplit = DraftTradeTypeEnum.BILLSPLIT.getValue().equals(tradeType);
                boolean isPayInterest = DraftTradeTypeEnum.PAYINTEREST.getValue().equals(tradeType);
                boolean isEndorse = DraftTradeTypeEnum.ENDORSE.getValue().equals(tradeType);
                boolean isPayOff = DraftTradeTypeEnum.PAYOFF.getValue().equals(tradeType);
                boolean isRetrieve = DraftTradeTypeEnum.RETRIEVE.getValue().equals(tradeType);
                boolean isDeductPosit = tradeBill.getBoolean("depositdeduct");
                if (isEndorse) {
                    endorseEntryColl = tradeBill.getDynamicObjectCollection("entrys");
                    for (DynamicObject endorseEntry : endorseEntryColl) {
                        DynamicObject entryDy = endorseEntry.getDynamicObject("draftbill");
                        if (!entryDy.getBoolean("ispayinterest")) continue;
                        if (isDrawFail) {
                            this.addErrorMessage(data, ResManager.loadKDString((String)"\u80cc\u4e66\u7684\u7968\u636e\u5df2\u7ecf\u4e70\u65b9\u4ed8\u606f\uff0c\u4e0d\u80fd\u53d6\u6d88\u5931\u8d25\u3002", (String)"TrdBillCancelDrawValidator_2_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                            break;
                        }
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u80cc\u4e66\u7684\u7968\u636e\u5df2\u7ecf\u4e70\u65b9\u4ed8\u606f\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210\u3002", (String)"TrdBillCancelDrawValidator_2_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                        break;
                    }
                    if (!isFromRejectRefundGenDelete) {
                        int endorsedCount;
                        HashSet<Long> billdSet = new HashSet<Long>(16);
                        String draftStatusStr = "endorsed";
                        if (isDrawFail) {
                            draftStatusStr = "registered";
                        }
                        if ((endorsedCount = this.getDraftBillStatus(endorseEntryColl, draftStatusStr, billdSet)) != endorseEntryColl.size()) {
                            this.addErrorMessage(data, ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_9_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                        }
                    }
                }
                if ((isReFund || isRetrieve) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(recBillSet = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", draftIdSet = (endorseEntryColl = tradeBill.getDynamicObjectCollection("entrys")).stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet())), new QFilter("draftbillstatus", "!=", (Object)"registered")})))) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u9009\u7968\u636e\u4e0d\u662f\u5df2\u767b\u8bb0\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210\u3002", (String)"TrdBillCancelDrawValidator_2_6_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                if (isSplit && EmptyUtil.isNoEmpty((DynamicObjectCollection)(entryColl = tradeBill.getDynamicObjectCollection("entrys"))) && !"splited".equals(draftBillStatus = (entry = (DynamicObject)entryColl.get(0)).getDynamicObject("draftbill").getString("draftbillstatus")) && !isEqualSplit) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u88ab\u62c6\u5206\u7684\u7968\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u62c6\u5206\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                String rpType = tradeBill.getString("rptype");
                Map<Long, BigDecimal> draftIdAndTranAmountMap = entrys.stream().collect(Collectors.toMap(e -> e.getDynamicObject("draftbill").getLong("id"), e -> e.getBigDecimal("billamt")));
                Set<Long> draftbillIds = draftIdAndTranAmountMap.keySet();
                if (ReceivePayTypeEnum.RECEIVEBILL.getValue().equals(rpType)) {
                    BigDecimal amount;
                    Object[] receivebills;
                    if (EmptyUtil.isNoEmpty(draftbillIds) && EmptyUtil.isNoEmpty((Object[])(receivebills = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,amount,availableamount,draftbillstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)draftbillIds.toArray(new Long[0]))})))) {
                        for (Object receivebill : receivebills) {
                            amount = receivebill.getBigDecimal("amount");
                            BigDecimal availableamount = receivebill.getBigDecimal("availableamount");
                            logger.info("amount:" + amount + ",availableamount:" + availableamount);
                            if (amount == null || availableamount == null || amount.compareTo(availableamount) >= 0) continue;
                            if (isDrawFail) {
                                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u636e\u5185\u7684\u7968\u636e\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u53d6\u6d88\u5931\u8d25", (String)"TrdBillCancelDrawValidator_10_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                                continue;
                            }
                            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u636e\u5185\u7684\u7968\u636e\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_10", (String)"tmc-cdm-business", (Object[])new Object[0]));
                        }
                    }
                    if (EmptyUtil.isNoEmpty((Object[])(receivebills = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,amount,availableamount,draftbillstatus", (QFilter[])new QFilter[]{new QFilter("equaltradebillid", "=", (Object)tradeBill.getLong("id"))})))) {
                        for (Object receivebill : receivebills) {
                            amount = receivebill.getBigDecimal("amount");
                            BigDecimal availableamount = receivebill.getBigDecimal("availableamount");
                            logger.info("sub amount:" + amount + ",availableamount:" + availableamount);
                            if (amount == null || availableamount == null || amount.compareTo(availableamount) == 0) continue;
                            if (isDrawFail) {
                                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u636e\u5185\u7684\u88ab\u62c6\u5206\u7968\u636e\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u53d6\u6d88\u5931\u8d25", (String)"TrdBillCancelDrawValidator_11_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                                continue;
                            }
                            if (draftBillIdSet.contains(receivebill.getLong("id"))) continue;
                            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u636e\u5185\u7684\u88ab\u62c6\u5206\u7968\u636e\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_11", (String)"tmc-cdm-business", (Object[])new Object[0]));
                        }
                    }
                } else if (EmptyUtil.isNoEmpty(draftbillIds) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(paybills = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,amount,billno,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)draftbillIds.toArray(new Long[0]))})))) {
                    for (DynamicObject dynamicObject : paybills) {
                        BigDecimal availableamount = dynamicObject.getBigDecimal("availableamount");
                        BigDecimal transAmount = draftIdAndTranAmountMap.get(dynamicObject.getLong("id"));
                        logger.info("sub availableamount:" + availableamount + ",transAmount :" + transAmount);
                        boolean isUnAvaiable = availableamount.subtract(transAmount).compareTo(BigDecimal.ZERO) < 0;
                        if (!isUnAvaiable) continue;
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u636e\u5185\u7684\u88ab\u62c6\u5206\u7968\u636e %s \u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_11_2", (String)"tmc-cdm-business", (Object[])new Object[0]), dynamicObject.getString("billno")));
                    }
                }
                if (!EmptyUtil.isEmpty((Object)(botpMap = BFTrackerServiceHelper.findTargetBills((String)"cdm_drafttradebill", (Long[])new Long[]{tradeBill.getLong("id")}))) && botpMap.size() > 0) {
                    if (!isSplit) {
                        QFilter qFilterBillStatus;
                        QFilter qFilterId2;
                        Object[] recBills;
                        HashSet ids = new HashSet(10);
                        HashSet hashSet3 = (HashSet)botpMap.get("cdm_receivablebill");
                        if (null != hashSet3 && hashSet3.size() > 0) {
                            ids.addAll(hashSet3);
                        }
                        if (null != ids && ids.size() > 0 && EmptyUtil.isNoEmpty((Object[])(recBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id", (QFilter[])new QFilter[]{qFilterId2 = new QFilter("id", "in", (Object)ids), qFilterBillStatus = new QFilter("billstatus", "!=", (Object)Character.valueOf('A'))})))) {
                            if (isDrawFail) {
                                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u975e\u6682\u5b58\u7684\u4e0b\u6e38\u5e94\u6536\u7968\u636e\u4e0d\u80fd\u53d6\u6d88\u5931\u8d25", (String)"TrdBillCancelDrawValidator_9_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                            } else {
                                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u975e\u6682\u5b58\u7684\u4e0b\u6e38\u5e94\u6536\u7968\u636e\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_9", (String)"tmc-cdm-business", (Object[])new Object[0]));
                            }
                        }
                    }
                    for (Map.Entry entry2 : botpMap.entrySet()) {
                        String entityNumber = (String)entry2.getKey();
                        HashSet targetBillIds = (HashSet)entry2.getValue();
                        Object[] targetBills = TmcDataServiceHelper.load((String)entityNumber, (String)"billno,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)targetBillIds), new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue())});
                        if (DraftTradeTypeEnum.PLEDGE.getValue().equals(tradeTypeStr) && "gm_pledgebill".equals(entityNumber) && EmptyUtil.isNoEmpty((Object[])targetBills)) {
                            if (isDrawFail) {
                                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u6709\u6548\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5931\u8d25\u3002", (String)"TrdBillCancelDrawValidator_9_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
                            } else {
                                this.addErrorMessage(data, cdmBizResource.getCancelTipExistTargetBill());
                            }
                        }
                        if (EmptyUtil.isEmpty((Object[])targetBills) && isReFund && "cas_paybill".equals(entityNumber) || EmptyUtil.isEmpty((Object[])targetBills) || "cas_bankjournal".equals(entityNumber) || isSplit || isPayInterest || isDeductPosit && isPayOff) continue;
                        if ("cas_paybill".equals(entityNumber)) {
                            List billstatusList = Arrays.stream(targetBills).filter(e -> !"G".equals(e.getString("billstatus"))).collect(Collectors.toList());
                            if (!EmptyUtil.isNoEmpty(billstatusList)) break;
                            Set billno = billstatusList.stream().map(e -> e.getString("billno")).collect(Collectors.toSet());
                            logger.info("billno is:" + SerializationUtils.toJsonString(billno));
                            if (isDrawFail) {
                                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u6709\u6548\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5931\u8d25\u3002", (String)"TrdBillCancelDrawValidator_9_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
                                break;
                            }
                            this.addErrorMessage(data, cdmBizResource.getCancelTipExistTargetBill());
                            break;
                        }
                        logger.info("entityNumber is:" + entityNumber + "id:" + SerializationUtils.toJsonString((Object)targetBillIds));
                        boolean isDiscard = this.isAllDiscardBill(entityNumber, (DynamicObject[])targetBills);
                        if (isFromCasCancel && "psd_schedulebill".equals(entityNumber) || isDiscard) break;
                        if (isDrawFail) {
                            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u6709\u6548\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5931\u8d25\u3002", (String)"TrdBillCancelDrawValidator_9_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
                            break;
                        }
                        this.addErrorMessage(data, cdmBizResource.getCancelTipExistTargetBill());
                        break;
                    }
                    if (isSplit) {
                        Object[] targetBills;
                        ArrayList splitSubBills = new ArrayList(8);
                        HashSet hashSet4 = (HashSet)botpMap.get("cdm_receivablebill");
                        HashSet payBillIds = (HashSet)botpMap.get("cdm_payablebill");
                        if (EmptyUtil.isNoEmpty((Object)hashSet4)) {
                            splitSubBills.addAll(hashSet4);
                        }
                        if (EmptyUtil.isNoEmpty((Object)payBillIds)) {
                            splitSubBills.addAll(payBillIds);
                        }
                        if (EmptyUtil.isNoEmpty((Object[])(targetBills = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"billno,rptype,billpool,locksourcebilltype,locksourcebillid,draftbillstatus,lockedamount,claimnoticebillno,supperbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", splitSubBills)})))) {
                            for (Object targetBill : targetBills) {
                                String lockBillTypeStr;
                                draftbillstatus = targetBill.getString("draftbillstatus");
                                BigDecimal lockedAmount = targetBill.getBigDecimal("lockedamount");
                                String draftBillno = targetBill.getString("billno");
                                if (EmptyUtil.isNoEmpty((BigDecimal)lockedAmount) && BigDecimal.ZERO.compareTo(lockedAmount) != 0) {
                                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5df2\u9009\u7968\u636e %s \u7b49\u5206\u5316\u751f\u6210\u7684\u7968\u636e\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TradeBillDrawBillValidator_7", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                                }
                                if (!"registered".equals(draftbillstatus)) {
                                    boolean isgenbysplit = tradeBill.getBoolean("isgenbysplit");
                                    String euqaldifferetype = tradeBill.getString("euqaldifferetype");
                                    String tradeTypeStatus = DraftHelper.tradeTypeStatus((String)euqaldifferetype);
                                    boolean isEqualStatus = draftbillstatus.equals(tradeTypeStatus);
                                    if (!isgenbysplit || !isEqualStatus) {
                                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u62c6\u5206\u540e\u7684\u7968\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u767b\u8bb0\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]));
                                    }
                                }
                                if (EmptyUtil.isNoEmpty((String)(lockBillTypeStr = targetBill.getString("locksourcebilltype")))) {
                                    if (lockBillTypeStr.startsWith("cas_")) {
                                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u62c6\u5206\u540e\u7684\u7968\u636e\u5df2\u88ab\u51fa\u7eb3\u5355\u636e\u4f7f\u7528\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]));
                                    }
                                    if (lockBillTypeStr.equals("cdm_drafttradebill")) {
                                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u62c6\u5206\u540e\u7684\u7968\u636e\u5df2\u88ab\u7968\u636e\u4e1a\u52a1\u5904\u7406\u5355\u636e\u4f7f\u7528\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]));
                                    }
                                    if (lockBillTypeStr.equals("psd_schedulebill")) {
                                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u62c6\u5206\u540e\u7684\u7968\u636e\u5df2\u88ab\u4ed8\u6b3e\u6392\u7a0b\u5355\u636e\u4f7f\u7528\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_8", (String)"tmc-cdm-business", (Object[])new Object[0]));
                                    }
                                }
                                if ("receivebill".equals(targetBill.getString("rptype")) && EmptyUtil.isNoEmpty((String)targetBill.getString("billpool"))) {
                                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u62c6\u5206\u540e\u7684\u7968\u636e\u5df2\u52a0\u5165\u7968\u636e\u6c60\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_7", (String)"tmc-cdm-business", (Object[])new Object[0]));
                                }
                                if (isEqualSplit) continue;
                                long supperbillid = targetBill.getLong("supperbillid");
                                DynamicObject supperDy = tradeDraftIdAndDyMap.get(supperbillid);
                                String claimnoticebillnoSup = supperDy.getString("claimnoticebillno");
                                String claimnoticebillnoSub = targetBill.getString("claimnoticebillno");
                                if (claimnoticebillnoSub.equals(claimnoticebillnoSup)) continue;
                                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5df2\u9009\u7968\u636e %s \u7b49\u5206\u5316\u62c6\u5206\u540e\u5355\u636e\u5df2\u7ecf\u91cd\u65b0\u53d1\u751f\u901a\u77e5\u8ba4\u9886\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TradeBillDrawBillValidator_9_2", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                            }
                            Object[] occOtherDedalBills = TmcDataServiceHelper.load((String)"cdm_drafttradebill", (String)"billno,tradetype", (QFilter[])new QFilter[]{new QFilter("entrys.draftbill", "in", (Object)splitSubBills.toArray(new Object[0])), new QFilter("id", "not in", tradeBill.getPkValue())});
                            if (!EmptyUtil.isEmpty((Object[])occOtherDedalBills)) {
                                this.addErrorMessage(data, ResManager.loadKDString((String)"\u62c6\u5206\u540e\u7684\u7968\u636e\u5df2\u53d1\u751f\u65b0\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CdmBizResource_35_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
                            }
                        }
                    }
                }
                if (!EmptyUtil.isEmpty((Object[])(occDraftsBills = TmcDataServiceHelper.load((String)"cdm_drafttradebill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("entrys.draftbill", "in", (Object)draftIds.toArray(new Object[0])), new QFilter("id", "not in", tradeBill.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"C", "S"})})))) {
                    if (isDrawFail) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u7968\u636e\u5df2\u53d1\u751f\u65b0\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5931\u8d25", (String)"TrdBillCancelDrawValidator_8_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    } else {
                        this.addErrorMessage(data, cdmBizResource.getTipNewBizHappen());
                    }
                }
                if (isPayOff && isDeductPosit && EmptyUtil.isNoEmpty((Object)(hashSet2 = (HashSet)botpMap.get("fbd_suretyreleasebill"))) && EmptyUtil.isNoEmpty((Object[])(dynamicObjects = BusinessDataServiceHelper.load((String)"fbd_suretyreleasebill", (String)"billstatus", (QFilter[])new QFilter[]{qFilterStatus = new QFilter("billstatus", "!=", (Object)"A"), qFilterId = new QFilter("id", "in", (Object)hashSet2)})))) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_7_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                if (DraftTradeTypeEnum.TRUSTEESHIP.getValue().equals(tradeTypeStr)) {
                    DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIdSet), new QFilter("draftbillstatus", "!=", (Object)"collocated")});
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u9009\u7968\u636e\u4e0d\u662f\u5df2\u6258\u7ba1\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210\u3002", (String)"TrdBillCancelDrawValidator_2_5", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    } else {
                        DynamicObjectCollection retrieveColl = this.getReleatedTradeBill(tradeBill, draftBillIdSet, "retrieve");
                        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)retrieveColl)) {
                            this.addErrorMessage(data, ResManager.loadKDString((String)"\u6240\u9009\u7968\u636e\u5b58\u5728\u540e\u7eed\u7684\u6258\u7ba1\u53d6\u56de\u4e1a\u52a1\u5904\u7406\u5355\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210\u3002", (String)"TrdBillCancelDrawValidator_2_6", (String)"tmc-cdm-business", (Object[])new Object[0]));
                        }
                    }
                }
                if ((DraftTradeTypeEnum.DISCOUNT.getValue().equals(tradeTypeStr) || DraftTradeTypeEnum.COLLECT.getValue().equals(tradeTypeStr)) && EmptyUtil.isNoEmpty((Object)(hashSet = (HashSet)botpMap.get("cas_recbill"))) && hashSet.size() > 0 && EmptyUtil.isNoEmpty((DynamicObjectCollection)(dynamicObjects = QueryServiceHelper.query((String)"cas_recbill", (String)"billstatus", (QFilter[])new QFilter[]{qFilterStatus = new QFilter("billstatus", "!=", (Object)"A"), qFilterId = new QFilter("id", "in", (Object)hashSet)})))) {
                    if (isDrawFail) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u975e\u6682\u5b58\u7684\u4e0b\u6e38\u6536\u6b3e\u5904\u7406\u4e0d\u80fd\u53d6\u6d88\u5931\u8d25\u3002", (String)"TrdBillCancelDrawValidator_7_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    } else {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u975e\u6682\u5b58\u7684\u4e0b\u6e38\u6536\u6b3e\u5904\u7406\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210\u3002", (String)"TrdBillCancelDrawValidator_7_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                }
                boolean bl = DraftTradeTypeEnum.PLEDGE.getValue().equals(tradeBill.getString("tradetype"));
                HashSet<Long> billdSet = new HashSet<Long>(8);
                if (bl) {
                    int rlspledgeCount;
                    String draftStatusStr = "pledged";
                    if (isDrawFail) {
                        draftStatusStr = "registered";
                    }
                    if ((rlspledgeCount = this.getDraftBillStatus(entrys, draftStatusStr, billdSet)) != entrys.size()) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_9_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                }
                if (isDrawFail) continue;
                this.checkSameDraftBillNo(data);
                boolean isRlspledge = DraftTradeTypeEnum.RLSPLEDGE.getValue().equals(tradeBill.getString("tradetype"));
                if (isRlspledge && (registerCount = entrys.stream().filter(o -> DraftBillStatusEnum.REGISTERED.getValue().equals(o.getDynamicObject("draftbill").getString("draftbillstatus"))).count()) != (long)entrys.size()) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210", (String)"TrdBillCancelDrawValidator_9_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                if (!bl || !EmptyUtil.isNoEmpty((DynamicObjectCollection)(pledgebillArr = this.getReleatedTradeBill(tradeBill, billdSet, "rlspledge")))) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6240\u9009\u7968\u636e\u5b58\u5728\u540e\u7eed\u7684\u8d28\u62bc\u89e3\u9664\u4e1a\u52a1\u5904\u7406\u5355\uff0c\u4e0d\u80fd\u53d6\u6d88\u5b8c\u6210\u3002", (String)"TrdBillCancelDrawValidator_2_4", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
        }
        catch (Exception e2) {
            logger.error("TradeBillDrawBillValidator has error", (Throwable)e2);
            throw e2;
        }
        finally {
            if (EmptyUtil.isNoEmpty(succLockSet)) {
                logger.info("will add succLockSet");
                this.successLockDraftIdList.addAll(succLockSet);
            }
        }
    }

    private int getDraftBillStatus(DynamicObjectCollection entrys, String draftStatus, Set<Long> billdSet) {
        DynamicObjectCollection peldgeColl;
        DynamicObjectCollection billlogColl;
        Set subBillIdSet;
        int rlspledgeCount = 0;
        HashSet<Long> billLogIdSet = new HashSet<Long>(8);
        for (DynamicObject entry : entrys) {
            boolean isneedsplit = entry.getBoolean("isneedsplit");
            if (isneedsplit) {
                long billlogid = entry.getLong("billlogid");
                billLogIdSet.add(billlogid);
                continue;
            }
            long draftBillId = entry.getDynamicObject("draftbill").getLong("id");
            billdSet.add(draftBillId);
        }
        if (EmptyUtil.isNoEmpty(billLogIdSet) && EmptyUtil.isNoEmpty(subBillIdSet = (billlogColl = QueryServiceHelper.query((String)"cdm_draftbill_log", (String)"id,issplit,splitedsubbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", billLogIdSet)})).stream().filter(e -> e.getBoolean("issplit")).map(e -> e.getLong("splitedsubbillid")).collect(Collectors.toSet()))) {
            billdSet.addAll(subBillIdSet);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(peldgeColl = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", billdSet), new QFilter("draftbillstatus", "=", (Object)draftStatus)})))) {
            rlspledgeCount = peldgeColl.size();
        }
        return rlspledgeCount;
    }

    private DynamicObjectCollection getReleatedTradeBill(DynamicObject tradeBill, Set<Long> billdSet, String tradeTypeStr) {
        QFilter qFilter1 = new QFilter("entrys.draftbill", "in", billdSet);
        QFilter qFilter2 = new QFilter("tradetype", "=", (Object)tradeTypeStr);
        QFilter qFilter3 = new QFilter("billstatus", "!=", (Object)"S");
        QFilter qFilter4 = new QFilter("createtime", ">", (Object)tradeBill.getDate("createtime"));
        DynamicObjectCollection pledgebillArr = QueryServiceHelper.query((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4});
        return pledgebillArr;
    }

    private Map<Long, DynamicObject> getTradeDraftMap(DynamicObjectCollection entrys) {
        HashSet<Long> draftIdSet = new HashSet<Long>(16);
        for (DynamicObject entry : entrys) {
            DynamicObject draftbill = entry.getDynamicObject("draftbill");
            long draftBillId = draftbill.getLong("id");
            draftIdSet.add(draftBillId);
        }
        DynamicObjectCollection draftsColl = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,billno,subbillstartflag,draftbillstatus,claimnoticebillno", (QFilter[])new QFilter[]{new QFilter("id", "in", draftIdSet)});
        Map<Long, DynamicObject> tradeDraftIdAndDyMap = draftsColl.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        return tradeDraftIdAndDyMap;
    }

    private void checkSameDraftBillNo(ExtendedDataEntity data) {
        DynamicObject tradeBill = data.getDataEntity();
        boolean isEndorse = DraftTradeTypeEnum.ENDORSE.getValue().equals(tradeBill.getString("tradetype"));
        if (isEndorse) {
            DynamicObjectCollection entrys = tradeBill.getDynamicObjectCollection("entrys");
            List draftBillIdList = entrys.stream().map(v -> v.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList());
            DynamicObject[] draftBills = TmcDataServiceHelper.load((Object[])draftBillIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
            HashMap draftBillMap = Arrays.stream(draftBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
            for (DynamicObject entry : entrys) {
                long draftBillId = entry.getDynamicObject("draftbill").getLong("id");
                DynamicObject draftBill = (DynamicObject)draftBillMap.get(draftBillId);
                this.checkSameDraftBillNo(draftBill, data);
            }
        }
    }

    private void checkSameDraftBillNo(DynamicObject draftBill, ExtendedDataEntity data) {
        CdmBizResource cdmBizResource = new CdmBizResource();
        DynamicObject tradeBill = data.getDataEntity();
        String draftTradeBillId = tradeBill.getString("id");
        String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
        String ignorejudgereArr = (String)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)draftBill.getLong("company.id"), (String)"ignorejudgere");
        boolean needJudgeRep = EmptyUtil.isEmpty((String)ignorejudgereArr) || !ignorejudgereArr.contains("rec");
        DynamicObject draftbilltypeDO = draftBill.getDynamicObject("draftbilltype");
        boolean split = draftBill.getBoolean("issplit");
        String settlementtype = draftbilltypeDO.getString("settlementtype");
        boolean isSupportSplit = settlementtype.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementtype.equals(SettleMentTypeEnum.BANK.getValue());
        String subBillRange = draftBill.getString("subbillrange");
        String draftBillNo = draftBill.getString("draftbillno");
        DynamicObject drawerBankObj = draftBill.getDynamicObject("drawerbank");
        logger.info("drawerBankObj is null:" + EmptyUtil.isEmpty((DynamicObject)drawerBankObj));
        if (EmptyUtil.isEmpty((DynamicObject)drawerBankObj)) {
            return;
        }
        QFilter filters = new QFilter("draftbillno", "=", (Object)draftBillNo);
        if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementtype) || SettleMentTypeEnum.BANK.getValue().equals(settlementtype)) {
            String[] types = new String[]{SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue()};
            filters.and(new QFilter("draftbilltype.settlementtype", "in", (Object)types));
        } else {
            filters.and(new QFilter("draftbilltype.settlementtype", "=", (Object)settlementtype));
        }
        filters.and(new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue()));
        filters.and(new QFilter("billstatus", "!=", (Object)"H"));
        filters.and(new QFilter("id", "!=", draftBill.getPkValue()));
        filters.and(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
        filters.and(new QFilter("sourcebilltype", "!=", (Object)"cdm_drafttradebill"));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,issplit,drawerbank,subbillrange", (QFilter[])new QFilter[]{filters});
        if (!isSupportSplit && bills.length > 0) {
            logger.info("bills size is:" + bills.length);
            this.addErrorMessage(data, cdmBizResource.getCancelSameDraftBillCheck());
        }
        if (needJudgeRep && isSupportSplit && !split && bills.length > 0) {
            logger.info("isSupportSplit bills size is:" + bills.length);
            this.addErrorMessage(data, cdmBizResource.getCancelSameDraftBillCheck());
        }
        boolean isExistNoSplit = false;
        for (DynamicObject dynamicObject : bills) {
            boolean isSplitDb = dynamicObject.getBoolean("issplit");
            if (isSplitDb) continue;
            isExistNoSplit = true;
            break;
        }
        if (needJudgeRep && isSupportSplit && split && isExistNoSplit) {
            logger.info("isExistNoSplit bills");
            this.addErrorMessage(data, cdmBizResource.getCancelSameDraftBillCheck());
        }
        if (isSupportSplit && split && StringUtils.isNotEmpty((CharSequence)subBillRange) && subBillRange.contains("-")) {
            Long startFlag = Long.valueOf(subBillRange.split("-")[0]);
            Long endFlag = Long.valueOf(subBillRange.split("-")[1]);
            for (DynamicObject bill : bills) {
                Long idDo;
                boolean isEqualBill;
                DynamicObject[] finOrgInfoBills = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id,bank_cate", (QFilter[])new QFilter[]{new QFilter("bebank", "=", drawerBankObj.getPkValue())});
                String subBillRangeFrombase = bill.getString("subbillrange");
                boolean isSameSubBillRange = this.isRepeatDraftBillNo(subBillRangeFrombase, startFlag, endFlag);
                logger.info("isSameSubBillRange is:" + isSameSubBillRange);
                if (finOrgInfoBills.length == 0) {
                    String number = drawerBankObj.getString("number");
                    number = number.substring(0, Math.min(number.length(), 3));
                    DynamicObject billdrawerbank = bill.getDynamicObject("drawerbank");
                    if (null == billdrawerbank || null == billdrawerbank.getString("number") || !billdrawerbank.getString("number").startsWith(number) || !isSameSubBillRange) continue;
                    logger.info("billdrawerbank number is:" + billdrawerbank.getString("number") + ",number:" + number);
                    this.addErrorMessage(data, cdmBizResource.getCancelSameDraftBillCheck());
                    continue;
                }
                DynamicObject bankCate = finOrgInfoBills[0].getDynamicObject("bank_cate");
                boolean bl = isEqualBill = draftBill.getBoolean("isfromequalspilt") && draftBill.getBoolean("isequalbill");
                if (EmptyUtil.isEmpty((DynamicObject)bankCate) || isEqualBill) continue;
                Long id = bankCate.getLong("id");
                DynamicObject drawerBankDo = bill.getDynamicObject("drawerbank");
                if (drawerBankDo == null) continue;
                DynamicObject[] finOrgInfoBillDos = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id,bank_cate", (QFilter[])new QFilter[]{new QFilter("bebank", "=", drawerBankDo.getPkValue())});
                DynamicObject bankCateDo = null;
                if (finOrgInfoBillDos != null && finOrgInfoBillDos.length > 0) {
                    bankCateDo = finOrgInfoBillDos[0].getDynamicObject("bank_cate");
                }
                if (bankCateDo == null || id.compareTo(idDo = Long.valueOf(bankCateDo.getLong("id"))) != 0 || !isSameSubBillRange) continue;
                logger.info("idDo is:" + id);
                this.addErrorMessage(data, cdmBizResource.getCancelSameDraftBillCheck());
            }
        }
    }

    private boolean isRepeatDraftBillNo(String subBillRangeDb, Long startFlag, Long endFlag) {
        if (StringUtils.isEmpty((CharSequence)subBillRangeDb) || !subBillRangeDb.contains("-")) {
            return false;
        }
        Long startFlagDb = Long.valueOf(subBillRangeDb.split("-")[0]);
        Long endFlagDb = Long.valueOf(subBillRangeDb.split("-")[1]);
        boolean isRepeat = startFlag >= startFlagDb && startFlag <= endFlagDb || endFlag >= startFlagDb && endFlag <= endFlagDb || startFlag <= startFlagDb && endFlag >= endFlagDb;
        return isRepeat;
    }

    private boolean isAllDiscardBill(String entityNumber, DynamicObject[] targetBills) {
        List billstatusDys;
        boolean isAllDiscard = true;
        if ("cdm_drafttradebill".equals(entityNumber) && EmptyUtil.isNoEmpty(billstatusDys = Arrays.stream(targetBills).filter(e -> !BillStatusEnum.DISCARD.getValue().equals(e.getString("billstatus"))).collect(Collectors.toList()))) {
            isAllDiscard = false;
        }
        logger.info("isAllDiscard is:" + isAllDiscard);
        return isAllDiscard;
    }
}

