/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.tradebill;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class TrdBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    private static final List<String> PAYBILLSTATAUS = Arrays.asList("H", "G");

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("allocbillentryid");
        selector.add("draftbilltranstatus");
        selector.add("entrys");
        selector.add("entrys.transtatus");
        selector.add("entrys.draftbill");
        selector.add("company");
        selector.add("electag");
        selector.add("isrejectrefund");
        selector.add("isrepay");
        selector.add("isdrawfail");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        CdmBizResource cdmBizResource = new CdmBizResource();
        HashSet draftIds = new HashSet();
        for (ExtendedDataEntity data : dataEntity) {
            Object[] occDraftsBills;
            Map botpMap;
            boolean isdrawfail;
            Long draftEntryId;
            DynamicObject tradeBill = data.getDataEntity();
            String draftBillTranStatus = tradeBill.getString("draftbilltranstatus");
            if (kd.bos.util.StringUtils.isNotEmpty((String)draftBillTranStatus) && !"failing".equalsIgnoreCase(draftBillTranStatus)) {
                this.addErrorMessage(data, cdmBizResource.getTradeBillUnAuditMsg());
            }
            if (EmptyUtil.isNoEmpty((Long)(draftEntryId = Long.valueOf(tradeBill.getLong("allocbillentryid"))))) {
                this.addErrorMessage(data, cdmBizResource.getTraDraftAllocationCheck());
            }
            if (isdrawfail = tradeBill.getBoolean("isdrawfail")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25\u7684\u4e1a\u52a1\u5904\u7406\u5355\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"TradeBillRejectRefundValidator_5_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isEmpty((Object)(botpMap = BFTrackerServiceHelper.findTargetBills((String)"cdm_drafttradebill", (Long[])new Long[]{tradeBill.getLong("id")}))) && botpMap.size() > 0) {
                for (Map.Entry entry : botpMap.entrySet()) {
                    HashSet targetBillIds;
                    String entityNumber = (String)entry.getKey();
                    Object[] targetBills = TmcDataServiceHelper.load((String)entityNumber, (String)"billno,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)(targetBillIds = (HashSet)entry.getValue())), new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue())});
                    if (EmptyUtil.isEmpty((Object[])targetBills) || "cas_bankjournal".equals(entityNumber)) continue;
                    if ("cas_paybill".equals(entityNumber)) {
                        List billstatusList = Arrays.stream(targetBills).filter(e -> !PAYBILLSTATAUS.contains(e.getString("billstatus"))).collect(Collectors.toList());
                        if (!EmptyUtil.isNoEmpty(billstatusList)) break;
                        this.addErrorMessage(data, cdmBizResource.getTipExistTargetbill());
                        break;
                    }
                    this.addErrorMessage(data, cdmBizResource.getTipExistTargetbill());
                    break;
                }
            }
            if (!EmptyUtil.isEmpty((Object[])(occDraftsBills = TmcDataServiceHelper.load((String)"cdm_drafttradebill", (String)"billno,entrys.draftbill", (QFilter[])new QFilter[]{new QFilter("entrys.draftbill", "in", (Object)draftIds.toArray(new Object[0])), new QFilter("id", "not in", tradeBill.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"C", "S"})})))) {
                this.addErrorMessage(data, cdmBizResource.getTipNewBizHappen());
            }
            boolean isRejectRefund = tradeBill.getBoolean("isrejectrefund");
            boolean repay = tradeBill.getBoolean("isrepay");
            if (!isRejectRefund && !repay || !StringUtils.equals((CharSequence)draftBillTranStatus, (CharSequence)DraftTranStatusEnum.FAILING.getValue())) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u5931\u8d25\u91cd\u4ed8\u6216\u62d2\u6536\u9000\u7968\u7684\u4e1a\u52a1\u5904\u7406\u4e0d\u80fd\u53cd\u5ba1\u6838", (String)"TradeBillRejectRefundValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

