/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.helper;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.report.helper.RptFilterParamHelper;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillEndorseHelper {
    public static QFilter initEndorseFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping, List<Long> orgIds) {
        String endorserType;
        QFilter qFilter;
        String endorseFlow;
        QFilter billMediumFilter;
        QFilter dateRangeFilter;
        QFilter billTypeFilter;
        QFilter filter = new QFilter("company.id", "in", orgIds);
        QFilter currencyFilter = RptFilterParamHelper.initCurrencyFilter(paramMap, propertyMapping);
        if (currencyFilter != null) {
            filter = filter.and(currencyFilter);
        }
        if ((billTypeFilter = BillEndorseHelper.initDraftTypeFilter(paramMap, propertyMapping)) != null) {
            filter = filter.and(billTypeFilter);
        }
        if ((dateRangeFilter = BillEndorseHelper.initDateRange(paramMap, propertyMapping)) != null) {
            filter = filter.and(dateRangeFilter);
        }
        if ((billMediumFilter = BillEndorseHelper.draftMediumFilter(paramMap, propertyMapping)) != null) {
            filter = filter.and(billMediumFilter);
        }
        if ("internal".equals(endorseFlow = (String)paramMap.get("endorseflow"))) {
            qFilter = new QFilter("payeetypetext", "in", (Object)new String[]{"bos_org", "bd_supplier", "bd_customer"});
            filter.and(qFilter);
        }
        if ("external".equals(endorseFlow)) {
            qFilter = new QFilter("payeetypetext", "in", (Object)new String[]{"other", "bos_user", "bd_supplier", "bd_customer"});
            filter.and(qFilter);
        }
        if (StringUtils.isNotEmpty((CharSequence)(endorserType = (String)paramMap.get("endorsertype"))) && "others".equals(endorserType)) {
            String beEndorserTexts = (String)paramMap.get("beendorsertext");
            String[] beEndorserText = beEndorserTexts.split(",");
            filter.and(new QFilter("beendorsortext", "in", (Object)beEndorserText));
        }
        if (StringUtils.isNotEmpty((CharSequence)endorserType) && !"others".equals(endorserType)) {
            DynamicObject beEndorser = (DynamicObject)paramMap.get("beendorser");
            String text = beEndorser.getString("name");
            filter.and(new QFilter("beendorsortext", "=", (Object)text));
        }
        return filter;
    }

    private static QFilter initDateRange(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        String property = "bizdate";
        if (propertyMapping != null && propertyMapping.containsKey("filter_dateranges")) {
            property = propertyMapping.get("filter_dateranges");
        }
        QFilter filter = null;
        String dateRange = String.valueOf(paramMap.get("filter_dateranges"));
        if (!EmptyUtil.isEmpty((String)dateRange)) {
            filter = RptDateRangeEnum.CUSTOM.getValue().equals(dateRange) ? new QFilter(property, ">=", paramMap.get("filter_dateranges_startdate")).and(new QFilter(property, "<=", paramMap.get("filter_dateranges_enddate"))) : new QFilter(property, ">=", (Object)BillEndorseHelper.explainStartDate(dateRange)).and(new QFilter(property, "<=", (Object)BillEndorseHelper.explainEndDate(dateRange)));
        }
        return filter;
    }

    private static Date explainStartDate(String dateStr) {
        Date startDate = null;
        Timestamp currentTime = DateUtils.getCurrentTime();
        switch (dateStr) {
            case "thismonth": {
                startDate = DateUtils.getMinMonthDate((Date)new Date());
                break;
            }
            case "thisquarter": {
                startDate = DateUtils.getFirstSeasonDate((Date)DateUtils.getCurrentDate());
                break;
            }
            case "sixmonth": {
                startDate = DateUtils.getLastMonth((Date)currentTime, (int)6);
                break;
            }
            case "oneyear": {
                startDate = DateUtils.getLastYear((Date)currentTime, (int)1);
                break;
            }
            case "twoyear": {
                startDate = DateUtils.getLastYear((Date)currentTime, (int)2);
                break;
            }
        }
        return startDate;
    }

    private static Date explainEndDate(String dateStr) {
        Date endDate = new Date();
        switch (dateStr) {
            case "thismonth": {
                endDate = DateUtils.getMaxMonthDate((Date)DateUtils.getCurrentDate());
                break;
            }
            case "thisquarter": {
                endDate = DateUtils.getLastSeasonDate((Date)DateUtils.getCurrentDate());
                break;
            }
        }
        return endDate;
    }

    public static QFilter initDraftTypeFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        String property = "drafttype.id";
        if (propertyMapping != null && propertyMapping.containsKey("filter_billtypebase")) {
            property = propertyMapping.get("filter_billtypebase");
        }
        return RptFilterParamHelper.f7MultiSelectFilter(paramMap, "filter_billtypebase", property);
    }

    public static QFilter draftMediumFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        String property = "drafttype.billmedium";
        if (propertyMapping != null && propertyMapping.containsKey("filter_billmedium")) {
            property = propertyMapping.get("filter_billmedium");
        }
        return RptFilterParamHelper.selectFilter(paramMap, "filter_billmedium", property);
    }
}

