/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.BillStatusEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.report.constant.BillDynamicQueryDetailProp;
import kd.tmc.cdm.report.constant.DraftDynamicQueryParam;
import kd.tmc.cdm.report.helper.OrgHelper;
import kd.tmc.cdm.report.helper.ReportCommonHelper;
import kd.tmc.cdm.report.helper.ReportDataHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftDynamicQueryReportHelper {
    private static final String[] tradeBillSelector = new String[]{"id as tradeId", "draftbillid", "tradetype", "billamt", "createtime as tradeBillCreateTime"};
    private static final Log log = LogFactory.getLog(DraftDynamicQueryReportHelper.class);

    public static Set<Long> queryDraftBillIds(String paramStr) {
        DraftDynamicQueryParam queryParam = (DraftDynamicQueryParam)JSON.parseObject((String)paramStr, (TypeReference)new TypeReference<DraftDynamicQueryParam>(){}, (Feature[])new Feature[0]);
        DataSet dataSet = DraftDynamicQueryReportHelper.queryDataSet(queryParam, true);
        if (dataSet != null) {
            HashSet<Long> idSet = new HashSet<Long>(16);
            for (Row r : dataSet) {
                idSet.add(r.getLong("id"));
            }
            return idSet;
        }
        return null;
    }

    public static DataSet queryDataSet(DraftDynamicQueryParam queryParam, boolean isFromInventory) {
        Map<String, Object> transQueryParam = DraftDynamicQueryReportHelper.transQueryParamsToMap(queryParam);
        transQueryParam.put("filter_statdim", "company");
        Map<String, QFilter> filterMap = DraftDynamicQueryReportHelper.getFilter(transQueryParam, isFromInventory);
        return DraftDynamicQueryReportHelper.queryDataSetAndProcessResult(transQueryParam, filterMap);
    }

    public static DataSet queryDataSet(ReportQueryParam queryParam) {
        Map<String, Object> transQueryParam = ReportDataHelper.transQueryParam(queryParam);
        transQueryParam.put("orgIdList", DraftDynamicQueryReportHelper.getQueryOrgIds(queryParam, "filter_org", "filter_orgview"));
        Map<String, QFilter> filterMap = DraftDynamicQueryReportHelper.getFilter(transQueryParam, false);
        return DraftDynamicQueryReportHelper.queryDataSetAndProcessResult(transQueryParam, filterMap);
    }

    private static Map<String, Object> transQueryParamsToMap(DraftDynamicQueryParam queryParam) {
        HashMap<String, Object> transQueryParam = new HashMap<String, Object>(16);
        transQueryParam.put("filter_queryenddate", queryParam.getQueryEndDate());
        transQueryParam.put("filter_rptype", queryParam.getRpType());
        transQueryParam.put("orgIdList", EmptyUtil.isNoEmpty((Long)queryParam.getOrgId()) ? Collections.singletonList(queryParam.getOrgId()) : null);
        transQueryParam.put("bizdate_startdate", queryParam.getBizStartDate());
        transQueryParam.put("bizdate_enddate", queryParam.getBizEndDate());
        transQueryParam.put("bankAccountId", queryParam.getBankAccountId());
        transQueryParam.put("currencyId", queryParam.getCurrencyId());
        transQueryParam.put("filter_statpledge", queryParam.getStatPledge() == null || queryParam.getStatPledge() != false);
        return transQueryParam;
    }

    public static DataSet queryDataSetAndProcessResult(Map<String, Object> transQueryParam, Map<String, QFilter> filterMap) {
        DataSet draftBillDataSet = DraftDynamicQueryReportHelper.queryDraftBillDataSet(transQueryParam, filterMap.get("draftBillFilter"));
        DataSet tradeBillDataSet = DraftDynamicQueryReportHelper.queryTradeBillDataSet(filterMap.get("tradeBillFilter"));
        String rpType = (String)transQueryParam.get("filter_rptype");
        DataSet resultDataSet = "receivebill".equals(rpType) ? DraftDynamicQueryReportHelper.processReceiveBillDataSet(transQueryParam, draftBillDataSet, tradeBillDataSet) : DraftDynamicQueryReportHelper.processPayBillDataSet(draftBillDataSet, tradeBillDataSet);
        Date bizStartDate = (Date)transQueryParam.get("bizdate_startdate");
        Date bizEndDate = (Date)transQueryParam.get("bizdate_enddate");
        if (!resultDataSet.isEmpty() && bizStartDate != null && bizEndDate != null) {
            HashMap<String, Date> params = new HashMap<String, Date>(8);
            params.put("bizStartDate", DateUtils.getDataFormat((Date)bizStartDate, (boolean)true));
            params.put("bizEndDate", DateUtils.getDataFormat((Date)bizEndDate, (boolean)false));
            resultDataSet = resultDataSet.filter("bizdate >= bizStartDate and bizdate <= bizEndDate", params);
        }
        return resultDataSet;
    }

    private static DataSet processPayBillDataSet(DataSet draftBillDataSet, DataSet tradeBillDataSet) {
        draftBillDataSet = draftBillDataSet.leftJoin(tradeBillDataSet).on("id", "draftbillid").select((String[])Arrays.stream(draftBillDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new), new String[]{"id as tradeId"}).finish();
        draftBillDataSet = draftBillDataSet.filter("case when draftbillstatus = 'payoffed' then tradeId is not null else true end").removeFields(new String[]{"tradeId", "isequalbill", "supperbillid", "equaltradebillid"}).distinct();
        ReportCommonHelper.closeDataSet(tradeBillDataSet);
        return draftBillDataSet;
    }

    private static DataSet processReceiveBillDataSet(Map<String, Object> transQueryParam, DataSet draftBillDataSet, DataSet tradeBillDataSet) {
        boolean statPledge = (Boolean)transQueryParam.get("filter_statpledge");
        String[] draftBillSelector = (String[])Arrays.stream(draftBillDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        DataSet draftAndTradeBillDataSet = draftBillDataSet.leftJoin(tradeBillDataSet).on("id", "draftbillid").select(draftBillSelector, tradeBillSelector).finish();
        String[] draftAndTradeBillSelector = (String[])Arrays.stream(draftAndTradeBillDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        DataSet draftAndExistTradeBillTradeDataSet = draftAndTradeBillDataSet.filter("tradeId is not null");
        DataSet draftAndLatestTradeBillDataSet = draftAndExistTradeBillTradeDataSet.groupBy(new String[]{"draftbillid"}).max("tradeBillCreateTime").finish().leftJoin(draftAndExistTradeBillTradeDataSet).on("draftbillid", "draftbillid").on("tradeBillCreateTime", "tradeBillCreateTime").select(new String[0], draftAndTradeBillSelector).finish();
        draftAndLatestTradeBillDataSet = draftAndLatestTradeBillDataSet.union(draftAndTradeBillDataSet.filter("tradeId is null"));
        ReportCommonHelper.closeDataSet(draftAndExistTradeBillTradeDataSet);
        DataSet notEqualBillDataSet = draftAndLatestTradeBillDataSet.filter("isequalbill = false and amount = originalsubbillamount");
        notEqualBillDataSet = notEqualBillDataSet.filter("case when tradetype = 'endorse' then false when (tradetype = 'pledge' and " + !statPledge + ") then false when (tradetype = 'discount' or tradetype = 'collect') then false else true end");
        DataSet equalParentBillDataSet = draftAndLatestTradeBillDataSet.filter("isequalbill = false and amount != originalsubbillamount");
        DataSet equalSubBillDataSet = draftAndLatestTradeBillDataSet.filter("isequalbill = true");
        DataSet resultDataSet = notEqualBillDataSet.union(equalParentBillDataSet.filter("tradeId is null"));
        equalParentBillDataSet = DraftDynamicQueryReportHelper.tradeIdFindSubDraftBillToResultSet(equalParentBillDataSet, equalSubBillDataSet, draftAndTradeBillSelector, statPledge);
        resultDataSet = resultDataSet.union(equalParentBillDataSet);
        ReportCommonHelper.closeDataSet(notEqualBillDataSet, equalParentBillDataSet);
        DataSet equalSubBillDataSetCopy = equalSubBillDataSet.copy();
        DataSet existTradeBillDataSet = DraftDynamicQueryReportHelper.tradeIdFindSubDraftBillToResultSet(equalSubBillDataSetCopy, equalSubBillDataSet, draftAndTradeBillSelector, statPledge);
        resultDataSet = resultDataSet.union(existTradeBillDataSet);
        ReportCommonHelper.closeDataSet(existTradeBillDataSet);
        DataSet notExistOwnTradeBillDataSet = equalSubBillDataSetCopy.filter("tradeId is null").leftJoin(tradeBillDataSet).on("equaltradebillid", "id").on("supperbillid", "draftbillid").select(draftBillSelector, tradeBillSelector).finish();
        ReportCommonHelper.closeDataSet(equalSubBillDataSetCopy);
        DataSet existRelatedTradeBillDataSet = notExistOwnTradeBillDataSet.filter("case when tradetype = 'endorse' then false when (tradetype = 'pledge' and " + !statPledge + ") then false when (tradetype = 'discount' or tradetype = 'collect') then false when tradeId is null and supperbillid != 0 then false else true end");
        resultDataSet = resultDataSet.union(existRelatedTradeBillDataSet);
        ReportCommonHelper.closeDataSet(existRelatedTradeBillDataSet);
        DataSet waitToStatisticDataSet = notExistOwnTradeBillDataSet.filter("tradeId is null and supperbillid != 0");
        DataSet loopDataSet = waitToStatisticDataSet.copy().leftJoin(draftAndLatestTradeBillDataSet).on("supperbillid", "id").select(new String[]{"id as originBillId"}, draftAndTradeBillSelector).finish().filter("id is not null");
        waitToStatisticDataSet = waitToStatisticDataSet.addField("-1", "needToStatistic");
        ReportCommonHelper.closeDataSet(notExistOwnTradeBillDataSet);
        String[] waitToStatisticDataSetSelector = (String[])Arrays.stream(waitToStatisticDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        String[] loopDataSetSelector = (String[])Arrays.stream(loopDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        ArrayList<String> draftBillSelectorList = new ArrayList<String>(Arrays.asList(draftBillSelector));
        draftBillSelectorList.add("originBillId");
        String[] draftBillLoopSelector = draftBillSelectorList.toArray(new String[0]);
        while (!loopDataSet.copy().isEmpty()) {
            loopDataSet = loopDataSet.filter("tradeId is not null").leftJoin(DraftDynamicQueryReportHelper.tradeIdFindSubDraftBillToResultSet(loopDataSet.copy(), equalSubBillDataSet, loopDataSetSelector, statPledge)).on("originBillId", "originBillId").select(loopDataSetSelector, new String[]{"id as statisticId"}).finish().addField("case when statisticId is not null then 1 else 0 end", "statisticResult").removeFields(new String[]{"statisticId"}).union(loopDataSet.filter("tradeId is null").select(loopDataSetSelector).addField("case when equaltradebillid = 0 then 1 else -1 end", "statisticResult"));
            waitToStatisticDataSet = waitToStatisticDataSet.leftJoin(loopDataSet).on("id", "originBillId").select(waitToStatisticDataSetSelector, new String[]{"statisticResult"}).finish().updateField("needToStatistic", "case when needToStatistic = -1 then statisticResult else needToStatistic end").removeFields(new String[]{"statisticResult"});
            if ((loopDataSet = loopDataSet.filter("tradeId is null and equaltradebillid != 0")).isEmpty()) break;
            loopDataSet = loopDataSet.leftJoin(tradeBillDataSet).on("equaltradebillid", "id").on("supperbillid", "draftbillid").select(draftBillLoopSelector, tradeBillSelector).finish();
            loopDataSet = loopDataSet.addField("case when tradetype = 'endorse' then 0 when (tradetype = 'pledge' and " + !statPledge + ") then 0 when (tradetype = 'discount' or tradetype = 'collect') then 0 when tradeId is not null then 1 when tradeId is null and supperbillid = 0 then 1 else -1 end", "statisticResult");
            waitToStatisticDataSet = waitToStatisticDataSet.leftJoin(loopDataSet).on("id", "originBillId").select(waitToStatisticDataSetSelector, new String[]{"statisticResult"}).finish().updateField("needToStatistic", "case when needToStatistic = -1 then statisticResult else needToStatistic end").removeFields(new String[]{"statisticResult"});
            if ((loopDataSet = loopDataSet.filter("tradeId is null and supperbillid != 0")).isEmpty()) break;
            loopDataSet = loopDataSet.leftJoin(draftAndLatestTradeBillDataSet).on("supperbillid", "id").select(new String[]{"originBillId"}, draftAndTradeBillSelector).finish();
        }
        ReportCommonHelper.closeDataSet(loopDataSet);
        resultDataSet = resultDataSet.union(waitToStatisticDataSet.filter("needToStatistic = 1").removeFields(new String[]{"needToStatistic"}));
        resultDataSet = resultDataSet.removeFields(new String[]{"tradeId", "isequalbill", "supperbillid", "equaltradebillid"});
        resultDataSet = resultDataSet.filter("draftbillstatus!='splited'");
        return resultDataSet;
    }

    private static DataSet tradeIdFindSubDraftBillToResultSet(DataSet dataSet, DataSet equalSubBillDataSet, String[] selector, boolean statPledge) {
        return dataSet.filter("tradeId is not null").leftJoin(equalSubBillDataSet).on("tradeId", "equaltradebillid").on("id", "supperbillid").select(selector, new String[]{"id as subBillId"}).finish().filter("case when (tradetype = 'endorse' and subBillId is null) then false when (tradetype = 'pledge' and " + !statPledge + " and subBillId is null) then false when (tradetype = 'discount' or tradetype = 'collect') then false else true end").removeFields(new String[]{"subBillId"}).distinct();
    }

    private static DataSet queryTradeBillDataSet(QFilter tradeBillFilter) {
        return QueryServiceHelper.queryDataSet((String)"BillDynamicQueryDetailDataListPlugin_TradeBillData", (String)"cdm_drafttradebill", (String)"id,entrys.draftbill.id draftbillid,tradetype,createtime,entrys.billamt billamt", (QFilter[])tradeBillFilter.toArray(), null);
    }

    private static DataSet queryDraftBillDataSet(Map<String, Object> transQueryParam, QFilter draftBillFilter) {
        String firstColumnText = ReportCommonHelper.getFirstColumnText(transQueryParam, "name");
        String rpType = (String)transQueryParam.get("filter_rptype");
        if ("receivebill".equals(rpType)) {
            return QueryServiceHelper.queryDataSet((String)"BillDynamicQueryDetailDataListPlugin_ReceivableBillData", (String)"cdm_receivablebill", (String)("id,company,company.name,rptype,claimnoticebillno,billno,billstatus,bizdate,draftbilltype,draftbilltype.name,draftbillstatus,bizfinishdate,draftbilltranstatus,eledraftstatus,eledraftstatusnew,elccirculatestatus,electag,draftbillno,issuedate,acceptdate,amount as amount,currency,currency.name,description,draftbillexpiredate,drawername,draweraccountname,drawerbank,drawerbank.name as drawerbankname,drawerbankno,receivername,receiveraccount,receiverbank,receiverbank.name,receiverbankno,acceptername,accepteraccount,isrefund,accepterbank.name as accepterbankname,refunddesc,accepterbankno,ispayinterest,istransfer,acceptno,source,delivername,recbody,beendorsor,use,creator,creator.name,billpool,billpool.name,poollockorg,poollockorg.name,createtime,modifier,modifier.name,modifytime,isvoucher,vouchernum,lockbilltime,predictunlocktime,lockbilluser,lockbilluser.name,returnnotetag,subbillquantity,subbillrange,issplit,billidentitycode,originalsubbillrang,originalsubbillamount as originalsubbillamount,sourcebillid,sourcebilltype,lockedamount as lockedamount,isendorsepay,locksourcebilltype,availableamount as availableamount,locksourcebillid,billpool.number,poollockstatus,isequalbill,supperbillid,equaltradebillid" + firstColumnText + ",0 as sumlevel"), (QFilter[])draftBillFilter.toArray(), null);
        }
        return QueryServiceHelper.queryDataSet((String)"BillDynamicQueryDetailDataListPlugin_PayableBillData", (String)"cdm_payablebill", (String)("id,company,company.name,rptype,billno,billstatus,bizdate,draftbilltype,draftbilltype.name,draftbillstatus,bizfinishdate,draftbilltranstatus,eledraftstatus,eledraftstatusnew,elccirculatestatus,electag,draftbillno,issuedate,acceptdate,amount as amount,currency,currency.name,description,draftbillexpiredate,drawername,draweraccountname,drawerbankname,drawerbankno,receivername,receiveraccount,receiverbank,receiverbank.name,receiverbankno,acceptername,accepteraccount,isrefund,accepterbankname,refunddesc,accepterbankno,ispayinterest,istransfer,acceptno,source,recbody,beendorsor,use,creator,creator.name,createtime,modifier,modifier.name,modifytime,isvoucher,vouchernum,subbillquantity,subbillrange,issplit,billidentitycode,originalsubbillrang,originalsubbillamount as originalsubbillamount,sourcebillid,lockedamount as lockedamount,isendorsepay,locksourcebilltype,availableamount as availableamount,locksourcebillid,isequalbill,supperbillid,equaltradebillid" + firstColumnText + ",0 as sumlevel"), (QFilter[])draftBillFilter.toArray(), null);
    }

    private static Map<String, QFilter> getFilter(Map<String, Object> transQueryParam, boolean isFromInventory) {
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(4);
        Date queryEndDate = (Date)transQueryParam.get("filter_queryenddate");
        String rpType = (String)transQueryParam.get("filter_rptype");
        String billType = (String)transQueryParam.get("filter_billtype");
        DynamicObjectCollection billTypeBase = (DynamicObjectCollection)transQueryParam.get("filter_billtypebase");
        DynamicObjectCollection currency = (DynamicObjectCollection)transQueryParam.get("filter_currency");
        Long currencyId = (Long)transQueryParam.get("currencyId");
        Long bankAccountId = (Long)transQueryParam.get("bankAccountId");
        QFilter tradeBillFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        tradeBillFilter.and(new QFilter("draftbilltranstatus", "=", (Object)DraftTranStatusEnum.SUCCESS.getValue()));
        QFilter draftBillFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        draftBillFilter.and("rptype", "=", (Object)rpType);
        List orgIds = (List)transQueryParam.get("orgIdList");
        if (EmptyUtil.isNoEmpty((Object)orgIds)) {
            draftBillFilter.and("company", "in", (Object)orgIds);
            tradeBillFilter.and("company", "in", (Object)orgIds);
        } else {
            draftBillFilter.and("company", "=", (Object)0L);
            tradeBillFilter.and("company", "=", (Object)0L);
        }
        QFilter bizDateFilter = new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)queryEndDate, (boolean)false));
        draftBillFilter.and(bizDateFilter);
        Set billTypeIdSet = null;
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)billTypeBase)) {
            billTypeIdSet = billTypeBase.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        } else {
            DynamicObjectCollection billTypeList;
            if (EmptyUtil.isNoEmpty((String)billType)) {
                Set billTypeSet = Arrays.stream(billType.split(",", -1)).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
                billTypeList = QueryServiceHelper.query((String)"cdm_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("settlementtype", "in", billTypeSet).and("enable", "=", (Object)"1")});
                billTypeIdSet = billTypeList.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            }
            if (EmptyUtil.isEmpty(billTypeIdSet) && isFromInventory) {
                HashSet<String> set = new HashSet<String>(2);
                set.add("5");
                set.add("6");
                billTypeList = QueryServiceHelper.query((String)"cdm_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("settlementtype", "in", set).and("enable", "=", (Object)"1")});
                billTypeIdSet = billTypeList.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            }
        }
        if (EmptyUtil.isNoEmpty(billTypeIdSet)) {
            draftBillFilter.and("draftbilltype", "in", billTypeIdSet);
            tradeBillFilter.and("drafttype", "in", billTypeIdSet);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currency)) {
            Set currencyIdSet = currency.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            draftBillFilter.and("currency", "in", currencyIdSet);
            tradeBillFilter.and("currency", "in", currencyIdSet);
        }
        if (EmptyUtil.isNoEmpty((Long)currencyId)) {
            draftBillFilter.and("currency.id", "=", (Object)currencyId);
            tradeBillFilter.and("currency.id", "=", (Object)currencyId);
        }
        if ("receivebill".equals(rpType)) {
            draftBillFilter.and("draftbillstatus", "in", BillDynamicQueryDetailProp.RECEIVE_BILL_STAT_STATUS);
            if (EmptyUtil.isNoEmpty((Long)bankAccountId)) {
                draftBillFilter.and("bankaccount.id", "=", (Object)bankAccountId);
            }
        } else {
            draftBillFilter.and("draftbillstatus", "in", BillDynamicQueryDetailProp.PAY_BILL_STAT_STATUS);
            if (EmptyUtil.isNoEmpty((Long)bankAccountId)) {
                draftBillFilter.and("draweraccount.id", "=", (Object)bankAccountId);
            }
        }
        if ("receivebill".equals(rpType)) {
            tradeBillFilter.and("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)queryEndDate, (boolean)false));
            tradeBillFilter.and("tradetype", "not in", BillDynamicQueryDetailProp.PAY_BILL_TRADE_TYPE);
        } else {
            tradeBillFilter.and("bizdate", ">", (Object)DateUtils.getDataFormat((Date)queryEndDate, (boolean)false));
            tradeBillFilter.and("tradetype", "in", BillDynamicQueryDetailProp.PAY_BILL_TRADE_TYPE);
        }
        filterMap.put("draftBillFilter", draftBillFilter);
        filterMap.put("tradeBillFilter", tradeBillFilter);
        return filterMap;
    }

    private static List<Long> getQueryOrgIds(ReportQueryParam queryParam, String orgField, String orgViewField) {
        log.info("getQueryOrgIds is start");
        List orgIds = new ArrayList(10);
        Long userId = RequestContext.get().getCurrUserId();
        String formId = (String)queryParam.getCustomParam().get("formid");
        String appId = (String)queryParam.getCustomParam().get("appid");
        String queryWay = (String)queryParam.getFilter().getFilterItem("filter_queryway").getValue();
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)queryParam.getFilter().getFilterItem(orgViewField).getValue();
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgIds = TmcOrgDataHelper.getAuthorizedAndSubordinateOrgByView((Long)orgView.getLong("id"), (Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac", (boolean)true, (boolean)true);
            }
        } else {
            orgIds = (List)queryParam.getFilter().getFilterItem(orgField).getValue();
            if (EmptyUtil.isEmpty(orgIds)) {
                orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)"1")}, null);
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)coll)) {
                    orgIds.retainAll(OrgHelper.getIdList(coll));
                }
            }
        }
        return orgIds;
    }
}

