/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class OrgHelper {
    public static final String ORGTYPE_ACCOUNTING = "fisaccounting";
    public static final String ORGTYPE_SETTLEMENT = "fissettlement";
    public static final String ORGTYPE_BANKROLL = "fisbankroll";
    public static final String ORGTYPE_SALE = "fissale";
    public static final String NO_LEGAL_PERSON = "3";
    private static final Long DEFAULTORGVIEWID = 8L;

    public static DynamicObject getBaseCurrency(long orgId) {
        try {
            return SystemStatusCtrolHelper.getStandardCurrency((long)orgId);
        }
        catch (KDBizException e) {
            return null;
        }
    }

    public static DynamicObject getSuperiorBankOrg(String attributes, long orgId) {
        List superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)attributes, (long)orgId);
        if (superiorOrgs == null || superiorOrgs.size() < 1) {
            return null;
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id, orgpattern", (QFilter[])new QFilter[]{new QFilter("id", "in", superiorOrgs.get(0))});
        return org;
    }

    public static DynamicObjectCollection getAuthorizedBankOrg(Long userID, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg(userID, entityID, permissionItem, ORGTYPE_BANKROLL);
    }

    public static DynamicObjectCollection getAuthorizedAcctOrg(Long userID, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg(userID, entityID, permissionItem, ORGTYPE_ACCOUNTING);
    }

    private static DynamicObjectCollection getAuthorizedOrg(Long userID, String entityID, String permissionItem, String funType) {
        String appId = AppMetadataCache.getAppInfo((String)"cas").getId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter functionFilter = new QFilter(funType, "=", (Object)Boolean.TRUE);
        Map orgs = new HashMap();
        if (allPermOrgs.hasAllOrgPerm()) {
            orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter});
        } else {
            List orgIdList = allPermOrgs.getHasPermOrgs();
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
            orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter});
        }
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        for (DynamicObject org : orgs.values()) {
            orgColl.add((Object)org);
        }
        return orgColl;
    }

    public static List<Long> getAuthorizedBankOrgId(Long userID, String entityID, String permissionItem) {
        DynamicObjectCollection orgColl = OrgHelper.getAuthorizedBankOrg(userID, entityID, permissionItem);
        return OrgHelper.getIdList(orgColl);
    }

    public static List<Long> getIdList(DynamicObjectCollection orgList) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject org : orgList) {
            idList.add(org.getLong("id"));
        }
        return idList;
    }

    public static List<Long> getMulDOIdList(DynamicObjectCollection orgList) {
        ArrayList<Long> idList = new ArrayList<Long>(10);
        for (DynamicObject org : orgList) {
            idList.add(org.getDynamicObject("fbasedataid").getLong("id"));
        }
        return idList;
    }

    public static DynamicObject getOrgById(long id) {
        Map orgMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{id}, (String)"bos_org");
        return (DynamicObject)orgMap.get(id);
    }

    public static DynamicObject getOrgByNumber(String number) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter numFilter = new QFilter("number", "=", (Object)number);
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name,fisasset", (QFilter[])new QFilter[]{enableFilter, numFilter});
        if (null != orgs && orgs.size() > 0) {
            return (DynamicObject)orgs.get(0);
        }
        return null;
    }

    public static DynamicObject getCurrentPermOrg(String permissionEntity, String permissionItem) throws KDBizException {
        MainEntityType orgType;
        DynamicObject currentOrg;
        Long userPK = Long.valueOf(RequestContext.get().getUserId());
        Long orgId = RequestContext.get().getOrgId();
        if (OrgHelper.hasPermission("cas", userPK, orgId, permissionEntity, permissionItem) && (currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)(orgType = EntityMetadataCache.getDataEntityType((String)"bos_org")))).getBoolean(ORGTYPE_BANKROLL)) {
            return currentOrg;
        }
        DynamicObjectCollection orgList = OrgHelper.getAuthorizedBankOrg(userPK, permissionEntity, permissionItem);
        if (orgList.size() > 0) {
            return (DynamicObject)orgList.get(0);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ec4\u7ec7\uff01", (String)"OrgHelper_0", (String)"tmc-bei-common", (Object[])new Object[0]));
    }

    public static boolean hasPermission(String appId, long userId, long orgId, String entityId, String permissionItemId) {
        int res;
        if (StringUtils.isEmpty((CharSequence)appId) && StringUtils.isNotEmpty((CharSequence)entityId)) {
            appId = EntityMetadataCache.getDataEntityType((String)entityId).getAppId();
        }
        return (res = PermissionServiceHelper.checkFunctionPermission((String)(appId = AppMetadataCache.getAppInfo((String)appId).getId()), (long)userId, (long)orgId, (String)entityId, (String)permissionItemId)) == 1;
    }

    public static List<Long> getQueryOrgIds(ReportQueryParam queryParam) {
        return OrgHelper.getQueryOrgIds(queryParam, "filter_org", "filter_orgview");
    }

    public static List<Long> getQueryOrgIds(ReportQueryParam queryParam, String orgField, String orgViewField) {
        List orgIds = new ArrayList(10);
        Long userId = RequestContext.get().getCurrUserId();
        String formId = (String)queryParam.getCustomParam().get("formid");
        String appId = (String)queryParam.getCustomParam().get("appid");
        String queryWay = (String)queryParam.getFilter().getFilterItem("filter_queryway").getValue();
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)queryParam.getFilter().getFilterItem(orgViewField).getValue();
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgIds = (List)queryParam.getFilter().getFilterItem(orgField).getValue();
                orgIds = EmptyUtil.isEmpty(orgIds) ? TmcOrgDataHelper.getAuthorizedAndSubordinateOrgByView((Long)orgView.getLong("id"), (Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac", (boolean)true, (boolean)true) : TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgView.getLong("id"), orgIds, (boolean)true, (boolean)true);
            }
        } else {
            orgIds = (List)queryParam.getFilter().getFilterItem(orgField).getValue();
            if (EmptyUtil.isEmpty(orgIds)) {
                orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
            }
            if (queryParam.getFilter().containProp("filter_isincludelower") && ((Boolean)queryParam.getFilter().getFilterItem("filter_isincludelower").getValue()).booleanValue()) {
                orgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)DEFAULTORGVIEWID, orgIds, (boolean)true);
            }
        }
        return orgIds;
    }
}

