/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.helper;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReportCommonHelper {
    private static final Log LOGGER = LogFactory.getLog(ReportCommonHelper.class);
    public static final String FILTER_STATDIM = "filter_statdim";
    public static final String STAT_COL_TEXT = "statcoltext";

    public static String getFirstColumnText(Map<String, Object> paramMap, String statDimKey) {
        String statDim = (String)paramMap.get(FILTER_STATDIM);
        return EmptyUtil.isNoEmpty((String)statDimKey) ? "," + statDim + "." + statDimKey + " as " + STAT_COL_TEXT : "";
    }

    public static void closeDataSet(DataSet ... dataSets) {
        if (Objects.isNull(dataSets)) {
            return;
        }
        for (DataSet dataSet : dataSets) {
            if (Objects.isNull(dataSet)) continue;
            dataSet.close();
        }
    }

    public static void printForDataSet(DataSet dataSet) {
        DataSet printDataSet = dataSet.copy();
        RowMeta rowMeta = dataSet.getRowMeta();
        int cols = rowMeta.getFieldCount();
        List selector = Arrays.stream(printDataSet.getRowMeta().getFields()).map(Field::getAlias).collect(Collectors.toList());
        LOGGER.info("printForDataSet: {}", selector);
        for (Row row : printDataSet) {
            StringBuilder data = new StringBuilder();
            for (int i = 0; i < cols; ++i) {
                Object obj = row.get(i);
                data.append(obj).append("  ");
            }
            LOGGER.info("printForDataSet: {}", (Object)data.toString());
        }
    }
}

