/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.report.helper.BillEndorseCurrencyEnum;
import kd.tmc.cdm.report.helper.BillEndorseHelper;
import kd.tmc.cdm.report.helper.ReportDataHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class BillEndorseReportListDataPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Map<String, String> V_TREE_BASE_COMPANY_MAP = new HashMap<String, String>(2);
    private String radixStr = "/1";
    private static String SUM_METHOD_ORG = "1";
    private static final Map<String, String> PROPERTY_MAPPING_MAP = new HashMap<String, String>(2);
    private static final Map<String, BillEndorseCurrencyEnum> CURRENCY_UNIT_MAP;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam reportQueryParam) {
        Map<String, QFilter> qFilterMap = this.endorseFilter(reportQueryParam);
        Map<String, Object> paramMap = ReportDataHelper.transQueryParam(reportQueryParam);
        String currencyUnit = (String)paramMap.get("filter_currencyunit");
        if (StringUtils.isNotEmpty((CharSequence)currencyUnit)) {
            this.radixStr = "/" + CURRENCY_UNIT_MAP.get(currencyUnit).getRadix();
        }
        DataSet mainDataSet = this.mainDataSet(qFilterMap);
        DataSet filterMainDataSet = this.filterInOutEndorse(mainDataSet, paramMap);
        DataSet addRateDataSet = this.computeRateDataSet(paramMap, filterMainDataSet);
        DataSet amountChangeRateDataSet = addRateDataSet.addField("amount * excval", "reportamount");
        DataSet feeDetailDataSet = this.computeFeeAmount(amountChangeRateDataSet);
        DataSet isPayDraftDataSet = this.computeIsPayDraftDataSet(qFilterMap);
        DataSet payDataSet = this.computePayDraftDataSet(qFilterMap, isPayDraftDataSet);
        DataSet payAmountDataSet = this.computePayAmountDataSet(feeDetailDataSet, isPayDraftDataSet, payDataSet);
        DynamicObject reportCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        GroupbyDataSet groupbyDataSet = null;
        groupbyDataSet = this.isSumOrgMethod(paramMap) != false ? payAmountDataSet.groupBy(new String[]{"companyname", "companyid", "inendorser", "currency"}) : payAmountDataSet.groupBy(new String[]{"inendorser", "currency"});
        groupbyDataSet = groupbyDataSet.sum("amount").sum("reportamount").sum("payinterest").sum("reportpayinterest").sum("feeamount").sum("reportfeeamount");
        dataSet = groupbyDataSet.finish();
        dataSet = dataSet.orderBy(new String[]{"inendorser ASC"});
        if (this.isSumOrgMethod(paramMap).booleanValue()) {
            if ("org".equals(paramMap.get("filter_queryway"))) {
                List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"cdm", (String)"cdm_report_cheque_sum", (String)"47150e89000000ac");
                return this.getTreeDataSet(dataSet, null, orgIdList).addField(String.valueOf(reportCurrency.getPkValue()), "report_currency").orderBy(new String[]{"inendorser ASC", "currency ASC"});
            }
            Long companyViewId = (Long)paramMap.get("companyviewnum");
            return this.getTreeDataSet(dataSet, companyViewId, null).addField(String.valueOf(reportCurrency.getPkValue()), "report_currency").orderBy(new String[]{"inendorser ASC", "currency ASC"});
        }
        return ReportDataHelper.getBizDsUpOrgTree(dataSet).addField(String.valueOf(reportCurrency.getPkValue()), "report_currency").orderBy(new String[]{"inendorser ASC", "currency ASC"});
    }

    private DataSet filterInOutEndorse(DataSet mainDataSet, Map<String, Object> paramMap) {
        String endorseFlow = (String)paramMap.get("endorseflow");
        if ("all".equals(endorseFlow)) {
            return mainDataSet;
        }
        DataSet filterMainDataSet = null;
        Iterator mainDataSetValues = mainDataSet.copy().iterator();
        ArrayList<Long> suppliers = new ArrayList<Long>();
        ArrayList<Long> customer = new ArrayList<Long>();
        while (mainDataSetValues.hasNext()) {
            Row row = (Row)mainDataSetValues.next();
            String payeeTypeText = row.getString("payeetypetext");
            Long beEndorser = row.getLong("beendorsor");
            if ("bd_supplier".equals(payeeTypeText)) {
                suppliers.add(beEndorser);
                continue;
            }
            if (!"bd_customer".equals(payeeTypeText)) continue;
            customer.add(beEndorser);
        }
        String inExternalIds = this.inAndExternalIds(endorseFlow, suppliers, customer);
        if ("internal".equals(endorseFlow)) {
            filterMainDataSet = mainDataSet.copy().filter("beendorsor in" + inExternalIds + " or payeetypetext = 'bos_org'");
        }
        if ("external".equals(endorseFlow)) {
            filterMainDataSet = mainDataSet.copy().filter("beendorsor in" + inExternalIds + " or payeetypetext in ('other', 'bos_user')");
        }
        if (filterMainDataSet == null) {
            return mainDataSet;
        }
        return filterMainDataSet;
    }

    private String inAndExternalIds(String endorseFlow, List<Long> suppliers, List<Long> customer) {
        Long id;
        DataSet queryDataSet;
        QFilter internal;
        QFilter qFilter;
        String qcp = "";
        qcp = "internal".equals(endorseFlow) ? "!=" : "=";
        ArrayList<Long> beEndorserIds = new ArrayList<Long>(1000);
        if (suppliers.size() > 0) {
            qFilter = new QFilter("id", "in", suppliers);
            internal = new QFilter("internal_company", qcp, (Object)0);
            queryDataSet = QueryServiceHelper.queryDataSet((String)"GET_SUPPLER", (String)"bd_supplier", (String)"id,internal_company", (QFilter[])new QFilter[]{qFilter, internal}, null);
            for (Row row : queryDataSet) {
                id = row.getLong("id");
                beEndorserIds.add(id);
            }
        }
        if (customer.size() > 0) {
            qFilter = new QFilter("id", "in", customer);
            internal = new QFilter("internal_company", qcp, (Object)0);
            queryDataSet = QueryServiceHelper.queryDataSet((String)"GET_CUSYOMER", (String)"bd_customer", (String)"id,internal_company", (QFilter[])new QFilter[]{qFilter, internal}, null);
            for (Row row : queryDataSet) {
                id = row.getLong("id");
                beEndorserIds.add(id);
            }
        }
        if (beEndorserIds.size() <= 0) {
            return "(null)";
        }
        return ((Object)beEndorserIds).toString().replace('[', '(').replace(']', ')');
    }

    private DataSet mainDataSet(Map<String, QFilter> qFilterMap) {
        QFilter[] qFilters = new QFilter[]{qFilterMap.get("endorse")};
        return QueryServiceHelper.queryDataSet((String)"ReceiveData", (String)"cdm_drafttradebill", (String)("id,billno,company, company.name as companyname, company.id as companyid, beendorsortext as inendorser,payeetypetext,beendorsor,currency,amount" + this.radixStr + " as amount ,createtime"), (QFilter[])qFilters, null).orderBy(new String[]{"inendorser ASC", "currency ASC"});
    }

    private DataSet computeRateDataSet(Map<String, Object> paramMap, DataSet mainDataSet) {
        DynamicObject reportCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        DynamicObject exRateTable = (DynamicObject)paramMap.get("filter_exratetable");
        DynamicObjectCollection filterCurrencies = !EmptyUtil.isEmpty((Object)paramMap.get("filter_currencies")) ? (DynamicObjectCollection)paramMap.get("filter_currencies") : QueryServiceHelper.query((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        return ReportDataHelper.exchangeRate(mainDataSet, filterCurrencies, reportCurrency, exRateTable);
    }

    private DataSet computeFeeAmount(DataSet amountChangeRateDataSet) {
        List<Object> ids = this.collInfo(amountChangeRateDataSet, "id");
        QFilter qFeeDetail = new QFilter("appsource", "=", (Object)"cdm").and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("entry.srcbillid", "in", (Object)ids.toArray()));
        DataSet feeDetailData = QueryServiceHelper.queryDataSet((String)"ReceiveData", (String)"cfm_feebill", (String)("payamt " + this.radixStr + " as feeamount, entry.srcbillid as srcbillid"), (QFilter[])new QFilter[]{qFeeDetail}, null);
        DataSet feeDetailDataSum = feeDetailData.copy().select(new String[]{"feeamount", "srcbillid"}).groupBy(new String[]{"srcbillid"}).sum("feeamount").finish();
        String[] feeLeftSelector = (String[])Arrays.stream(amountChangeRateDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        DataSet addFeeDetail = amountChangeRateDataSet.join(feeDetailDataSum, JoinType.LEFT).on("id", "srcbillid").select(feeLeftSelector, new String[]{"srcbillid", "feeamount"}).finish();
        return addFeeDetail.addField("feeamount * excval", "reportfeeamount");
    }

    private DataSet computeIsPayDraftDataSet(Map<String, QFilter> qFilterMap) {
        QFilter qEndorseFilter = qFilterMap.get("endorse").and(new QFilter("entrys.draftbill.ispayinterest", "=", (Object)true));
        QFilter[] qEndorstFilters = new QFilter[]{qEndorseFilter};
        return QueryServiceHelper.queryDataSet((String)"ReceiveData", (String)"cdm_drafttradebill", (String)"id,entrys.draftbill.billno as endorsedraftbill", (QFilter[])qEndorstFilters, null);
    }

    private DataSet computePayDraftDataSet(Map<String, QFilter> qFilterMap, DataSet isPayDraftDataSet) {
        List<Object> billNos = this.collInfo(isPayDraftDataSet, "endorsedraftbill");
        QFilter[] qPayFilters = new QFilter[]{qFilterMap.get("payinterest").and(new QFilter("entrys.draftbill.billno", "in", (Object)billNos.toArray()))};
        return QueryServiceHelper.queryDataSet((String)"ReceiveData", (String)"cdm_drafttradebill", (String)("billno as paybillno,entrys.draftbill.billno as paydraftbill, discount_interest" + this.radixStr + " as payinterest"), (QFilter[])qPayFilters, null);
    }

    private DataSet computePayAmountDataSet(DataSet feeDetailDataSet, DataSet isPayDraftDataSet, DataSet payDataSet) {
        String[] joinPayLeftSelector = (String[])Arrays.stream(isPayDraftDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        DataSet joinPayDataSet = isPayDraftDataSet.join(payDataSet, JoinType.LEFT).on("endorsedraftbill", "paydraftbill").select(joinPayLeftSelector, new String[]{"paydraftbill", "payinterest", "paybillno"}).finish();
        DataSet payDataSetGroupBy = joinPayDataSet.select(new String[]{"id", "payinterest"}).distinct().groupBy(new String[]{"id"}).sum("payinterest").finish();
        String[] joinEndorseLeftSelector = (String[])Arrays.stream(feeDetailDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        DataSet joinPayDataSetGroupBy = feeDetailDataSet.join(payDataSetGroupBy, JoinType.LEFT).on("id", "id").select(joinEndorseLeftSelector, new String[]{"payinterest"}).finish();
        return joinPayDataSetGroupBy.addField("payinterest * excval", "reportpayinterest");
    }

    private DataSet getTreeDataSet(DataSet bizDs, Long companyViewId, List<Long> orgIdList) {
        ArrayList<String> statList = new ArrayList<String>(Arrays.asList("reportamount", "reportpayinterest", "reportfeeamount"));
        Map<String, String> vTreeBaseMap = V_TREE_BASE_COMPANY_MAP;
        Map<String, String> vbizBaseMap = ReportDataHelper.getBizBaseMap(bizDs, statList, vTreeBaseMap);
        bizDs = ReportDataHelper.getBizDsWithOrgTree(bizDs, "rowid", "companyid", statList, vTreeBaseMap, vbizBaseMap, companyViewId, orgIdList);
        bizDs = ReportDataHelper.getSumDataSet(bizDs, statList, true, (AbstractTmcListDataPlugin)this);
        return bizDs;
    }

    private Map<String, QFilter> endorseFilter(ReportQueryParam param) {
        HashMap<String, QFilter> returnQFilter = new HashMap<String, QFilter>(2);
        Map<String, Object> paramMap = ReportDataHelper.transQueryParam(param);
        List orgIds = this.getQueryOrgIds(param);
        QFilter qFilter = BillEndorseHelper.initEndorseFilter(paramMap, PROPERTY_MAPPING_MAP, orgIds);
        QFilter qEndorseFilter = qFilter.copy();
        qEndorseFilter.and(new QFilter("tradetype", "=", (Object)"endorse"));
        qEndorseFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qEndorseFilter.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        QFilter qPayFilter = qFilter.copy();
        qPayFilter.and(new QFilter("tradetype", "=", (Object)"payinterest"));
        qPayFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qPayFilter.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        returnQFilter.put("endorse", qEndorseFilter);
        returnQFilter.put("payinterest", qPayFilter);
        return returnQFilter;
    }

    private List<Object> collInfo(DataSet dataSet, String keyField) {
        DataSet idsDataSet = dataSet.copy().select(keyField).distinct();
        Iterator values = idsDataSet.iterator();
        ArrayList<Object> list = new ArrayList<Object>();
        while (values.hasNext()) {
            Row data = (Row)values.next();
            Object id = data.get(keyField);
            list.add(id);
        }
        return list;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportQueryParam queryParam = this.getQueryParam();
        Map<String, Object> paramMap = ReportDataHelper.transQueryParam(queryParam);
        if (this.isSumOrgMethod(paramMap).booleanValue()) {
            return super.getColumns(columns);
        }
        for (AbstractReportColumn column : columns) {
            String field = ((ReportColumn)column).getFieldKey();
            if (!"companyname".equals(field)) continue;
            ((ReportColumn)column).setHide(true);
            break;
        }
        return super.getColumns(columns);
    }

    private Boolean isSumOrgMethod(Map<String, Object> paramMap) {
        String sumMethod = (String)paramMap.get("summethod");
        if (SUM_METHOD_ORG.equals(sumMethod)) {
            return true;
        }
        return false;
    }

    static {
        V_TREE_BASE_COMPANY_MAP.put("companyname", "orgname");
        V_TREE_BASE_COMPANY_MAP.put("companyid", "rowid");
        PROPERTY_MAPPING_MAP.put("filter_org", "company.id");
        CURRENCY_UNIT_MAP = Collections.unmodifiableMap(new HashMap<String, BillEndorseCurrencyEnum>(8){
            {
                this.put(BillEndorseCurrencyEnum.BILLION.getRadix(), BillEndorseCurrencyEnum.BILLION);
                this.put(BillEndorseCurrencyEnum.MILLION.getRadix(), BillEndorseCurrencyEnum.MILLION);
                this.put(BillEndorseCurrencyEnum.TENTHOUSAND.getRadix(), BillEndorseCurrencyEnum.TENTHOUSAND);
                this.put(BillEndorseCurrencyEnum.THOUSAND.getRadix(), BillEndorseCurrencyEnum.THOUSAND);
                this.put(BillEndorseCurrencyEnum.ORIGINAL.getRadix(), BillEndorseCurrencyEnum.ORIGINAL);
            }
        });
    }
}

