/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.IFrameMessage;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.IFrame;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.report.helper.BillTradeConstant;
import kd.tmc.cdm.report.helper.OrgHelper;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillTradeQueryQingViewPlugin
extends AbstractReportFormPlugin {
    private static final Log log = LogFactory.getLog(BillTradeQueryQingViewPlugin.class);

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            Object date = filterInfo.getValue("filter_billtype");
            if (date == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillTradeQueryQingViewPlugin5", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object unit = filterInfo.getValue("filter_currencyunit");
            if (unit == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillTradeQueryQingViewPlugin3", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object billType = filterInfo.getValue("filter_datatype");
            if (billType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BillTradeQueryQingViewPlugin4", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object exratetable = filterInfo.getValue("filter_exratetable");
            if (exratetable == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BillTradeQueryQingViewPlugin0", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object reportcurrency = filterInfo.getValue("filter_reportcurrency");
            if (reportcurrency == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u544a\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillTradeQueryQingViewPlugin12", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object queryWay = filterInfo.getValue("filter_rangequeryway");
            if (queryWay.toString().equalsIgnoreCase("A")) {
                Date dateStart = (Date)filterInfo.getValue("filter_startdate");
                Date dateEnd = (Date)filterInfo.getValue("filter_enddate");
                if (dateStart == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillTradeQueryQingViewPlugin2", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
                if (dateEnd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BillTradeQueryQingViewPlugin6", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
                if (dateStart.after(dateEnd)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f\uff01", (String)"BillTradeQueryQingViewPlugin9", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
            } else if (queryWay.toString().equalsIgnoreCase("B")) {
                Date dateEndOfPerid;
                DynamicObject dateStart = (DynamicObject)filterInfo.getValue("filter_startperiod");
                DynamicObject dateEnd = (DynamicObject)filterInfo.getValue("filter_endperiod");
                if (dateStart == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BillTradeQueryQingViewPlugin7", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
                if (dateEnd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BillTradeQueryQingViewPlugin8", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
                Date dateStartOfPerid = dateStart.getDate("begindate");
                if (dateStartOfPerid.after(dateEndOfPerid = dateEnd.getDate("enddate"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u671f\u95f4\u7684\u7ed3\u675f\u65e5\u671f\uff01", (String)"BillTradeQueryQingViewPlugin10", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
            }
        }
        return super.verifyQuery(queryParam);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initCompanyF7();
        this.initBillTypeF7();
        this.initPeriodF7();
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String pro = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        Object newValue = changeSet[0].getNewValue();
        switch (pro) {
            case "filter_billtype": {
                if (newValue == oldValue) break;
                this.getModel().setValue("filter_billtypebase", null);
                break;
            }
            case "filter_billtypebase": {
                Object billType = this.getModel().getValue("filter_billtype");
                if (null != billType && !"".equalsIgnoreCase(billType.toString())) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u522b\uff01", (String)"BillPoolTradeReportViewPlugin2", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                break;
            }
            case "filter_company": {
                if (newValue == oldValue) break;
                this.getModel().setValue("filter_startperiod", null);
                this.getModel().setValue("filter_endperiod", null);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObjectCollection companyList = (DynamicObjectCollection)this.getModel().getValue("filter_company");
        if (null != companyList && companyList.size() != 0) {
            return;
        }
        Long fisBankRollOrg = this.getFisBankRollOrg();
        log.info("fisBankRollOrg:" + fisBankRollOrg);
        DynamicObjectCollection orgList = OrgHelper.getAuthorizedBankOrg(RequestContext.get().getCurrUserId(), "cdm_report_billtrade_qing", "47150e89000000ac");
        Object[] arrObj = new Object[]{};
        if (orgList.size() > 0) {
            log.info("orgList size > 0:");
            arrObj = new Object[]{((DynamicObject)orgList.get(0)).getPkValue()};
            this.getModel().setValue("filter_company", (Object)arrObj);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", OrgHelper.getIdList(orgList)), new QFilter("isfinishinit", "=", (Object)"1")}, null);
            if (fisBankRollOrg != null) {
                DynamicObjectCollection queryFisBankRollOrg = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null);
                if (queryFisBankRollOrg.size() > 0) {
                    this.getModel().setValue("filter_company", (Object)new Object[]{fisBankRollOrg});
                    arrObj = new Object[]{fisBankRollOrg};
                    DynamicObject initObj = BillTradeQueryQingViewPlugin.getCasInitInfo(fisBankRollOrg);
                    this.getModel().setValue("filter_exratetable", initObj.getDynamicObject("exratetable").getPkValue());
                    this.getModel().setValue("filter_endperiod", initObj.getDynamicObject("currentperiod").getPkValue());
                    this.getModel().setValue("filter_startperiod", initObj.getDynamicObject("currentperiod").getPkValue());
                } else if (null != coll && coll.size() > 0) {
                    log.info(fisBankRollOrg + " is not in casInit!");
                    long orgId = ((DynamicObject)coll.get(0)).getLong("id");
                    arrObj = new Object[]{orgId};
                    this.getModel().setValue("filter_company", (Object)arrObj);
                    DynamicObject initObj = BillTradeQueryQingViewPlugin.getCasInitInfo(orgId);
                    this.getModel().setValue("filter_exratetable", initObj.getDynamicObject("exratetable").getPkValue());
                    this.getModel().setValue("filter_endperiod", initObj.getDynamicObject("currentperiod").getPkValue());
                    this.getModel().setValue("filter_startperiod", initObj.getDynamicObject("currentperiod").getPkValue());
                } else {
                    log.info(fisBankRollOrg + " is not in casInit and coll is null!");
                }
            }
        }
        if (!EmptyUtil.isEmpty((Object[])arrObj)) {
            DynamicObject baseCurrency = OrgHelper.getBaseCurrency((Long)arrObj[0]);
            if (baseCurrency != null) {
                this.getModel().setValue("filter_reportcurrency", baseCurrency.getPkValue());
            } else {
                String select = "basecurrrency,exratetable";
                Long org = (Long)arrObj[0];
                DynamicObject base = QueryServiceHelper.queryOne((String)"bd_accountingsys_base", (String)select, (QFilter[])new QFilter("baseacctorg", "=", (Object)org).toArray());
                if (null != base) {
                    this.getModel().setValue("filter_reportcurrency", (Object)base.getLong("basecurrrency"));
                    this.getModel().setValue("filter_exratetable", (Object)base.getLong("exratetable"));
                }
            }
        }
    }

    public static DynamicObject getCasInitInfo(long orgId) {
        return SystemStatusCtrolHelper.getSystemStatusCtrol((long)orgId);
    }

    public DynamicObject checkCurrentBankOrg() {
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObject currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType);
        if (currentOrg.getBoolean("fisbankroll")) {
            return currentOrg;
        }
        return null;
    }

    private void initCompanyF7() {
        BasedataEdit acctbankF7 = (BasedataEdit)this.getControl("filter_company");
        acctbankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cdm_report_billtrade_qing", (String)"47150e89000000ac");
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)authOrgList)}, null);
            QFilter qFilterOfBank = new QFilter("id", "in", OrgHelper.getIdList(coll));
            showParameter.getListFilterParameter().setFilter(qFilterOfBank);
        });
    }

    private void initPeriodF7() {
        DynamicObjectCollection company = (DynamicObjectCollection)this.getModel().getValue("filter_company");
        if (null == company || 0 == company.size()) {
            return;
        }
        Set companyIds = company.stream().map(e -> e.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", companyIds)};
        Map values = BusinessDataServiceHelper.loadFromCache((String)"cas_cashmgtinit", (QFilter[])filters);
        HashSet<Long> periodTypeIds = new HashSet<Long>(16);
        HashSet<String> emptyPeriodTypeIds = new HashSet<String>(16);
        for (DynamicObject data : values.values()) {
            DynamicObject periodtypeObj = data.getDynamicObject("periodtype");
            if (EmptyUtil.isNoEmpty((DynamicObject)periodtypeObj)) {
                periodTypeIds.add(periodtypeObj.getLong("id"));
                continue;
            }
            emptyPeriodTypeIds.add(data.getDynamicObject("org").getString("name"));
        }
        if (emptyPeriodTypeIds.size() > 0) {
            log.info("this org has no periodtype:" + SerializationUtils.toJsonString(emptyPeriodTypeIds));
        }
        BasedataEdit startbasedataEditF7 = (BasedataEdit)this.getControl("filter_startperiod");
        startbasedataEditF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilterOfPeriod = new QFilter("periodtype", "in", (Object)periodTypeIds);
            showParameter.getListFilterParameter().setFilter(qFilterOfPeriod);
        });
        BasedataEdit endbasedataEditF7 = (BasedataEdit)this.getControl("filter_endperiod");
        endbasedataEditF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilterOfPeriod = new QFilter("periodtype", "in", (Object)periodTypeIds);
            showParameter.getListFilterParameter().setFilter(qFilterOfPeriod);
        });
    }

    private void initBillTypeF7() {
        Object billType = this.getModel().getValue("filter_billtype");
        if (null == billType || "".equalsIgnoreCase(billType.toString())) {
            return;
        }
        String[] arr = billType.toString().split(",", -1);
        HashSet<String> billTypeSet = new HashSet<String>();
        for (int i = 0; i < arr.length; ++i) {
            String billTypeStr = arr[i];
            if (null == billTypeStr || "".equalsIgnoreCase(billTypeStr)) continue;
            billTypeSet.add(billTypeStr);
        }
        BasedataEdit basedataEditF7 = (BasedataEdit)this.getControl("filter_billtypebase");
        basedataEditF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilterOfBillType = new QFilter("settlementtype", "in", (Object)billTypeSet);
            showParameter.getListFilterParameter().setFilter(qFilterOfBillType);
        });
    }

    public Long getFisBankRollOrg() {
        RequestContext requestContext = RequestContext.get();
        DynamicObject currentOrg = this.checkCurrentBankOrg();
        if (currentOrg != null && currentOrg.getBoolean("fisbankroll")) {
            return currentOrg.getLong("id");
        }
        List<Long> authorizedBankOrgId = OrgHelper.getAuthorizedBankOrgId(Long.valueOf(requestContext.getUserId()), this.getModel().getDataEntityType().getName(), "47150e89000000ac");
        if (authorizedBankOrgId != null && authorizedBankOrgId.size() > 0) {
            return authorizedBankOrgId.get(0);
        }
        return null;
    }

    private List<Long> getIdList(DynamicObjectCollection coll) {
        ArrayList<Long> idList = new ArrayList<Long>(coll.size());
        for (int i = 0; i < coll.size(); ++i) {
            idList.add((Long)((DynamicObject)coll.get(i)).getDynamicObject("fbasedataid").getPkValue());
        }
        return idList;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        IFrameMessage message = new IFrameMessage();
        message.setType("reExtractData");
        IFrame frame = (IFrame)this.getView().getControl("qinganalysisap");
        frame.postMessage(message);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        FilterInfo filter = event.getQueryParam().getFilter();
        String dataType = filter.getString("filter_datatype");
        List columns = event.getColumns();
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumn)) continue;
            ReportColumn col = (ReportColumn)column;
            String key = col.getFieldKey();
            if (dataType.equalsIgnoreCase("A")) {
                List<String> payList = Arrays.asList(BillTradeConstant.fieldArr_pay);
                if (payList.contains(key)) {
                    col.setHide(false);
                    continue;
                }
                col.setHide(true);
                continue;
            }
            List<String> recList = Arrays.asList(BillTradeConstant.fieldArr_rec);
            if (recList.contains(key)) {
                col.setHide(false);
                continue;
            }
            col.setHide(true);
        }
    }
}

