/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.report.helper.BillTradeConstant;
import kd.tmc.cdm.report.helper.OrgHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillTradeReportViewPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(BillTradeReportViewPlugin.class);

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            Object org;
            String queryWay = (String)this.getModel().getValue("filter_queryway");
            if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay) && null == (org = filterInfo.getValue("filter_org"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillTradeQueryQingViewPlugin11", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object date = filterInfo.getValue("filter_billtype");
            if (date == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillTradeQueryQingViewPlugin5", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object billType = filterInfo.getValue("filter_datatype");
            if (billType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BillTradeQueryQingViewPlugin4", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object exratetable = filterInfo.getValue("filter_exratetable");
            if (exratetable == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BillTradeQueryQingViewPlugin0", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            DynamicObject statCurrency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
            if (statCurrency == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BillTradeQueryQingViewPlugin1", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object rangeQueryWay = filterInfo.getValue("filter_rangequeryway");
            if (rangeQueryWay == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillTradeQueryQingViewPlugin13", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            if (rangeQueryWay.toString().equalsIgnoreCase("A")) {
                Date dateStart = (Date)filterInfo.getValue("filter_startdate");
                Date dateEnd = (Date)filterInfo.getValue("filter_enddate");
                if (dateStart == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillTradeQueryQingViewPlugin2", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
                if (dateEnd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BillTradeQueryQingViewPlugin6", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
                if (dateStart.after(dateEnd)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f\uff01", (String)"BillTradeQueryQingViewPlugin9", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
            } else if (rangeQueryWay.toString().equalsIgnoreCase("B")) {
                Date dateEndOfPerid;
                DynamicObject dateStart = (DynamicObject)filterInfo.getValue("filter_startperiod");
                DynamicObject dateEnd = (DynamicObject)filterInfo.getValue("filter_endperiod");
                if (dateStart == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BillTradeQueryQingViewPlugin7", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
                if (dateEnd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BillTradeQueryQingViewPlugin8", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
                Date dateStartOfPerid = dateStart.getDate("begindate");
                if (dateStartOfPerid.after(dateEndOfPerid = dateEnd.getDate("enddate"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u671f\u95f4\u7684\u7ed3\u675f\u65e5\u671f\uff01", (String)"BillTradeQueryQingViewPlugin10", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
            }
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        queryParam.getFilter().addFilterItem("filter_statcurrency", (Object)currency);
        String currencyUnit = (String)this.getModel().getValue("filter_currencyunit");
        queryParam.getFilter().addFilterItem("filter_currencyunit", (Object)currencyUnit);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initCompanyF7();
        this.initBillTypeF7();
        this.initPeriodF7();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String pro = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        Object newValue = changeSet[0].getNewValue();
        switch (pro) {
            case "filter_billtype": {
                if (newValue == oldValue) break;
                this.getModel().setValue("filter_billtypebase", null);
                break;
            }
            case "filter_billtypebase": {
                Object billType = this.getModel().getValue("filter_billtype");
                if (null != billType && !"".equalsIgnoreCase(billType.toString())) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u522b\uff01", (String)"BillPoolTradeReportViewPlugin2", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                break;
            }
            case "filter_org": {
                if (newValue == oldValue) break;
                this.getModel().setValue("filter_startperiod", null);
                this.getModel().setValue("filter_endperiod", null);
                break;
            }
            case "filter_queryway": {
                this.setOrgPropMustInput();
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObjectCollection companyList = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        if (null != companyList && companyList.size() != 0) {
            return;
        }
        Long fisBankRollOrg = this.getFisBankRollOrg();
        log.info("fisBankRollOrg:" + fisBankRollOrg);
        DynamicObjectCollection orgList = OrgHelper.getAuthorizedBankOrg(RequestContext.get().getCurrUserId(), "cdm_report_billstrade", "47150e89000000ac");
        Object[] arrObj = new Object[]{};
        if (orgList.size() > 0) {
            log.info("orgList size > 0:");
            arrObj = new Object[]{((DynamicObject)orgList.get(0)).getPkValue()};
            this.getModel().setValue("filter_org", (Object)arrObj);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", OrgHelper.getIdList(orgList)), new QFilter("isfinishinit", "=", (Object)"1")}, null);
            if (fisBankRollOrg != null) {
                DynamicObjectCollection queryFisBankRollOrg = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null);
                if (queryFisBankRollOrg.size() > 0) {
                    this.getModel().setValue("filter_org", (Object)new Object[]{fisBankRollOrg});
                    arrObj = new Object[]{fisBankRollOrg};
                    DynamicObject initObj = this.getCasInitInfo(fisBankRollOrg);
                    this.getModel().setValue("filter_exratetable", initObj.getDynamicObject("exratetable").getPkValue());
                    this.getModel().setValue("filter_endperiod", initObj.getDynamicObject("currentperiod").getPkValue());
                    this.getModel().setValue("filter_startperiod", initObj.getDynamicObject("currentperiod").getPkValue());
                } else if (null != coll && coll.size() > 0) {
                    log.info(fisBankRollOrg + " is not in casInit!");
                    long orgId = ((DynamicObject)coll.get(0)).getLong("id");
                    arrObj = new Object[]{orgId};
                    this.getModel().setValue("filter_org", (Object)arrObj);
                    DynamicObject initObj = this.getCasInitInfo(orgId);
                    this.getModel().setValue("filter_exratetable", initObj.getDynamicObject("exratetable").getPkValue());
                    this.getModel().setValue("filter_endperiod", initObj.getDynamicObject("currentperiod").getPkValue());
                    this.getModel().setValue("filter_startperiod", initObj.getDynamicObject("currentperiod").getPkValue());
                } else {
                    log.info(fisBankRollOrg + " is not in casInit and coll is null!");
                }
            }
        }
        if (!EmptyUtil.isEmpty((Object[])arrObj)) {
            DynamicObject baseCurrency = OrgHelper.getBaseCurrency((Long)arrObj[0]);
            if (baseCurrency != null) {
                this.getModel().setValue("filter_statcurrency", baseCurrency.getPkValue());
            } else {
                String select = "basecurrrency,exratetable";
                Long org = (Long)arrObj[0];
                DynamicObject base = QueryServiceHelper.queryOne((String)"bd_accountingsys_base", (String)select, (QFilter[])new QFilter("baseacctorg", "=", (Object)org).toArray());
                if (null != base) {
                    this.getModel().setValue("filter_statcurrency", (Object)base.getLong("basecurrrency"));
                    this.getModel().setValue("filter_exratetable", (Object)base.getLong("exratetable"));
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOrgPropMustInput();
    }

    private void setOrgPropMustInput() {
        boolean isMustInput = ReportOrgQueryWayEnum.ORG.getValue().equals(this.getModel().getValue("filter_queryway"));
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isMustInput, (String[])new String[]{"filter_org"});
    }

    private DynamicObject getCasInitInfo(long orgId) {
        return SystemStatusCtrolHelper.getSystemStatusCtrol((long)orgId);
    }

    private void initCompanyF7() {
        BasedataEdit acctbankF7 = (BasedataEdit)this.getControl("filter_org");
        acctbankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cdm_report_billstrade", (String)"47150e89000000ac");
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)authOrgList)}, null);
            QFilter qFilterOfBank = new QFilter("id", "in", OrgHelper.getIdList(coll));
            showParameter.getListFilterParameter().setFilter(qFilterOfBank);
        });
    }

    private void initPeriodF7() {
        DynamicObjectCollection company = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        if (null == company || 0 == company.size()) {
            return;
        }
        Set companyIds = company.stream().map(e -> e.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", companyIds)};
        Map values = BusinessDataServiceHelper.loadFromCache((String)"cas_cashmgtinit", (QFilter[])filters);
        HashSet<Long> periodTypeIds = new HashSet<Long>(16);
        HashSet<String> emptyPeriodTypeIds = new HashSet<String>(16);
        for (DynamicObject data : values.values()) {
            DynamicObject periodtypeObj = data.getDynamicObject("periodtype");
            if (EmptyUtil.isNoEmpty((DynamicObject)periodtypeObj)) {
                periodTypeIds.add(periodtypeObj.getLong("id"));
                continue;
            }
            emptyPeriodTypeIds.add(data.getDynamicObject("org").getString("name"));
        }
        if (emptyPeriodTypeIds.size() > 0) {
            log.info("this org has no periodtype:" + SerializationUtils.toJsonString(emptyPeriodTypeIds));
        }
        BasedataEdit startbasedataEditF7 = (BasedataEdit)this.getControl("filter_startperiod");
        startbasedataEditF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilterOfPeriod = new QFilter("periodtype", "in", (Object)periodTypeIds);
            showParameter.getListFilterParameter().setFilter(qFilterOfPeriod);
        });
        BasedataEdit endbasedataEditF7 = (BasedataEdit)this.getControl("filter_endperiod");
        endbasedataEditF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilterOfPeriod = new QFilter("periodtype", "in", (Object)periodTypeIds);
            showParameter.getListFilterParameter().setFilter(qFilterOfPeriod);
        });
    }

    private void initBillTypeF7() {
        Object billType = this.getModel().getValue("filter_billtype");
        if (null == billType || "".equalsIgnoreCase(billType.toString())) {
            return;
        }
        String[] arr = billType.toString().split(",", -1);
        HashSet<String> billTypeSet = new HashSet<String>();
        for (int i = 0; i < arr.length; ++i) {
            String billTypeStr = arr[i];
            if (null == billTypeStr || "".equalsIgnoreCase(billTypeStr)) continue;
            billTypeSet.add(billTypeStr);
        }
        BasedataEdit basedataEditF7 = (BasedataEdit)this.getControl("filter_billtypebase");
        basedataEditF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilterOfBillType = new QFilter("settlementtype", "in", (Object)billTypeSet);
            showParameter.getListFilterParameter().setFilter(qFilterOfBillType);
        });
    }

    private List<Long> getIdList(DynamicObjectCollection coll) {
        ArrayList<Long> idList = new ArrayList<Long>(coll.size());
        for (int i = 0; i < coll.size(); ++i) {
            idList.add((Long)((DynamicObject)coll.get(i)).getDynamicObject("fbasedataid").getPkValue());
        }
        return idList;
    }

    public Long getFisBankRollOrg() {
        RequestContext requestContext = RequestContext.get();
        DynamicObject currentOrg = this.checkCurrentBankOrg();
        if (currentOrg != null && currentOrg.getBoolean("fisbankroll")) {
            return currentOrg.getLong("id");
        }
        List<Long> authorizedBankOrgId = OrgHelper.getAuthorizedBankOrgId(Long.valueOf(requestContext.getUserId()), this.getModel().getDataEntityType().getName(), "47150e89000000ac");
        if (authorizedBankOrgId != null && authorizedBankOrgId.size() > 0) {
            return authorizedBankOrgId.get(0);
        }
        return null;
    }

    public DynamicObject checkCurrentBankOrg() {
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObject currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType);
        if (currentOrg.getBoolean("fisbankroll")) {
            return currentOrg;
        }
        return null;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        FilterInfo filter = event.getQueryParam().getFilter();
        String dataType = filter.getString("filter_datatype");
        List columns = event.getColumns();
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup cols = (ReportColumnGroup)column;
            List children = cols.getChildren();
            for (AbstractReportColumn column1 : children) {
                String key = cols.getFieldKey();
                ReportColumn col = (ReportColumn)column1;
                if (dataType.equalsIgnoreCase("A")) {
                    List<String> payList = Arrays.asList(BillTradeConstant.fieldArr_rec_key);
                    if (payList.contains(key)) {
                        col.setHide(false);
                        continue;
                    }
                    col.setHide(true);
                    continue;
                }
                List<String> recList = Arrays.asList(BillTradeConstant.fieldArr_pay_key);
                if (recList.contains(key)) {
                    col.setHide(false);
                    continue;
                }
                col.setHide(true);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        String fieldName = evt.getFieldName();
        List<String> showBillDetailList = Arrays.asList("oriamountrecbill", "oriamountendorse", "oriamountdiscount", "oriamountcollect", "oriamountbilling", "oriamountpayoff", "oriamountpledge", "oriamountrlspledge", "oriamountenterpool", "oriamountoutpool");
        List<String> showReportDetailList = Arrays.asList("originalamount", "oriamountenddate");
        if (showBillDetailList.contains(fieldName)) {
            this.showBillDetail(rowData);
        } else if (showReportDetailList.contains(fieldName)) {
            this.showReportDetail(rowData, fieldName);
        }
    }

    private void showBillDetail(DynamicObject rowData) {
        Date endDate;
        Date startDate;
        DynamicObject currency;
        String dataType;
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        long orgId = rowData.getLong("company");
        HashMap<String, Object> filterMap = new HashMap<String, Object>(4);
        if (orgId > 0L) {
            qFilter.and(new QFilter("company", "in", (Object)new Object[]{orgId}));
            filterMap.put("company", Collections.singletonList(orgId));
        }
        if ("A".equals(dataType = (String)this.getModel().getValue("filter_datatype"))) {
            qFilter.and(new QFilter("rptype", "=", (Object)"receivebill"));
            filterMap.put("rptype", "receivebill");
        } else {
            qFilter.and(new QFilter("rptype", "=", (Object)"paybill"));
            filterMap.put("rptype", "paybill");
        }
        String billTypeStr = rowData.getString("billtype");
        if (!ObjectUtils.isEmpty((Object)billTypeStr)) {
            DynamicObject billTypeDb = BillTradeReportViewPlugin.findBillTypeBD(billTypeStr);
            qFilter.and(new QFilter("draftbilltype.id", "=", billTypeDb == null ? null : billTypeDb.getPkValue()));
        }
        if (!ObjectUtils.isEmpty((Object)(currency = rowData.getDynamicObject("orginalcurrency")))) {
            qFilter.and(new QFilter("currency.id", "=", currency.getPkValue()));
        }
        if (!ObjectUtils.isEmpty((Object)(startDate = (Date)this.getModel().getValue("filter_startdate")))) {
            qFilter.and(new QFilter("bizdate", ">=", (Object)startDate));
            filterMap.put("bizdates", startDate);
        }
        if (!ObjectUtils.isEmpty((Object)(endDate = (Date)this.getModel().getValue("filter_enddate")))) {
            qFilter.and(new QFilter("bizdate", "<=", (Object)endDate));
            filterMap.put("bizdatee", new Date[]{startDate, endDate});
        }
        filterMap.put("bizdate", new Object[]{DateUtils.formatString((Date)startDate, (String)"yyyy-MM-dd"), DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd")});
        IReportView view = this.getView();
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("cdm_billdetail");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        List qFiltersCol = showParameter.getListFilterParameter().getQFilters();
        qFiltersCol.add(qFilter);
        showParameter.setCustomParam("filterMap", filterMap);
        view.showForm((FormShowParameter)showParameter);
    }

    private void showReportDetail(DynamicObject rowData, String fieldName) {
        Date endDate;
        Date startDate;
        DynamicObject orginalCurrency;
        String billTypeStr;
        String dataType;
        FilterInfo toDetailFilter = new FilterInfo();
        long orgId = rowData.getLong("company");
        if (orgId > 0L) {
            toDetailFilter.addFilterItem("filter_org", (Object)new Object[]{orgId});
        }
        if ("A".equals(dataType = (String)this.getModel().getValue("filter_datatype"))) {
            toDetailFilter.addFilterItem("filter_rptype", (Object)"receivebill");
        } else {
            toDetailFilter.addFilterItem("filter_rptype", (Object)"paybill");
        }
        String billType = (String)this.getModel().getValue("filter_billtype");
        if (!ObjectUtils.isEmpty((Object)billType)) {
            toDetailFilter.addFilterItem("filter_billtype", (Object)billType);
        }
        if (!ObjectUtils.isEmpty((Object)(billTypeStr = rowData.getString("billtype")))) {
            Object[] objectArray;
            DynamicObject billTypeDb = BillTradeReportViewPlugin.findBillTypeBD(billTypeStr);
            if (billTypeDb == null) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = billTypeDb.getPkValue();
            }
            toDetailFilter.addFilterItem("filter_billtypebase", objectArray);
        }
        if (!ObjectUtils.isEmpty((Object)(orginalCurrency = rowData.getDynamicObject("orginalcurrency")))) {
            toDetailFilter.addFilterItem("filter_currency", (Object)new Object[]{orginalCurrency.getPkValue()});
        }
        if (!ObjectUtils.isEmpty((Object)(startDate = (Date)this.getModel().getValue("filter_startdate"))) && "originalamount".equals(fieldName)) {
            toDetailFilter.addFilterItem("bizdate_startdate", (Object)startDate);
            toDetailFilter.addFilterItem("filter_queryenddate", (Object)DateUtils.getLastDay((Date)startDate, (int)1));
        }
        if (!ObjectUtils.isEmpty((Object)(endDate = (Date)this.getModel().getValue("filter_enddate"))) && "oriamountenddate".equals(fieldName)) {
            toDetailFilter.addFilterItem("bizdate_enddate", (Object)endDate);
            toDetailFilter.addFilterItem("filter_queryenddate", (Object)endDate);
        }
        IReportView view = this.getView();
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setCustomParam("filter", (Object)SerializationUtils.serializeToBase64((Object)toDetailFilter));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("cdm_report_bill_dy_detail");
        parameter.getCustomParams().put("queryDetail", "true");
        view.showForm((FormShowParameter)parameter);
    }

    private static DynamicObject findBillTypeBD(String value) {
        QFilter nameQFilter = new QFilter("name", "=", (Object)value);
        DynamicObject[] dynamicObjectArr = TmcDataServiceHelper.load((String)"cdm_billtype", (String)"id", (QFilter[])new QFilter[]{nameQFilter});
        if (dynamicObjectArr.length > 0) {
            return TmcDataServiceHelper.loadSingle((Object)dynamicObjectArr[0].getPkValue(), (String)"cdm_billtype");
        }
        return null;
    }
}

