/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.plugin.data;

import java.util.Collections;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.report.constant.BillDynamicQueryDetailProp;
import kd.tmc.cdm.report.helper.DraftDynamicQueryReportHelper;
import kd.tmc.cdm.report.helper.ReportDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;

public class BillDynamicQueryDetailDataListPlugin
extends AbstractTmcListDataPlugin {
    private static final Log LOGGER = LogFactory.getLog(BillDynamicQueryDetailDataListPlugin.class);

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        Map<String, Object> transQueryParam = ReportDataHelper.transQueryParam(queryParam);
        DataSet bizDataSet = DraftDynamicQueryReportHelper.queryDataSet(queryParam);
        if (bizDataSet == null) {
            return null;
        }
        bizDataSet = this.exchangeRateAndUnitDataSet(bizDataSet, transQueryParam);
        String statDim = (String)transQueryParam.get("filter_statdim");
        DynamicObject reportCurrency = (DynamicObject)transQueryParam.get("filter_reportcurrency");
        String sumField = "reportamount";
        String sumNameField = "statcoltext";
        DataSet subTotalSet = this.addSubTotalDataSet(bizDataSet, Collections.singletonList(statDim), Collections.singletonList(sumField), sumNameField);
        DataSet totalSet = this.addAllTotalDataSet(bizDataSet, Collections.singletonList(sumField), sumNameField);
        bizDataSet = bizDataSet.union(subTotalSet).orderBy(new String[]{statDim, this.sumField});
        return bizDataSet.union(totalSet).addField(String.valueOf(reportCurrency.getPkValue()), "reportcurrency");
    }

    private DataSet exchangeRateAndUnitDataSet(DataSet bizDataSet, Map<String, Object> transQueryParam) {
        DynamicObject exRateTable = (DynamicObject)transQueryParam.get("filter_exratetable");
        DynamicObjectCollection filterCurrencies = (DynamicObjectCollection)transQueryParam.get("filter_currency");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)filterCurrencies)) {
            filterCurrencies = QueryServiceHelper.query((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        }
        DynamicObject reportCurrency = (DynamicObject)transQueryParam.get("filter_reportcurrency");
        String statUnit = (String)transQueryParam.get("filter_statunit");
        return ReportDataHelper.exchangeRateAndUnit(bizDataSet, filterCurrencies, reportCurrency, exRateTable, statUnit, BillDynamicQueryDetailProp.AMOUNT_MAPPING_MAP);
    }
}

