/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.plugin.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.report.helper.BillExpireCurrencyEnum;
import kd.tmc.cdm.report.helper.ReportDataHelper;
import kd.tmc.cdm.report.helper.RptFilterParamHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class BillExpiredDetailDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String ENABLE = "enable";
    private static final Map<String, String> V_TREE_BASE_COMPANY_MAP = new HashMap<String, String>(3);
    private String radixStr = "/1";
    private static final Map<String, String> PROPERTY_MAPPING_MAP = new HashMap<String, String>(4);
    private static final Map<String, String> AMOUNT_MAPPING_MAP = new HashMap<String, String>(1);
    public static final String SELECT = "id,company.id as companyid,company.name as company, draftbillexpiredate as expiredate, acceptercompany.name as acceptername,currency, amount as totalamount";
    private static final Map<String, BillExpireCurrencyEnum> CURRENCY_UNIT_MAP;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam param) {
        Map<String, Object> paramMap = ReportDataHelper.transQueryParam(param);
        List orgIds = this.getQueryOrgIds(param);
        QFilter filter = BillExpiredDetailDataListPlugin.initExpiredDetailFilter(paramMap, PROPERTY_MAPPING_MAP, orgIds);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        String currencyUnit = (String)paramMap.get("filter_currencyunit");
        if (StringUtils.isNotEmpty((CharSequence)currencyUnit)) {
            this.radixStr = "/" + CURRENCY_UNIT_MAP.get(currencyUnit).getRadix();
        }
        String filterDatatype = (String)paramMap.get("filter_datatype");
        ArrayList<String> statList = new ArrayList<String>(Arrays.asList("report_totalamount", "report_totalfeeamount"));
        if (StringUtils.equals((CharSequence)filterDatatype, (CharSequence)"A")) {
            AMOUNT_MAPPING_MAP.remove("ispayinterest_amount");
            dataSet = this.receivableBillExpiredSum(paramMap, filters);
        } else {
            AMOUNT_MAPPING_MAP.put("ispayinterest_amount", "report_ispayinterest");
            statList = new ArrayList<String>(Arrays.asList("report_totalamount", "report_ispayinterest", "report_totalfeeamount"));
            dataSet = this.payableBillExpiredSum(paramMap, filters);
        }
        DynamicObjectCollection filterCurrencies = !EmptyUtil.isEmpty((Object)paramMap.get("filter_currencies")) ? (DynamicObjectCollection)paramMap.get("filter_currencies") : QueryServiceHelper.query((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1")});
        DynamicObject reportCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        DynamicObject rateTable = (DynamicObject)paramMap.get("filter_exratetable");
        if (EmptyUtil.isEmpty((Object)dataSet)) {
            return dataSet;
        }
        dataSet = ReportDataHelper.exchangeRate(dataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        if ("org".equals(paramMap.get("filter_queryway"))) {
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"cdm", (String)"cdm_report_expired_detail", (String)"47150e89000000ac");
            dataSet = this.getTreeDataSet(dataSet, null, orgIdList, statList).addField(String.valueOf(reportCurrency.getPkValue()), "report_currency");
        } else if ("orgview".equals(paramMap.get("filter_queryway"))) {
            Long companyViewId = (Long)paramMap.get("companyviewnum");
            dataSet = this.getTreeDataSet(dataSet, companyViewId, null, statList).addField(String.valueOf(reportCurrency.getPkValue()), "report_currency");
        }
        dataSet = dataSet.orderBy(new String[]{"expiredate DESC", "acceptername ASC", "currency ASC"});
        return dataSet;
    }

    public static QFilter initExpiredDetailFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping, List<Long> orgIds) {
        QFilter billstatusFilter;
        QFilter accepterFilter;
        QFilter billMediumFilter;
        QFilter warnDateRangeFilter;
        QFilter currencyFilter;
        QFilter filter = new QFilter("company.id", "in", orgIds);
        QFilter billTypeFilter = RptFilterParamHelper.initBillTypeFilter(paramMap, propertyMapping);
        if (billTypeFilter != null) {
            filter = filter.and(billTypeFilter);
        }
        if ((currencyFilter = RptFilterParamHelper.initCurrencyFilter(paramMap, propertyMapping)) != null) {
            filter = filter.and(currencyFilter);
        }
        if ((warnDateRangeFilter = RptFilterParamHelper.initWarnDateRange(paramMap, propertyMapping)) != null) {
            filter = filter.and(warnDateRangeFilter);
        }
        if ((billMediumFilter = RptFilterParamHelper.initBillMediumFilter(paramMap, propertyMapping)) != null) {
            filter = filter.and(billMediumFilter);
        }
        if ((accepterFilter = RptFilterParamHelper.initBillAccepterFilter(paramMap, propertyMapping)) != null) {
            filter = filter.and(accepterFilter);
        }
        String multiBillstatus = "";
        String datatype = (String)paramMap.get("filter_datatype");
        if (EmptyUtil.isNoEmpty((String)datatype)) {
            multiBillstatus = StringUtils.equals((CharSequence)datatype, (CharSequence)"A") ? (String)paramMap.get("filter_billstatus_a") : (String)paramMap.get("filter_billstatus_b");
        }
        if (!EmptyUtil.isEmpty((String)multiBillstatus)) {
            multiBillstatus = multiBillstatus.substring(1, multiBillstatus.length() - 1);
            billstatusFilter = new QFilter("draftbillstatus", "in", (Object)multiBillstatus.split(","));
            filter = filter.and(billstatusFilter);
        }
        billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        filter = filter.and(billstatusFilter);
        QFilter draftbilltranstatusFilter = new QFilter("draftbilltranstatus", "=", (Object)"success");
        filter = filter.and(draftbilltranstatusFilter);
        if (EmptyUtil.isNoEmpty((String)datatype)) {
            if (StringUtils.equals((CharSequence)datatype, (CharSequence)"A")) {
                QFilter rptypeFilter = new QFilter("rptype", "=", (Object)"receivebill");
                filter = filter.and(rptypeFilter);
            } else {
                QFilter rptypeFilter = new QFilter("rptype", "=", (Object)"paybill");
                filter = filter.and(rptypeFilter);
            }
        }
        return filter;
    }

    private DataSet receivableBillExpiredSum(Map<String, Object> paramMap, List<QFilter> filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"cdm_receivablebill", (String)"cdm_receivablebill", (String)("id,billno,company.id as companyid,company.name as company, draftbillexpiredate as expiredate, draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as totalamount"), (QFilter[])filters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        DataSet copyDataSet = dataSet.copy().select("id as idcopy,expiredate as expiredatecopy");
        Date expiredDate = (Date)paramMap.get("filter_expireddate");
        String expiredDateStr = "'" + DateUtils.formatString((Date)expiredDate, (String)"yyyy-MM-dd") + " 00:00:00.0'";
        copyDataSet = copyDataSet.addField("concat(DATEDIF(expiredatecopy, " + expiredDateStr + ",'D'),\"\")", "expire_leftdays");
        String[] leftSelector = (String[])Arrays.stream(dataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        String[] rightSelector = (String[])Arrays.stream(copyDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSet = dataSet.leftJoin(copyDataSet).on("id", "idcopy").select(leftSelector, rightSelector).finish();
        DataSet idsDataSet = dataSet.copy().select("id").distinct();
        Iterator itIds = idsDataSet.iterator();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (itIds.hasNext()) {
            Row data = (Row)itIds.next();
            Long id = data.getLong("id");
            ids.add(id);
        }
        QFilter feeDetailFilter = new QFilter("appsource", "=", (Object)"cdm").and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("entry.srcbillid", "in", (Object)ids.toArray()));
        DataSet feeDetailData = QueryServiceHelper.queryDataSet((String)"cfm_feebill", (String)"cfm_feebill", (String)("entry.feedetailamt" + this.radixStr + " as totalfeeamount, entry.srcbillid as srcbillid"), (QFilter[])new QFilter[]{feeDetailFilter}, null);
        DataSet feeDetailDataSum = feeDetailData.copy().select(new String[]{"totalfeeamount", "srcbillid"}).groupBy(new String[]{"srcbillid"}).sum("totalfeeamount").finish();
        String[] dataSetLeftSelector = (String[])Arrays.stream(dataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSet = dataSet.join(feeDetailDataSum, JoinType.LEFT).on("id", "srcbillid").select(dataSetLeftSelector, new String[]{"totalfeeamount", "srcbillid"}).finish();
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"company", "companyid", "expiredate", "expire_leftdays", "billtype", "draftbillno", "acceptername", "currency"});
        groupbyDataSet = groupbyDataSet.sum("totalamount");
        dataSet = groupbyDataSet.sum("totalfeeamount").finish();
        dataSet = dataSet.orderBy(new String[]{"expiredate DESC", "acceptername ASC", "currency ASC"});
        return dataSet;
    }

    private DataSet payableBillExpiredSum(Map<String, Object> paramMap, List<QFilter> filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid,company.name as company, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as totalamount"), (QFilter[])filters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        DataSet copyDataSet = dataSet.copy().select("id as idcopy,expiredate as expiredatecopy");
        Date expiredDate = (Date)paramMap.get("filter_expireddate");
        String expiredDateStr = "'" + DateUtils.formatString((Date)expiredDate, (String)"yyyy-MM-dd") + " 00:00:00.0'";
        copyDataSet = copyDataSet.addField("concat(DATEDIF(expiredatecopy, " + expiredDateStr + ",'D'),\"\")", "expire_leftdays");
        String[] leftSelector = (String[])Arrays.stream(dataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        String[] rightSelector = (String[])Arrays.stream(copyDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSet = dataSet.leftJoin(copyDataSet).on("id", "idcopy").select(leftSelector, rightSelector).finish();
        DataSet ispayinterestDataSet = dataSet.copy().filter("ispayinterest = true");
        DataSet idDataSet = ispayinterestDataSet.copy().select("id").distinct();
        Iterator idsIterator = idDataSet.iterator();
        ArrayList<Long> idList = new ArrayList<Long>();
        while (idsIterator.hasNext()) {
            Row data = (Row)idsIterator.next();
            Long id = data.getLong("id");
            idList.add(id);
        }
        QFilter tradeTypeFilter = new QFilter("tradetype", "=", (Object)"payinterest");
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter billTranStatusFilter = new QFilter("draftbilltranstatus", "=", (Object)"success");
        QFilter draftbillIdFilter = new QFilter("entrys.draftbill.id", "in", (Object)idList.toArray());
        QFilter[] qFilters = new QFilter[]{tradeTypeFilter, billStatusFilter, billTranStatusFilter, draftbillIdFilter};
        DataSet payinterestDataSet = QueryServiceHelper.queryDataSet((String)"cdm_drafttradebill", (String)"cdm_drafttradebill", (String)("id,discount_interest" + this.radixStr + " as ispayinterest_amount,entrys.draftbill.id,createtime"), (QFilter[])qFilters, null).orderBy(new String[]{"createtime DESC"});
        String[] dataSetLeftSelector = (String[])Arrays.stream(dataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSet = dataSet.join(payinterestDataSet, JoinType.LEFT).on("id", "entrys.draftbill.id").select(dataSetLeftSelector, new String[]{"ispayinterest_amount"}).finish();
        DataSet idsDataSet = dataSet.copy().select("id").distinct();
        Iterator itIds = idsDataSet.iterator();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (itIds.hasNext()) {
            Row data = (Row)itIds.next();
            Long id = data.getLong("id");
            ids.add(id);
        }
        QFilter feeDetailFilter = new QFilter("appsource", "=", (Object)"cdm").and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("entry.srcbillid", "in", (Object)ids.toArray()));
        DataSet feeDetailData = QueryServiceHelper.queryDataSet((String)"cfm_feebill", (String)"cfm_feebill", (String)("entry.feedetailamt" + this.radixStr + " as totalfeeamount, entry.srcbillid as srcbillid"), (QFilter[])new QFilter[]{feeDetailFilter}, null);
        DataSet feeDetailDataSum = feeDetailData.copy().select(new String[]{"totalfeeamount", "srcbillid"}).groupBy(new String[]{"srcbillid"}).sum("totalfeeamount").finish();
        dataSetLeftSelector = (String[])Arrays.stream(dataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSet = dataSet.join(feeDetailDataSum, JoinType.LEFT).on("id", "srcbillid").select(dataSetLeftSelector, new String[]{"totalfeeamount", "srcbillid"}).finish();
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"company", "companyid", "expiredate", "expire_leftdays", "billtype", "draftbillno", "acceptername", "currency"});
        groupbyDataSet = groupbyDataSet.sum("totalamount");
        groupbyDataSet = groupbyDataSet.sum("ispayinterest_amount");
        dataSet = groupbyDataSet.sum("totalfeeamount").finish();
        dataSet = dataSet.orderBy(new String[]{"expiredate DESC", "acceptername ASC", "currency ASC"});
        return dataSet;
    }

    private DataSet getTreeDataSet(DataSet bizDs, Long companyViewId, List<Long> orgIdList, List<String> statList) {
        Map<String, String> vTreeBaseMap = V_TREE_BASE_COMPANY_MAP;
        Map<String, String> vbizBaseMap = ReportDataHelper.getBizBaseMap(bizDs, statList, vTreeBaseMap);
        bizDs = ReportDataHelper.getBizDsWithOrgTree(bizDs, "rowid", "companyid", statList, vTreeBaseMap, vbizBaseMap, companyViewId, orgIdList);
        bizDs = ReportDataHelper.getSumDataSet(bizDs, statList, true, (AbstractTmcListDataPlugin)this);
        return bizDs;
    }

    static {
        V_TREE_BASE_COMPANY_MAP.put("company", "orgname");
        V_TREE_BASE_COMPANY_MAP.put("companyid", "rowid");
        PROPERTY_MAPPING_MAP.put("filter_company", "company.id");
        PROPERTY_MAPPING_MAP.put("filter_billtypebase", "draftbilltype.id");
        PROPERTY_MAPPING_MAP.put("filter_billmedium", "draftbilltype.billmedium");
        AMOUNT_MAPPING_MAP.put("totalamount", "report_totalamount");
        AMOUNT_MAPPING_MAP.put("totalfeeamount", "report_totalfeeamount");
        CURRENCY_UNIT_MAP = Collections.unmodifiableMap(new HashMap<String, BillExpireCurrencyEnum>(8){
            {
                this.put(BillExpireCurrencyEnum.BILLION.getRadix(), BillExpireCurrencyEnum.BILLION);
                this.put(BillExpireCurrencyEnum.MILLION.getRadix(), BillExpireCurrencyEnum.MILLION);
                this.put(BillExpireCurrencyEnum.TENTHOUSAND.getRadix(), BillExpireCurrencyEnum.TENTHOUSAND);
                this.put(BillExpireCurrencyEnum.THOUSAND.getRadix(), BillExpireCurrencyEnum.THOUSAND);
                this.put(BillExpireCurrencyEnum.ORIGINAL.getRadix(), BillExpireCurrencyEnum.ORIGINAL);
            }
        });
    }
}

