/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.plugin.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.cdm.report.helper.ReportDataHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillChequeViewPlugin
extends AbstractReportFormPlugin {
    private static final String SYSTEM_TYPE = "tmc-cdm-report";
    private Map<String, Object> paramMap = null;

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
        event.setTreeExpandColId("company");
    }

    public void initialize() {
        super.initialize();
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initAccountBankF7();
        this.initBillTypeF7();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "filter_bank": 
            case "filter_company": 
            case "filter_orgview": {
                this.getModel().setValue("filter_accountbank", null);
                break;
            }
            case "filter_dateranges": {
                if ("custom".equals(e.getChangeSet()[0])) break;
                this.getModel().setValue("filter_dateranges_startdate", null);
                this.getModel().setValue("filter_dateranges_enddate", null);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam param) {
        Map<String, Object> paramMap = this.getParamMap(param);
        String dateRange = (String)this.getModel().getValue("filter_dateranges");
        if (RptDateRangeEnum.CUSTOM.getValue().equals(dateRange)) {
            if (EmptyUtil.isEmpty((Object)paramMap.get("filter_dateranges_startdate")) || EmptyUtil.isEmpty((Object)paramMap.get("filter_dateranges_enddate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillChequeViewPlugin0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (((Date)paramMap.get("filter_dateranges_startdate")).after((Date)paramMap.get("filter_dateranges_startdate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f", (String)"BillChequeViewPlugin1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam param) {
        super.beforeQuery(param);
    }

    private void initAccountBankF7() {
        BasedataEdit f7 = (BasedataEdit)this.getControl("filter_accountbank");
        f7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            MulBasedataDynamicObjectCollection bank = (MulBasedataDynamicObjectCollection)this.getModel().getValue("filter_bank");
            ArrayList<Long> bankIdList = new ArrayList<Long>();
            for (DynamicObject obj : bank) {
                long id = obj.getDynamicObject("fbasedataid").getLong("id");
                bankIdList.add(id);
            }
            if (!bankIdList.isEmpty()) {
                showParameter.getListFilterParameter().setFilter(new QFilter("bank.id", "in", bankIdList));
            }
            showParameter.getListFilterParameter().setFilter(new QFilter("org.id", "in", this.getOrgIds()));
        });
    }

    private void initBillTypeF7() {
        BasedataEdit f7 = (BasedataEdit)this.getControl("filter_billtypebase");
        f7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("settlementtype", "=", (Object)"1").and(new QFilter("enable", "=", (Object)"1"));
            showParameter.getListFilterParameter().setFilter(filter);
        });
    }

    private List<Long> getOrgIds() {
        ReportShowParameter parameter = (ReportShowParameter)this.getView().getFormShowParameter();
        List<Object> orgIds = new ArrayList(10);
        Long userId = RequestContext.get().getCurrUserId();
        String formId = parameter.getFormId();
        String appId = parameter.getAppId();
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)this.getModel().getValue("filter_orgview");
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgIds = this.getOrgPropValues();
                orgIds = EmptyUtil.isEmpty(orgIds) ? TmcOrgDataHelper.getAuthorizedAndSubordinateOrgByView((Long)orgView.getLong("id"), (Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac", (boolean)true, (boolean)true) : TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgView.getLong("id"), orgIds, (boolean)true, (boolean)true);
            }
        } else {
            orgIds = this.getOrgPropValues();
            if (EmptyUtil.isEmpty(orgIds)) {
                orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
            }
        }
        return orgIds;
    }

    private List<Long> getOrgPropValues() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)orgs)) {
            return Collections.EMPTY_LIST;
        }
        return orgs.stream().map(v -> (Long)v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
    }

    private Map<String, Object> getParamMap(ReportQueryParam param) {
        if (this.paramMap == null) {
            this.paramMap = ReportDataHelper.transQueryParam(param);
        }
        return this.paramMap;
    }
}

