/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.print;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportView;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ObjectField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.report.helper.BillTradeConstant;
import kd.tmc.cdm.report.helper.BillTradeQueryHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillTradeReportPrintPluginNew
extends AbstractPrintPlugin {
    private static final Log logger = LogFactory.getLog(BillTradeReportPrintPluginNew.class);
    private static final String TABLE_FIELD = "table_field";
    private static final String TABLE_HEAD = "table_head";

    public void loadCustomData(CustomDataLoadEvent evt) {
        DynamicObject reportCurrency;
        CustomDataSource dataSource = evt.getDataSource();
        String dataSourceName = dataSource.getDsName();
        List dyns = evt.getCustomDataRows();
        ReportView view = (ReportView)SessionManager.getCurrent().getView(dataSource.getPageId());
        ReportQueryParam queryParam = view.getQueryParam();
        String typeName = view.getModel().getDataEntityType().getName();
        FilterInfo filter = queryParam.getFilter();
        FilterItemInfo filterItem = filter.getFilterItem("filter_statcurrency");
        int reportScale = 2;
        if (Objects.isNull(filterItem) || Objects.isNull(reportCurrency = (DynamicObject)filterItem.getValue())) {
            return;
        }
        reportCurrency = BusinessDataServiceHelper.loadSingle((Object)reportCurrency.getPkValue(), (DynamicObjectType)reportCurrency.getDynamicObjectType());
        if (StringUtils.equals((CharSequence)dataSourceName, (CharSequence)TABLE_HEAD)) {
            String statisticUnit = filter.getString("filter_currencyunit");
            DataRowSet capitalSumHead = new DataRowSet();
            capitalSumHead.put("currencyunit", (Field)new TextField(ResManager.loadKDString((String)"\u7edf\u8ba1\u5355\u4f4d\uff1a%s", (String)"BillTradeReportPrintPlugin1", (String)"tmc-cdm-report", (Object[])new Object[]{BillTradeQueryHelper.getCurrencyUnit(statisticUnit).getName().getDescription()})));
            capitalSumHead.put("reportcurrency", (Field)new TextField(ResManager.loadKDString((String)"\u62a5\u544a\u5e01\uff1a%s", (String)"BillTradeReportPrintPlugin0", (String)"tmc-cdm-report", (Object[])new Object[]{reportCurrency.getString("name")})));
            dyns.add(capitalSumHead);
        } else if (StringUtils.equals((CharSequence)dataSourceName, (CharSequence)TABLE_FIELD)) {
            if (reportCurrency != null) {
                reportScale = reportCurrency.getInt("amtprecision");
            }
            DataSet dataSet = filter.containProp("filter_billtradepool") ? BillTradeQueryHelper.query(queryParam, Boolean.TRUE) : BillTradeQueryHelper.query(queryParam, Boolean.FALSE);
            String dataType = "";
            if (typeName.equalsIgnoreCase("cdm_report_billstrade")) {
                FilterItemInfo filterDataType = filter.getFilterItem("filter_datatype");
                dataType = "A".equalsIgnoreCase(filterDataType.getString()) ? "A" : "B";
            } else if (typeName.equalsIgnoreCase("cdm_report_billpooltrade")) {
                dataType = "C";
            }
            List fieldList = dataSource.getQueryField();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                DataRowSet capitalsumbody = this.fillData(row, fieldList, dataType, reportScale);
                dyns.add(capitalsumbody);
            }
            if (EmptyUtil.isNoEmpty((Object)dataSet)) {
                dataSet.close();
            }
        }
    }

    private DataRowSet fillData(Row row, List<String> fieldList, String dataType, int reportScale) {
        DataRowSet capitalsumbody = new DataRowSet();
        for (String name : fieldList) {
            int scale;
            block4: {
                if (dataType.equalsIgnoreCase("A") ? !Arrays.asList(BillTradeConstant.fieldArr_rec).contains(name) : (dataType.equalsIgnoreCase("B") ? !Arrays.asList(BillTradeConstant.fieldArr_pay).contains(name) : dataType.equalsIgnoreCase("C") && !Arrays.asList(BillTradeConstant.fieldArr_pool).contains(name))) continue;
                scale = 2;
                Object currencyPk = row.get("orginalcurrency");
                if (currencyPk != null) {
                    try {
                        DynamicObject currency = BusinessDataServiceHelper.loadSingle((Object)currencyPk, (String)"bd_currency", (String)"amtprecision");
                        if (currency == null) break block4;
                        scale = currency.getInt("amtprecision");
                    }
                    catch (Exception e) {
                        logger.error("\u67e5\u8be2\u5e01\u79cd\u5931\u8d25\uff0ccurrencyId: {}, error: {}", currencyPk, (Object)e);
                        continue;
                    }
                }
            }
            capitalsumbody.put(name, (Field)new ObjectField(this.getValueFormatIfNeed(name, row, scale, reportScale)));
        }
        return capitalsumbody;
    }

    private Object getValueFormatIfNeed(String name, Row row, int scale, int reportScale) {
        Object obj = row.get(name);
        if (Objects.isNull(obj)) {
            return "";
        }
        switch (name) {
            case "originalamount": 
            case "oriamountenddate": 
            case "oriamountrecbill": 
            case "oriamountendorse": 
            case "oriamountdiscount": 
            case "oriamountcollect": 
            case "oriamountpledge": 
            case "oriamountrlspledge": 
            case "oriamountenterpool": 
            case "oriamountoutpool": 
            case "oriamountbilling": 
            case "oriamountpayoff": {
                obj = BillTradeReportPrintPluginNew.formatDecimal((BigDecimal)obj, scale);
                break;
            }
            case "reportamount": 
            case "repamountenddate": 
            case "repamountrecbill": 
            case "repamountendorse": 
            case "repamountdiscount": 
            case "repamountcollect": 
            case "repamountpledge": 
            case "repamountrlspledge": 
            case "repamountenterpool": 
            case "repamountoutpool": 
            case "repamountbilling": 
            case "repamountpayoff": {
                obj = BillTradeReportPrintPluginNew.formatDecimal((BigDecimal)obj, reportScale);
                break;
            }
        }
        return obj;
    }

    public static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(BillTradeReportPrintPluginNew.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static String toPattern(int scale) {
        StringBuilder s = new StringBuilder(25);
        s.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            s.append('0');
        }
        return s.toString();
    }
}

