/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.opplugin.bankdrafts;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankDraftImportOp
extends BatchImportPlugin {
    private static final String NEW = "new";
    private static final int MAX_IMPORT_SIZE = 10000000;
    private static final String IMPORT_TYPE = "importtype";
    private static final String KEY_FIELDS = "KeyFields";
    private static final Log LOGGERTOOL = LogFactory.getLog(BankDraftImportOp.class);
    private static IAppCache cache = TmcAppCache.get((String)"cdm", (String)"inventory", (String)"bankdraftparam");
    private HashMap<String, String> paramMap = new HashMap(16);

    protected int getBatchImportSize() {
        return 10000000;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        LOGGERTOOL.info("super.beforeSave >>> start...");
        super.beforeSave(billdatas, logger);
        LOGGERTOOL.info("super.beforeSave >>> end...");
        Map options = this.ctx.getOption();
        this.dealData(billdatas, logger, options);
        LOGGERTOOL.info("beforeSave >>> end...");
    }

    private void dealData(List<ImportBillData> billdatas, ImportLogger logger, Map<String, Object> options) {
        Object importType = options.get(IMPORT_TYPE);
        if (EmptyUtil.isNoEmpty(billdatas)) {
            LOGGERTOOL.info("dealData >>> importType is:" + importType + ",billdatas.size is:" + billdatas.size());
            if (NEW.equals(String.valueOf(importType))) {
                this.handleAddData(billdatas, logger);
                LOGGERTOOL.info("handleAddData >>> end...");
            }
        }
    }

    private List<ImportBillData> handleAddData(List<ImportBillData> billdatas, ImportLogger logger) {
        LOGGERTOOL.info("handleAddData >>> checkParams start...");
        List<ImportBillData> checkedBillDatas = this.checkParams(billdatas, logger);
        return checkedBillDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportBillData> checkParams(List<ImportBillData> billdatas, ImportLogger logger) {
        String orgId = this.paramMap.get("orgid");
        String bankaccId = this.paramMap.get("bankaccid");
        String dataDateParamStr = this.paramMap.get("datadate");
        String biztype = this.paramMap.get("biztype");
        LOGGERTOOL.info("paramMap is:" + SerializationUtils.toJsonString(this.paramMap));
        Date dataDateParam = DateUtils.stringToDate((String)dataDateParamStr, (String)"yyyy-MM-dd");
        DynamicObjectCollection bankAccColl = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,number,name,bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(bankaccId))});
        DynamicObjectCollection orgIdColl = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(orgId))});
        String bankNameParam = ((DynamicObject)bankAccColl.get(0)).getString("name");
        String bankNumberParam = ((DynamicObject)bankAccColl.get(0)).getString("number");
        String bankaccountnumberParam = ((DynamicObject)bankAccColl.get(0)).getString("bankaccountnumber");
        String orgNumberParam = ((DynamicObject)orgIdColl.get(0)).getString("number");
        String orgNameParam = ((DynamicObject)orgIdColl.get(0)).getString("name");
        HashSet<String> draftBillnoAndRangeStrSet = new HashSet<String>(16);
        HashSet<String> currNumStrSet = new HashSet<String>(16);
        HashSet<String> currNameStrSet = new HashSet<String>(16);
        HashSet<String> draftBillnoNotSplitSet = new HashSet<String>(16);
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            String errorMessage = null;
            ImportBillData rowData = it.next();
            JSONObject data = rowData.getData();
            try {
                String accBankNumber;
                JSONObject accImport;
                String accImportprop;
                String orgName;
                String currName;
                JSONArray bankdraftentry = data.getJSONArray("bankdraftentry");
                for (int i = 0; i < bankdraftentry.size(); ++i) {
                    JSONObject entry = bankdraftentry.getJSONObject(i);
                    entry.put("e_datasource", (Object)"import");
                }
                JSONObject billcurrency = data.getJSONObject("billcurrency");
                String currImportprop = billcurrency.getString("importprop");
                if ("number".equals(currImportprop)) {
                    String currNum = billcurrency.getString("number");
                    if (EmptyUtil.isNoEmpty((String)currNum)) {
                        if (EmptyUtil.isNoEmpty(currNumStrSet) && currNumStrSet.size() > 0) {
                            if (!currNumStrSet.contains(currNum)) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u5f15\u5165\u591a\u79cd\u5e01\u79cd\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_1_1", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
                            }
                        } else {
                            currNumStrSet.add(currNum);
                        }
                    }
                } else if ("name".equals(currImportprop) && EmptyUtil.isNoEmpty((String)(currName = billcurrency.getString("name")))) {
                    if (EmptyUtil.isNoEmpty(currNameStrSet) && currNameStrSet.size() > 0) {
                        if (!currNameStrSet.contains(currName)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u5f15\u5165\u591a\u79cd\u5e01\u79cd\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_1_1", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
                        }
                    } else {
                        currNameStrSet.add(currName);
                    }
                }
                JSONObject orgImport = data.getJSONObject("org");
                String orgImportprop = orgImport.getString("importprop");
                if ("number".equals(orgImportprop)) {
                    String orgNumber = orgImport.getString("number");
                    if (!orgNumberParam.equals(orgNumber)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7.\u7f16\u7801\u3010%s\u3011\u4e0e\u6240\u9009\u62e9\u7684\u5f15\u5165\u8d44\u91d1\u7ec4\u7ec7\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_1", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), orgNumber));
                    }
                } else if ("name".equals(orgImportprop) && !orgNameParam.equals(orgName = orgImport.getString("name"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7.\u540d\u79f0\u3010%s\u3011\u4e0e\u6240\u9009\u62e9\u7684\u5f15\u5165\u8d44\u91d1\u7ec4\u7ec7\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_2", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), orgName));
                }
                if ("number".equals(accImportprop = (accImport = data.getJSONObject("bankaccount")).getString("importprop"))) {
                    String orgNumber = accImport.getString("number");
                    if (!bankNumberParam.equals(orgNumber)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7.\u7f16\u7801\u3010%s\u3011\u4e0e\u6240\u9009\u62e9\u7684\u5f15\u5165\u94f6\u884c\u8d26\u53f7\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_4", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), orgNumber));
                    }
                } else if ("name".equals(accImportprop)) {
                    String accName = accImport.getString("name");
                    if (!bankNameParam.equals(accName)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7.\u540d\u79f0\u3010%s\u3011\u4e0e\u6240\u9009\u62e9\u7684\u5f15\u5165\u94f6\u884c\u8d26\u53f7\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_4_1", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), accName));
                    }
                } else if ("bankaccountnumber".equals(accImportprop) && !bankaccountnumberParam.equals(accBankNumber = accImport.getString("bankaccountnumber"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7.\u94f6\u884c\u8d26\u53f7\u3010%s\u3011\u4e0e\u6240\u9009\u62e9\u7684\u5f15\u5165\u94f6\u884c\u8d26\u53f7\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_3", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), accBankNumber));
                }
                Date datadateStr = data.getDate("datadate");
                String datadateFormatStr = DateUtils.formatString((Date)datadateStr, (String)"yyyy-MM-dd");
                if (EmptyUtil.isNoEmpty((Object)datadateStr) && DateUtils.stringToDate((String)datadateFormatStr, (String)"yyyy-MM-dd").compareTo(dataDateParam) != 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u65e5\u671f\u3010%s\u3011\u4e0e\u6240\u9009\u62e9\u7684\u5f15\u5165\u6570\u636e\u65e5\u671f\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_5", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), datadateFormatStr));
                }
                String biztypeStr = data.getString("biztype");
                String bizType_zn = ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e", (String)"BankDraftImportOp_5_2", (String)"tmc-cdm-opplugin", (Object[])new Object[0]);
                if (!"rec".equals(biztypeStr)) {
                    bizType_zn = ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e", (String)"BankDraftImportOp_5_3", (String)"tmc-cdm-opplugin", (Object[])new Object[0]);
                }
                if (!biztype.equals(biztypeStr)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u4e1a\u52a1\u5206\u7c7b\u3010%s\u3011\u4e0e\u6240\u9009\u62e9\u7684\u5f15\u5165\u6570\u636e\u4e1a\u52a1\u5206\u7c7b\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_5_1", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), bizType_zn));
                }
                JSONArray bankDraftArr = data.getJSONArray("bankdraftentry");
                for (int i = 0; i < bankDraftArr.size(); ++i) {
                    JSONObject bankdraftRow = bankDraftArr.getJSONObject(i);
                    boolean e_issplit = bankdraftRow.getBoolean("e_issplit");
                    String draftBillno = bankdraftRow.getString("e_draftbillno");
                    if (e_issplit) {
                        if (draftBillnoNotSplitSet.contains(draftBillno)) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_6", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), draftBillno));
                        }
                        long e_subbillStartFlag = bankdraftRow.getLong("e_subbillstartflag");
                        long e_subbillEndFlag = bankdraftRow.getLong("e_subbillendflag");
                        String e_subbillRange = bankdraftRow.getString("e_subbillrange");
                        BigDecimal e_amount = bankdraftRow.getBigDecimal("e_draftamount");
                        String strKey = draftBillno + ":" + e_subbillStartFlag + ":" + e_subbillEndFlag;
                        if (draftBillnoAndRangeStrSet.contains(strKey)) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_6", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), draftBillno));
                        }
                        draftBillnoAndRangeStrSet.add(strKey);
                        if (e_subbillStartFlag <= 0L || e_subbillEndFlag <= 0L || EmptyUtil.isEmpty((String)e_subbillRange) || "0".equals(e_subbillRange) || "0-0".equals(e_subbillRange)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u662f\u5426\u62c6\u5206\u4e3a\u662f\u65f6\uff0c\u5b50\u7968\u5305\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_7", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
                        }
                        if (e_subbillEndFlag < e_subbillStartFlag) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5b50\u7968\u5305\u5f00\u59cb\u6807\u8bc6\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6807\u8bc6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_8", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
                        }
                        String subRangeKey = e_subbillStartFlag + "-" + e_subbillEndFlag;
                        if (!subRangeKey.equals(e_subbillRange)) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b50\u7968\u5305\u5f00\u59cb\u6807\u8bc6\u4e0e\u7ed3\u675f\u6807\u8bc6\u7ec4\u6210\u7684\u5b50\u7968\u5305\u533a\u95f4\u4e0e\u8be5\u884c\u5b50\u7968\u5305\u533a\u95f4 %s \u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_9", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), e_subbillRange));
                        }
                        long subQuantity = e_subbillEndFlag - e_subbillStartFlag + 1L;
                        long e_amountLongAvlue = e_amount.multiply(new BigDecimal("100")).longValue();
                        if (e_amountLongAvlue == subQuantity) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u5b50\u7968\u533a\u95f4\u4e0e\u7968\u636e\u91d1\u989d\u4e0d\u76f8\u7b26\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_10", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
                    }
                    if (draftBillnoNotSplitSet.contains(draftBillno)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankDraftImportOp_6", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), draftBillno));
                    }
                    draftBillnoNotSplitSet.add(draftBillno);
                }
            }
            catch (Exception exc) {
                errorMessage = exc.getMessage();
            }
            finally {
                if (!StringUtils.isNotEmpty((CharSequence)errorMessage)) continue;
                logger.log(Integer.valueOf(rowData.getStartIndex()), errorMessage).fail();
                it.remove();
            }
        }
        int failed = logger.getFailed();
        if (failed > 0 && EmptyUtil.isNoEmpty(billdatas)) {
            billdatas.clear();
        }
        return billdatas;
    }

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        String userId = RequestContext.get().getUserId();
        String formatKey = String.format("importparam_%s", userId);
        HashMap paramsMap = (HashMap)cache.get(formatKey, HashMap.class);
        if (EmptyUtil.isNoEmpty((Object)paramsMap) && paramsMap.size() > 0) {
            this.paramMap = paramsMap;
        }
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            try {
                IFormView formView = (IFormView)view.get(ctx);
                formView.setVisible(Boolean.valueOf(false), new String[]{"radiofield1", "radiofield2"});
            }
            catch (IllegalAccessException e) {
                LOGGERTOOL.error(e.getMessage());
            }
        }
        catch (NoSuchFieldException e) {
            LOGGERTOOL.error(e.getMessage());
        }
        return super.setContext(rc, ctx, startArgs);
    }
}

