/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.opplugin.receivablebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.tmc.cdm.business.helper.RecBillAutoClaimNoticeHelper;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.PermissionHelper;
import kd.tmc.cdm.common.helper.RecClaimHelper;
import kd.tmc.cdm.common.param.ClaimNoticeMesParam;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RecNoticeClaimOp
extends AbstractOperationServicePlugIn {
    private static IAppCache cache = TmcAppCache.get((String)"cas", (String)"intelrec", (String)"claim");
    private static final Log logger = LogFactory.getLog(RecNoticeClaimOp.class);
    private static final String SYSTEMTYPE = "tmc-cdm-formplugin";
    private static final String BANK_BALANCE_SELECT_FIELDS = String.join((CharSequence)",", "claimnoticebillno", "billpool", "company", "billstatus", "source", "billno", "allocbillentryid", "electag", "draftbillstatus", "draftbilltranstatus", "rectype");
    private List<DynamicObject> unNoticeList = new ArrayList<DynamicObject>(8);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        List lst = args.getFieldKeys();
        lst.add("claimnoticebillno");
        lst.add("billpool");
        lst.add("company");
        lst.add("billstatus");
        lst.add("source");
        lst.add("billno");
        lst.add("allocbillentryid");
        lst.add("electag");
        lst.add("draftbilltranstatus");
        lst.add("draftbillstatus");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        try {
            super.beginOperationTransaction(args);
            DynamicObject[] dataEntities = args.getDataEntities();
            if (CasHelper.isEmpty((DynamicObject[])dataEntities)) {
                return;
            }
            this.noticeClaim(dataEntities);
        }
        catch (Exception e) {
            logger.error("beginOperationTransaction has error:", (Throwable)e);
            throw e;
        }
    }

    private void noticeMessage(Map<String, String> ruleNotice) {
        ArrayList ruleList = new ArrayList(ruleNotice.size());
        HashSet allUserId = new HashSet();
        for (Map.Entry<String, String> rule : ruleNotice.entrySet()) {
            int i;
            Map map = (Map)SerializationUtils.fromJsonString((String)rule.getValue(), Map.class);
            List userGroupids = (List)map.get("usergroupids");
            Iterator orgids = (List)map.get("orgids");
            List list = (List)map.get("roleids");
            List userids = (List)map.get("userids");
            HashSet userIds = new HashSet();
            if (!EmptyUtil.isEmpty((Collection)userGroupids)) {
                for (i = 0; i < userGroupids.size(); ++i) {
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"fbd_usergroup", (String)"entryentity.userfield", (QFilter[])new QFilter[]{new QFilter("id", "=", userGroupids.get(i)).and("enable", "=", (Object)"1")}, null);
                    userIds.addAll(query.stream().map(o -> o.getLong("entryentity.userfield")).collect(Collectors.toList()));
                }
            }
            if (!EmptyUtil.isEmpty(orgids)) {
                userIds.addAll(UserServiceHelper.getAllUsersOfOrg((int)0, orgids, (boolean)true, (boolean)false));
            }
            if (!EmptyUtil.isEmpty((Collection)list)) {
                for (i = 0; i < list.size(); ++i) {
                    userIds.addAll(PermissionServiceHelper.getUsersByRoleID((String)String.valueOf(list.get(i))));
                }
            }
            if (!EmptyUtil.isEmpty((Collection)userids)) {
                userIds.addAll(userids.stream().filter(EmptyUtil::isNoEmpty).map(u -> Long.valueOf(u.toString())).collect(Collectors.toList()));
            }
            ruleList.add(userIds);
            allUserId.addAll(userIds);
        }
        HashMap<Long, Integer> userCount = new HashMap<Long, Integer>(allUserId.size());
        int count = 0;
        for (Long userId : allUserId) {
            count = 0;
            for (Set set : ruleList) {
                if (!set.contains(userId)) continue;
                ++count;
            }
            userCount.put(userId, count);
        }
        HashMap noticeUsers = new HashMap(userCount.size());
        HashSet users = null;
        for (Map.Entry entry : userCount.entrySet()) {
            users = (HashSet)noticeUsers.get(entry.getValue());
            if (EmptyUtil.isEmpty((Collection)users)) {
                users = new HashSet();
            }
            users.add(entry.getKey());
            noticeUsers.put(entry.getValue(), users);
        }
        ClaimNoticeMesParam param = null;
        for (Map.Entry notice : noticeUsers.entrySet()) {
            param = new ClaimNoticeMesParam();
            param.setTag(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba4\u9886", (String)"RecNoticeClaimOp_1", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
            param.setTitle(String.format(ResManager.loadKDString((String)"%s\u7b14\u8ba4\u9886\u901a\u77e5\u9700\u8981\u8ba4\u9886\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002", (String)"RecNoticeClaimOp_0", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), notice.getKey()));
            param.setContent(ResManager.loadKDString((String)"\u8bf7\u8fdb\u5165\u201c\u8d44\u91d1\u7ed3\u7b97\u201d\u6216\u201c\u51fa\u7eb3\u201d\u5e94\u7528\uff0c\u201c\u6536\u6b3e\u8ba4\u9886->\u8ba4\u9886\u516c\u544a\u201d\u83dc\u5355\u8fdb\u884c\u5904\u7406", (String)"RecNoticeClaimOp_2", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
            param.setUserIds((Set)notice.getValue());
            param.setNoticeType("notice");
            RecClaimHelper.sendNoticeMessage((ClaimNoticeMesParam)param);
        }
    }

    private void noticeClaim(DynamicObject[] receivablebillsOri) {
        Set longSet;
        Map<Long, DynamicObject> billIdAndDataMap;
        logger.info("noticeClaim is start ok :" + receivablebillsOri.length);
        Set billIdSet = Arrays.stream(receivablebillsOri).map(x -> x.getLong("id")).collect(Collectors.toSet());
        QFilter id_qFilter = new QFilter("id", "in", billIdSet);
        QFilter status_qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter source_qFilter = new QFilter("source", "!=", (Object)"cas");
        QFilter success_qFilter = new QFilter("draftbilltranstatus", "=", (Object)"success");
        QFilter allocEntry_qFilter = new QFilter("allocbillentryid", "=", (Object)0L);
        QFilter claim_qFilter = new QFilter("claimnoticebillno", "is null", (Object)"").or(new QFilter("claimnoticebillno", "=", (Object)""));
        DynamicObject[] receivablebills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)BANK_BALANCE_SELECT_FIELDS, (QFilter[])new QFilter[]{id_qFilter, status_qFilter, source_qFilter, allocEntry_qFilter, success_qFilter});
        List<Object> billstatus = Arrays.stream(receivablebills).filter(x -> EmptyUtil.isEmpty((String)x.getString("claimnoticebillno"))).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(billstatus) && EmptyUtil.isNoEmpty(billIdAndDataMap = billstatus.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x))) && null != (longSet = LockDraftHelper.draftIsQuoteRecs(billIdAndDataMap.keySet()))) {
            billstatus = billstatus.stream().filter(x -> !longSet.contains(x.getLong("id"))).collect(Collectors.toList());
        }
        if (EmptyUtil.isEmpty(billstatus)) {
            return;
        }
        Set<Long> hasNoPermSet = this.checkOpPerm("noticeclaim", billstatus);
        List<Object> billsAfterPerm = new ArrayList(8);
        billsAfterPerm = Arrays.stream(receivablebills).filter(x -> !hasNoPermSet.contains(x.getDynamicObject("company").getLong("id"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(billsAfterPerm)) {
            logger.info("billsAfterPerm is null");
            return;
        }
        ArrayList<DynamicObject> unnotices = new ArrayList<DynamicObject>(10);
        logger.info("curr bill is start");
        String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
        Set companyIdSet = billsAfterPerm.stream().map(e -> e.getDynamicObject("company").getLong("id")).collect(Collectors.toSet());
        logger.info("companyIdSet size:" + SerializationUtils.toJsonString(companyIdSet));
        HashMap<Long, Object> companyIdAndSysMap = new HashMap<Long, Object>(6);
        for (Long companyId : companyIdSet) {
            String noticeClaimAllowStatus = (String)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)companyId, (String)"noticeclaimallowstatus");
            companyIdAndSysMap.put(companyId, noticeClaimAllowStatus);
        }
        Object[] ids = billsAfterPerm.stream().map(DataEntityBase::getPkValue).toArray();
        Map billIdAndExsitMap = DraftHelper.existsRecBillByBatch((Object[])ids);
        for (DynamicObject receivablebill : billsAfterPerm) {
            boolean electTag = receivablebill.getBoolean("electag");
            String draftTranStatus = receivablebill.getString("draftbilltranstatus");
            if (electTag && !"success".equals(draftTranStatus)) {
                logger.info(String.format("%s:" + ResManager.loadKDString((String)"\u63d0\u4ea4\u7535\u7968\u4e3a\u662f\u4e14\u7535\u7968\u5904\u7406\u72b6\u6001\u4e0d\u662f\u4ea4\u6613\u6210\u529f\u7684\u5355\u636e\u4e0d\u80fd\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_26", (String)SYSTEMTYPE, (Object[])new Object[0]), receivablebill.get("billno")));
                continue;
            }
            String draftbillstatus = receivablebill.getString("draftbillstatus");
            String noticeClaimAllowStatus = (String)companyIdAndSysMap.get(receivablebill.getLong("company.id"));
            if (EmptyUtil.isEmpty((String)noticeClaimAllowStatus)) {
                String showErrorMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u9650\u5b9a\u4e0d\u5141\u8bb8\u53d1\u8d77\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_33", (String)SYSTEMTYPE, (Object[])new Object[0]);
                logger.info(String.format("%s:" + showErrorMsg, receivablebill.get("billno")));
                continue;
            }
            if (!noticeClaimAllowStatus.contains(draftbillstatus) || !"success".equals(draftTranStatus)) {
                logger.info(String.format(ResManager.loadKDString((String)"\u7b26\u5408\u7cfb\u7edf\u53c2\u6570\u8bbe\u7f6e\u7684\u7968\u636e\u72b6\u6001\uff0c\u4e14\u4ea4\u6613\u72b6\u6001\u4e3a\u4ea4\u6613\u6210\u529f\u7684\u7968\u636e\u624d\u53ef\u4ee5\u901a\u77e5\u8ba4\u9886\u3002", (String)"RecNoticeClaimOp_3", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), receivablebill.get("billno")));
                continue;
            }
            if (billIdAndExsitMap.containsKey(receivablebill.getLong("id"))) {
                logger.info(String.format("%s:" + ResManager.loadKDString((String)"\u7968\u636e\u5df2\u751f\u6210\u6536\u6b3e\u5355\u5e76\u786e\u8ba4\u6536\u6b3e\uff0c\u4e0d\u53ef\u53d1\u8d77\u901a\u77e5\u8ba4\u9886\u3002", (String)"RecNoticeClaimOp_4", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), receivablebill.get("billno")));
                continue;
            }
            if (!EmptyUtil.isEmpty((String)((String)receivablebill.get("claimnoticebillno")))) continue;
            unnotices.add(receivablebill);
        }
        logger.info("curr bill is end");
        ArrayList<DynamicObject> failIds = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> successIds = new ArrayList<DynamicObject>(10);
        HashMap<String, String> ruleNotice = new HashMap<String, String>();
        logger.info("will unnotices is start");
        if (EmptyUtil.isNoEmpty(unnotices)) {
            logger.info("unnotices size is:" + unnotices.size());
            for (DynamicObject unnotice : unnotices) {
                long id = unnotice.getLong("id");
                DynamicObject ruleResult = RecBillAutoClaimNoticeHelper.getClaimInfoByNoticeRule((Long)id, (String)"noticeclaim");
                if (ruleResult == null) {
                    logger.info("ruleResult is null");
                    failIds.add(unnotice);
                    continue;
                }
                Object tag = ruleResult.get("e_savenotifi_TAG");
                Object noticeGroup = ruleResult.get("e_noticegroup");
                if (!ObjectUtils.isEmpty((Object)noticeGroup) && "D".equals(noticeGroup)) {
                    Map<String, Long> data = new HashMap<String, Long>(16);
                    data.put("billid", id);
                    data.put("ruleentryid", ruleResult.getLong("id"));
                    data = RecBillAutoClaimNoticeHelper.getNoticeObjectExt(data);
                    tag = SerializationUtils.toJsonString(data);
                }
                logger.info("RecNoticeClaimOp noticeClaim e_handlescheme is {},tag = {}", ruleResult.get("e_handlescheme"), tag);
                if ("noticeclaim".equals(ruleResult.get("e_handlescheme")) && !EmptyUtil.isEmpty((Object)tag)) {
                    successIds.add(unnotice);
                    String idStr = Long.toString(id);
                    cache.put(idStr, (Object)tag.toString());
                    ruleNotice.put(idStr, tag.toString());
                } else {
                    failIds.add(unnotice);
                }
                if (!"noticeclaim".equals(ruleResult.get("e_handlescheme")) || EmptyUtil.isEmpty((Object)ruleResult.get("e_rulesname"))) continue;
                cache.put(id + "rulesname", ruleResult.get("e_rulesname"));
            }
            logger.info("curr unnotices is end");
        }
        if (!successIds.isEmpty()) {
            Object[] successPkIds = successIds.stream().map(e -> e.get("id")).toArray();
            logger.info("successPkIds is:" + SerializationUtils.toJsonString((Object)successPkIds));
            OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"pushandsave", (String)"cdm_receivablebill", (Object[])successPkIds, (OperateOption)OperateOption.create());
            logger.info("pushandsave is end");
            List pushAndSaveIds = result.getSuccessPkIds();
            if (pushAndSaveIds.size() > 0) {
                this.unNoticeList = successIds.stream().filter(o -> pushAndSaveIds.contains(o.getPkValue())).collect(Collectors.toList());
            }
            this.noticeMessage(ruleNotice);
        }
        if (!failIds.isEmpty()) {
            logger.info("failIdsList is:" + SerializationUtils.toJsonString(failIds));
        }
        logger.info("noticeClaim is end :");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (this.unNoticeList.size() > 0) {
            for (DynamicObject dynamicObject : this.unNoticeList) {
                dynamicObject.set("rectype", (Object)"6");
            }
            SaveServiceHelper.save((DynamicObject[])this.unNoticeList.toArray(new DynamicObject[0]));
        }
    }

    private Set<Long> checkOpPerm(String operKey, List<DynamicObject> receivablebills) {
        Map operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)"cdm_receivablebill", (String)operKey);
        Object permission = operateMetaMap.get("permission");
        boolean hasPerm = true;
        HashSet<Long> orgIds = new HashSet<Long>(receivablebills.size());
        for (DynamicObject receivablebill : receivablebills) {
            orgIds.add(receivablebill.getDynamicObject("company").getLong("id"));
        }
        HashSet<Long> hasOpPermOrgIdSet = new HashSet<Long>(6);
        for (Long org : orgIds) {
            hasPerm = PermissionHelper.checkCurrentUserPermission((long)org, (String)"cdm_receivablebill", (String)(permission + ""));
            if (hasPerm) continue;
            hasOpPermOrgIdSet.add(org);
        }
        logger.info("No OpPerm is start :" + SerializationUtils.toJsonString(hasOpPermOrgIdSet));
        return hasOpPermOrgIdSet;
    }
}

