/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.opplugin.tradebill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SettlementTypeConvertPlugin
extends AbstractConvertPlugIn {
    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("id");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject tradeBill = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)"cdm_drafttradebill");
            if (EmptyUtil.isEmpty((DynamicObject)tradeBill)) continue;
            Object tradeType = tradeBill.get("tradetype");
            if (DraftTradeTypeEnum.DISCOUNT.getValue().equals(tradeType) || DraftTradeTypeEnum.COLLECT.getValue().equals(tradeType)) {
                DynamicObject recBill = billDataEntity.getDataEntity();
                String name = recBill.getDataEntityType().getName();
                DynamicObject settletypeDy = recBill.getDynamicObject("settletype");
                if (EmptyUtil.isNoEmpty((DynamicObject)settletypeDy) && "cas_recbill".equalsIgnoreCase(name)) {
                    return;
                }
                DynamicObject bankaccountDO = tradeBill.getDynamicObject("bankaccount");
                if (!EmptyUtil.isEmpty((DynamicObject)bankaccountDO)) {
                    DynamicObject settlementTypeDO = this.getSettlementTypeId(bankaccountDO, recBill);
                    recBill.set("settletype", (Object)settlementTypeDO);
                    continue;
                }
                recBill.set("settletype", null);
                continue;
            }
            if (!DraftTradeTypeEnum.PAYOFF.getValue().equals(tradeType)) continue;
            DynamicObject payBill = billDataEntity.getDataEntity();
            Object entryId = ((DynamicProperty)e.getFldProperties().get("entrys.id")).getValue(srcRows.get(0));
            tradeBill.getDynamicObjectCollection("entrys").stream().filter(o -> o.get("id").equals(entryId)).findFirst().ifPresent(o -> {
                DynamicObject draftBill = TmcDataServiceHelper.loadSingle((Object)o.getDynamicObject("draftbill").getPkValue(), (String)"cdm_payablebill");
                DynamicObject bankaccountDO = draftBill.getDynamicObject("draweraccount");
                if (!EmptyUtil.isEmpty((DynamicObject)bankaccountDO)) {
                    DynamicObject settlementTypeDO = this.getSettlementTypeId(bankaccountDO, payBill);
                    DynamicObject settletype = payBill.getDynamicObject("settletype");
                    if (EmptyUtil.isEmpty((DynamicObject)settletype)) {
                        payBill.set("settletype", (Object)settlementTypeDO);
                    }
                } else {
                    payBill.set("settletype", null);
                }
            });
        }
    }

    private DynamicObject getSettlementTypeId(DynamicObject bankaccountDO, DynamicObject recBill) {
        DynamicObjectCollection settlementtypes = bankaccountDO.getDynamicObjectCollection("settlementtype");
        DynamicObject settlementTypeDO = null;
        settlementTypeDO = settlementtypes.size() > 0 ? this.getSettlementTypeId(settlementtypes) : this.getSettlementTypeId(null);
        return settlementTypeDO;
    }

    private DynamicObject getSettlementTypeId(DynamicObjectCollection settlementtypes) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)settlementtypes)) {
            ArrayList<Long> setlIds = new ArrayList<Long>();
            for (DynamicObject settlementtype : settlementtypes) {
                setlIds.add(((DynamicObject)settlementtype.get("fbasedataid")).getLong("id"));
            }
            qFilters.add(new QFilter("id", "in", (Object)setlIds.toArray()));
        }
        qFilters.add(new QFilter("settlementtype", "=", (Object)"3"));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] bd_settlementtypes = TmcDataServiceHelper.load((String)"bd_settlementtype", (String)"id,settlementtype,isdefault", (QFilter[])qFilters.toArray(new QFilter[0]));
        DynamicObject settlementTypeDO = null;
        if (bd_settlementtypes.length > 0) {
            for (DynamicObject settlementtype : bd_settlementtypes) {
                if (!settlementtype.getBoolean("isdefault")) continue;
                settlementTypeDO = settlementtype;
            }
            if (EmptyUtil.isEmpty(settlementTypeDO)) {
                settlementTypeDO = bd_settlementtypes[0];
            }
        }
        return settlementTypeDO;
    }
}

