/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.opplugin.tradebill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.BillStatusEnum;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.helper.BaseDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillImportOp
extends BatchImportPlugin {
    private static Log LOGGERTOOL = LogFactory.getLog(TradeBillImportOp.class);
    private static final String NEW = "new";
    private static final String OVERRIDE = "override";
    private static final String OVERRIDE_NEW = "overridenew";
    private static final int MAX_IMPORT_SIZE = 10000000;
    private static final String IMPORT_TYPE = "importtype";
    private static final String KEY_FIELDS = "KeyFields";
    private static final Set<String> checkTradeTypes = Stream.of(DraftTradeTypeEnum.ENDORSE.getValue(), DraftTradeTypeEnum.PLEDGE.getValue()).collect(Collectors.toSet());

    protected int getBatchImportSize() {
        return 10000000;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        LOGGERTOOL.info("super.beforeSave >>> start...");
        super.beforeSave(billdatas, logger);
        LOGGERTOOL.info("super.beforeSave >>> end...");
        Map options = this.ctx.getOption();
        this.dealData(billdatas, logger, options);
        LOGGERTOOL.info("beforeSave >>> end...");
    }

    private void dealData(List<ImportBillData> billdatas, ImportLogger logger, Map<String, Object> options) {
        Object importType = options.get(IMPORT_TYPE);
        LOGGERTOOL.info("dealData >>> importType is:" + importType + ",billdatas.size is:" + billdatas.size());
        if (EmptyUtil.isNoEmpty(billdatas) && NEW.equals(String.valueOf(importType))) {
            this.handleAddData(billdatas, logger);
            LOGGERTOOL.info("handleAddData >>> end...");
        }
    }

    private List<ImportBillData> handleAddData(List<ImportBillData> billdatas, ImportLogger logger) {
        LOGGERTOOL.info("handleAddData >>> checkParams start...");
        return this.checkParams(billdatas, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportBillData> checkParams(List<ImportBillData> billdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            String errorMessage = null;
            ImportBillData rowData = it.next();
            JSONObject data = rowData.getData();
            try {
                this.checkDraftBillStatus(data);
                this.checkDraftStatus(data);
                this.checkOrgAuthCustomerOrSupply(data);
            }
            catch (Exception exc) {
                errorMessage = exc.getMessage();
            }
            finally {
                if (!StringUtils.isNotEmpty((CharSequence)errorMessage)) continue;
                logger.log(Integer.valueOf(rowData.getStartIndex()), errorMessage).fail();
                it.remove();
            }
        }
        return billdatas;
    }

    private void checkOrgAuthCustomerOrSupply(JSONObject data) {
        String tradeType = data.getString("tradetype");
        String companyNumber = data.getJSONObject("company").getString("number");
        DynamicObjectCollection queryComapnyData = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)companyNumber)});
        long companyId = ((DynamicObject)queryComapnyData.get(0)).getLong("id");
        Long baseDataId = 0L;
        JSONObject baseData = null;
        String dealType = "";
        if (checkTradeTypes.contains(tradeType)) {
            switch (tradeType) {
                case "endorse": {
                    dealType = data.getString("payeetypetext");
                    if (!dealType.equals("bd_customer") && !dealType.equals("bd_supplier") || (baseData = data.getJSONObject("beendorsor")) == null) break;
                    baseDataId = this.getDataId(baseData, dealType);
                    BaseDataHelper.checkCustomerOrSupplyAuth((String)"Endorse", (String)dealType, (Long)baseDataId, (Long)companyId);
                    break;
                }
                case "pledge": {
                    dealType = data.getString("pledgeetype");
                    if (!dealType.equals("bd_customer") && !dealType.equals("bd_supplier") || (baseData = data.getJSONObject("pledgeebase")) == null) break;
                    baseDataId = this.getDataId(baseData, dealType);
                    BaseDataHelper.checkCustomerOrSupplyAuth((String)"Pledge", (String)dealType, (Long)baseDataId, (Long)companyId);
                    break;
                }
            }
        }
    }

    private Long getDataId(JSONObject baseData, String dealType) {
        String number = baseData.getString("number");
        DynamicObjectCollection queryData = QueryServiceHelper.query((String)dealType, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        return ((DynamicObject)queryData.get(0)).getLong("id");
    }

    private void checkDraftBillStatus(JSONObject data) {
        DynamicObject[] draftBills;
        String rpType = EmptyUtil.isEmpty((Object)data.get((Object)"rptype")) ? "receivebill" : (String)data.get((Object)"rptype");
        JSONArray entrys = data.getJSONArray("entrys");
        HashSet<String> draftBillNoSet = new HashSet<String>(8);
        for (int i = 0; i < entrys.size(); ++i) {
            JSONObject entry = entrys.getJSONObject(i);
            String draftBillNo = ((JSONObject)entry.get((Object)"draftbill")).getString("draftbillno");
            draftBillNoSet.add(draftBillNo);
        }
        QFilter qFilter = new QFilter("draftbillno", "in", draftBillNoSet);
        qFilter.and("rptype", "=", (Object)rpType);
        for (DynamicObject draftBill : draftBills = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,draftbillno,billstatus", (QFilter[])qFilter.toArray())) {
            String billStatus = draftBill.getString("billstatus");
            if (EmptyUtil.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u3010%s\u3011\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838", (String)"TradeBillImportOp_0", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBill.getString("draftbillno")));
        }
    }

    private void checkDraftStatus(JSONObject data) {
        String tradeType = data.getString("tradetype");
        String rpType = EmptyUtil.isEmpty((Object)data.get((Object)"rptype")) ? "receivebill" : (String)data.get((Object)"rptype");
        JSONArray entrys = data.getJSONArray("entrys");
        HashSet<String> draftBillNoSet = new HashSet<String>(8);
        HashSet<String> draftBillStatusSet = new HashSet<String>(8);
        for (int i = 0; i < entrys.size(); ++i) {
            JSONObject entry = entrys.getJSONObject(i);
            String draftBillNo = ((JSONObject)entry.get((Object)"draftbill")).getString("draftbillno");
            draftBillNoSet.add(draftBillNo);
            String draftBillStatus = EmptyUtil.isEmpty((String)entry.getString("draftbillstatusfield")) ? "registered" : entry.getString("draftbillstatusfield");
            draftBillStatusSet.add(draftBillStatus);
        }
        QFilter qFilter = new QFilter("draftbillno", "in", draftBillNoSet);
        qFilter.and("rptype", "=", (Object)rpType);
        qFilter.and("draftbillstatus", "in", draftBillStatusSet);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObject[] draftBills = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,draftbillno,company,rptype,draftbillstatus,billstatus", (QFilter[])qFilter.toArray());
        for (int i = 0; i < entrys.size(); ++i) {
            String draftBillStatusDB;
            JSONObject entry = entrys.getJSONObject(i);
            String draftBillNo = ((JSONObject)entry.get((Object)"draftbill")).getString("draftbillno");
            String draftBillStatus = EmptyUtil.isEmpty((String)entry.getString("draftbillstatusfield")) ? "registered" : entry.getString("draftbillstatusfield");
            boolean isMatch = false;
            for (DynamicObject draftBill : draftBills) {
                String draftBillNoDB = draftBill.getString("draftbillno");
                draftBillStatusDB = draftBill.getString("draftbillstatus");
                boolean bl = isMatch = EmptyUtil.equals((CharSequence)draftBillNo, (CharSequence)draftBillNoDB) && EmptyUtil.equals((CharSequence)draftBillStatus, (CharSequence)draftBillStatusDB);
                if (isMatch) break;
            }
            if (!isMatch) {
                String draftBillStatusStr = this.getDraftBillStatusStr(draftBillStatus);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u7968\u636e\u3010%1$s\u3011\u7968\u636e\u72b6\u6001\u4e3a\u3010%2$s\u3011\u7684\u7968\u636e\u53f7\u7801", (String)"TradeBillImportOp_1", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillNo, draftBillStatusStr));
            }
            boolean isMatchNotRegistered = false;
            if (!EmptyUtil.equals((CharSequence)tradeType, (CharSequence)"discount")) continue;
            for (DynamicObject draftBill : draftBills) {
                draftBillStatusDB = draftBill.getString("draftbillstatus");
                boolean bl = isMatchNotRegistered = !EmptyUtil.equals((CharSequence)"registered", (CharSequence)draftBillStatusDB);
                if (isMatchNotRegistered) break;
            }
            if (!isMatchNotRegistered) continue;
            String draftBillStatusStr = this.getDraftBillStatusStr(draftBillStatus);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u4e1a\u52a1\u5904\u7406\u4e3a\u7968\u636e\u8d34\u73b0\u5355\u636e\uff0c\u7968\u636e\u3010%1$s\u3011\u7968\u636e\u72b6\u6001\u4e3a\u3010%2$s\u3011\uff0c\u5fc5\u987b\u4e3a\u5df2\u767b\u8bb0\u72b6\u6001", (String)"TradeBillImportOp_2", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillNo, draftBillStatusStr));
        }
    }

    private String getDraftBillStatusStr(String draftBillStatus) {
        String draftBillStatusStr = "";
        if (EmptyUtil.isEmpty((String)draftBillStatus)) {
            return draftBillStatusStr;
        }
        switch (draftBillStatus) {
            case "registered": {
                draftBillStatusStr = ResManager.loadKDString((String)"\u5df2\u767b\u8bb0", (String)"DraftBillStatusEnum_0", (String)"tmc-cdm-common", (Object[])new Object[0]);
                break;
            }
            case "pledged": {
                draftBillStatusStr = ResManager.loadKDString((String)"\u5df2\u8d28\u62bc", (String)"DraftBillStatusEnum_1", (String)"tmc-cdm-common", (Object[])new Object[0]);
                break;
            }
            case "collocated": {
                draftBillStatusStr = ResManager.loadKDString((String)"\u5df2\u6258\u7ba1", (String)"DraftBillStatusEnum_2", (String)"tmc-cdm-common", (Object[])new Object[0]);
                break;
            }
            case "endorsed": {
                draftBillStatusStr = ResManager.loadKDString((String)"\u5df2\u80cc\u4e66", (String)"DraftBillStatusEnum_3", (String)"tmc-cdm-common", (Object[])new Object[0]);
                break;
            }
            case "discounted": {
                draftBillStatusStr = ResManager.loadKDString((String)"\u5df2\u8d34\u73b0", (String)"DraftBillStatusEnum_4", (String)"tmc-cdm-common", (Object[])new Object[0]);
                break;
            }
            case "collected": {
                draftBillStatusStr = ResManager.loadKDString((String)"\u5df2\u6258\u6536", (String)"DraftBillStatusEnum_5", (String)"tmc-cdm-common", (Object[])new Object[0]);
                break;
            }
            case "splited": {
                draftBillStatusStr = ResManager.loadKDString((String)"\u5df2\u62c6\u5206", (String)"DraftBillStatusEnum_8", (String)"tmc-cdm-common", (Object[])new Object[0]);
                break;
            }
            default: {
                draftBillStatusStr = "error status";
            }
        }
        return draftBillStatusStr;
    }
}

