/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.SlBankRoleEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractHelper {
    public static void setCreditorInfo(DynamicObject contract) {
        if (contract == null || !LoanTypeEnum.isBanksLoan((String)contract.getString("loantype"))) {
            return;
        }
        DynamicObjectCollection entrys = contract.getDynamicObjectCollection("banksyndicate_entry");
        DynamicObject mbEntry = entrys.stream().filter(o -> SlBankRoleEnum.isMb((String)o.getString("e_bankrole"))).findFirst().orElse(null);
        if (EmptyUtil.isEmpty((DynamicObject)mbEntry)) {
            return;
        }
        DynamicObject bank = mbEntry.getDynamicObject("e_bank");
        if (EmptyUtil.isEmpty((DynamicObject)bank)) {
            return;
        }
        bank = TmcDataServiceHelper.loadSingleFromCache((String)"bd_finorginfo", (QFilter[])new QFilter[]{new QFilter("id", "=", bank.get("id"))});
        String finOrgType = bank.getDynamicObject("finorgtype").getString("number");
        String creditorType = FinOrgTypeEnum.BANK.getNumber().equals(finOrgType) ? CreditorTypeEnum.BANK.getValue() : CreditorTypeEnum.FINORG.getValue();
        contract.set("creditor", (Object)bank.getLong("id"));
        contract.set("textcreditor", (Object)bank.getString("name"));
        contract.set("creditortype", (Object)creditorType);
    }
}

