/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.apply;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanApplyUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("businessstatus");
        selector.add("creditlimit");
        return selector;
    }

    public void process(DynamicObject[] dataEntity) throws KDException {
        ArrayList<Object> schemeList = new ArrayList<Object>();
        for (DynamicObject data : dataEntity) {
            boolean isNeedScheme;
            data.set("businessstatus", (Object)ApplyBusinessStatusEnum.APPLY.getValue());
            if (EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("creditlimit"))) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)data, null, (boolean)true);
            }
            if (!(isNeedScheme = data.getBoolean("isneedscheme"))) continue;
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
            List schemeIds = entrys.stream().map(v -> v.getDynamicObject("e_scheme").getPkValue()).collect(Collectors.toList());
            for (DynamicObject entry : entrys) {
                Object schmeId = entry.getDynamicObject("e_scheme").getPkValue();
                schemeList.add(schmeId);
            }
            schemeList.addAll(schemeIds);
            data.set("creditlimit", null);
        }
        if (!CollectionUtils.isEmpty(schemeList)) {
            DynamicObject[] schemes;
            for (DynamicObject scheme : schemes = TmcDataServiceHelper.load((Object[])schemeList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_financingscheme"))) {
                scheme.set("status", (Object)BillStatusEnum.SAVE.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])schemes);
        }
    }
}

