/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.attachment;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.IAttachmentOperateService;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AttachmentUploadService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(AttachmentUploadService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        String attachmentPanelStr = (String)this.getOperationVariable().get("AttachmentPanel");
        if (EmptyUtil.isNoEmpty((String)attachmentPanelStr)) {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("AttachmentPanel", attachmentPanelStr);
                    IAttachmentOperateService attService = (IAttachmentOperateService)ServiceFactory.getService(IAttachmentOperateService.class);
                    attService.persistAttachments(option, dataEntities);
                    this.getOperationVariable().remove("AttachmentPanel");
                }
                catch (Exception e) {
                    logger.error(String.format("\u9644\u4ef6\u4e0a\u4f20\u5f02\u5e38\uff0c\u3010%s\u3011", e.getMessage()));
                    tx.markRollback();
                }
            }
        }
    }
}

