/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.bizdeal;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cfm.business.opservice.loancontractbill.LoanContractConfirmSyncDrawService;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.SyncDrawHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;

public class IfmBizDealAuditSyncDrawService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(LoanContractConfirmSyncDrawService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("loantype");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        this.handleSyncDraw(dataEntities);
    }

    private void handleSyncDraw(DynamicObject[] dataEntities) {
        try {
            for (DynamicObject ifmbizdeal : dataEntities) {
                DynamicObject loanContract = TmcBotpHelper.getTargetBill((String)ifmbizdeal.getDataEntityType().getName(), (Object)ifmbizdeal.getPkValue(), (String)"ifm_loancontractbill");
                if (loanContract == null) continue;
                String loanType = ifmbizdeal.getString("loantype");
                if (!loanContract.getBoolean("issyncdraw") || !ConfirmStatusEnum.YETCONFIRM.getValue().equals(loanContract.get("confirmstatus")) || !"ifm_loancontractbill".equals(loanContract.getDataEntityType().getName()) || !LoanTypeEnum.BANKLOAN.getValue().equals(loanType)) continue;
                SyncDrawHelper.handleSyncDraw((DynamicObject)loanContract);
            }
        }
        catch (Exception e) {
            logger.error("\u4e1a\u52a1\u5904\u7406\u5ba1\u6838\u65f6\u540c\u6b65\u63d0\u6b3e\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
    }

    public void afterProcessRollback(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject ifmbizdeal : dataEntities) {
            DynamicObject loanContract = TmcBotpHelper.getTargetBill((String)ifmbizdeal.getDataEntityType().getName(), (Object)ifmbizdeal.getPkValue(), (String)"ifm_loancontractbill");
            if (loanContract == null) continue;
            String loanType = ifmbizdeal.getString("loantype");
            if (!loanContract.getBoolean("issyncdraw") || !ConfirmStatusEnum.YETCONFIRM.getValue().equals(loanContract.get("confirmstatus")) || !"ifm_loancontractbill".equals(loanContract.getDataEntityType().getName()) || !LoanTypeEnum.BANKLOAN.getValue().equals(loanType)) continue;
            SyncDrawHelper.unsubmitAndDeleteLoanBill((DynamicObject)loanContract);
            SyncDrawHelper.unauditAndDeleteLoanContract((DynamicObject)loanContract);
            SyncDrawHelper.unauditAndSubmitBizdeal((DynamicObject)ifmbizdeal);
        }
    }
}

