/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.contractbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.SyncDrawHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ContractBondAuditSyncDrawService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ContractBondAuditSyncDrawService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("confirmstatus");
        sic.add("contractstatus");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("loantype");
        sic.add("issyncdraw");
        sic.add("drawway");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        this.handleSyncDraw(dataEntities);
    }

    private void handleSyncDraw(DynamicObject[] dataEntities) {
        try {
            for (DynamicObject bondPlan : dataEntities) {
                String loanType = bondPlan.getString("loantype");
                if (!bondPlan.getBoolean("issyncdraw") || !LoanTypeEnum.isBond((String)loanType)) continue;
                SyncDrawHelper.handleSyncDrawForBond((DynamicObject)bondPlan);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u53d1\u884c\u503a\u5238\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
    }

    public void afterProcessRollback(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] dynamicObjectArray = dataEntities;
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n; ++i) {
            String bondBillSelectedField = "id";
            DynamicObject bondPlan = dynamicObjectArray[i];
            long bondPlanId = bondPlan.getLong("id");
            QFilter bondPlanFilter = new QFilter("id", "=", (Object)bondPlanId).and(new QFilter("loantype", "=", (Object)LoanTypeEnum.BOND.getValue())).and(new QFilter("issyncdraw", "=", (Object)true));
            DynamicObjectCollection bondPlanCollection = QueryServiceHelper.query((String)"cfm_loancontract_bo", (String)bondBillSelectedField, (QFilter[])bondPlanFilter.toArray());
            if (EmptyUtil.isEmpty((DynamicObjectCollection)bondPlanCollection)) continue;
            SyncDrawHelper.unsubmitAndDeleteLoanBill((DynamicObject)bondPlan);
            SyncDrawHelper.unauditAndSubmitLoanContract((DynamicObject)bondPlan);
        }
    }
}

