/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.drawapply;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.operate.LoanBillOperate;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DrawApplyBillPush2LoanBillService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(DrawApplyBillPush2LoanBillService.class);
    private final String[] GUARANTEE_USE_PROPS = new String[]{"gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gcontract.guaranteevarieties", "gratio", "gexchrate", "gsrcbillid", "gsrcbilltype", "gdebtbalance", "gsrcbillbizamount", "gcreditortype", "gcreditor", "gcreditortext"};

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loancontractbill");
        sic.add("notdrawamount");
        sic.add("predrawdate");
        sic.add("predrawamount");
        sic.add("currency");
        sic.add("description");
        sic.add("businessstatus");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject drawApplyBill : dataEntities) {
            this.doPush2LoanBill(drawApplyBill);
        }
    }

    private void doPush2LoanBill(DynamicObject drawApplyBill) {
        drawApplyBill.set("businessstatus", (Object)ApplyBusinessStatusEnum.HANDING.getValue());
        Date preDrawDate = drawApplyBill.getDate("predrawdate");
        BigDecimal preDrawAmount = drawApplyBill.getBigDecimal("predrawamount");
        BigDecimal notDrawAmount = drawApplyBill.getBigDecimal("notdrawamount");
        DynamicObject contractBill = drawApplyBill.getDynamicObject("loancontractbill");
        contractBill = TmcDataServiceHelper.loadSingle((Object)contractBill.getLong("id"), (String)"cfm_loancontractbill");
        DynamicObject[] loanBills = TmcBotpHelper.push((DynamicObject)contractBill, (String)"cfm_loanbill");
        DynamicObject loanBill = loanBills[0];
        loanBill.set("drawapplybill", (Object)drawApplyBill);
        loanBill.set("bizdate", (Object)preDrawDate);
        loanBill.set("drawamount", (Object)preDrawAmount);
        loanBill.set("convertdrawamt", (Object)preDrawAmount);
        loanBill.set("convertrate", (Object)BigDecimal.ONE);
        loanBill.set("notdrawamount", (Object)notDrawAmount);
        loanBill.set("rateadjustdate", (Object)preDrawDate);
        this.setShareAmount(loanBill);
        DrawApplyBillPush2LoanBillService.createCreditUses(loanBill);
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{drawApplyBill});
        this.dealApplyGmSubEntry(contractBill.getLong("id"), loanBill);
        OperateOption option = OperateOption.create();
        option.setVariableValue("byDrawApply", "true");
        try {
            LoanBillOperate.save((DynamicObject[])loanBills, (OperateOption)option);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u63d0\u6b3e\u5355\u4e0b\u63a8\u5931\u8d25:%s", (String)"DrawApplyBillPush2LoanBillService_1", (String)"tmc-cfm-business", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private void dealApplyGmSubEntry(Long contractId, DynamicObject loanBill) {
        DynamicObjectCollection gcs = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", this.GUARANTEE_USE_PROPS), (QFilter[])new QFilter[]{new QFilter("gsrcbillid", "=", (Object)contractId)}, (String)"id");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)gcs)) {
            return;
        }
        TreeMap<String, ArrayList<DynamicObject>> sumGcMap = new TreeMap<String, ArrayList<DynamicObject>>();
        for (DynamicObject gc : gcs) {
            if (EmptyUtil.isEmpty((Long)gc.getLong("gcontract"))) continue;
            String creditorType = gc.getString("gcreditortype");
            Long creditor = gc.getLong("gcreditor");
            ArrayList<DynamicObject> gcTemp = (ArrayList<DynamicObject>)sumGcMap.get(creditorType + creditor);
            if (gcTemp == null) {
                gcTemp = new ArrayList<DynamicObject>(gcs.size());
            }
            gcTemp.add(gc);
            sumGcMap.put(creditorType + creditor, gcTemp);
        }
        Map bizAmountMap = GuaranteeUseHelper.getBankSyncMap((String)"cfm_loanbill", (DynamicObject)loanBill);
        BigDecimal bizAmount = loanBill.getBigDecimal("drawamount");
        DynamicObject debtCurrency = loanBill.getDynamicObject("currency");
        ArrayList<GuaranteeUseBean> gUseList = new ArrayList<GuaranteeUseBean>(gcs.size());
        for (Map.Entry entry : sumGcMap.entrySet()) {
            List gcsList = (List)entry.getValue();
            if (EmptyUtil.isEmpty((Collection)gcsList)) continue;
            bizAmount = bizAmountMap.containsKey(entry.getKey()) ? (BigDecimal)bizAmountMap.get(entry.getKey()) : bizAmount;
            BigDecimal sumRatio = gcsList.stream().map(g -> g.getBigDecimal("gratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumAmount = BigDecimal.ZERO;
            for (int i = 0; i < gcsList.size(); ++i) {
                BigDecimal gAmount;
                DynamicObject guaranteeUseBill = (DynamicObject)gcsList.get(i);
                GuaranteeUseBean gUse = new GuaranteeUseBean();
                gUse.setSrcBillType(loanBill.getDataEntityType().getName());
                gUse.setSrcBillId(Long.valueOf(loanBill.getLong("id")));
                gUse.setSrcBillNo(loanBill.getString("billno"));
                gUse.setgContractId(Long.valueOf(guaranteeUseBill.getLong("gcontract")));
                gUse.setBizAmount(bizAmount);
                gUse.setComment(guaranteeUseBill.getString("gcomment"));
                if (Constants.ONE_HUNDRED.compareTo(sumRatio) == 0 && i == gcsList.size() - 1) {
                    gAmount = bizAmount.subtract(sumAmount);
                } else {
                    gAmount = bizAmount.multiply(guaranteeUseBill.getBigDecimal("gratio")).divide(Constants.ONE_HUNDRED, EmptyUtil.isEmpty((DynamicObject)debtCurrency) ? 6 : debtCurrency.getInt("amtprecision"), RoundingMode.HALF_UP);
                    sumAmount = sumAmount.add(gAmount);
                }
                gUse.setgAmount(gAmount);
                gUse.setgRatio(guaranteeUseBill.getBigDecimal("gratio"));
                gUse.setExchrate(guaranteeUseBill.getBigDecimal("gexchrate"));
                gUse.setgCreditorType(guaranteeUseBill.getString("gcreditortype"));
                gUse.setgCreditor(Long.valueOf(guaranteeUseBill.getLong("gcreditor")));
                gUse.setgCreditorText(guaranteeUseBill.getString("gcreditortext"));
                String dataSource = loanBill.getString("datasource");
                String creditorType = loanBill.getString("creditortype");
                String mainOrgField = CfmBillCommonHelper.getFundOrgFieldName((String)dataSource, (boolean)true, (String)creditorType);
                gUse.setDebtOrgId(Optional.ofNullable(loanBill.getDynamicObject(mainOrgField)).map(r -> r.getLong("id")).orElseGet(() -> 0L));
                gUse.setDebtOrgText(Optional.ofNullable(loanBill.getDynamicObject(mainOrgField)).map(r -> r.getString("name")).orElseGet(() -> ""));
                gUse.setDebtCurrencyId(Optional.ofNullable(debtCurrency).map(r -> r.getLong("id")).orElseGet(() -> 0L));
                gUse.setCparty(loanBill.getString("textcreditor"));
                gUse.setDebtStartDate(loanBill.getDate("bizdate"));
                gUse.setDebtEndDate(loanBill.getDate("expiredate"));
                gUseList.add(gUse);
            }
        }
        if (EmptyUtil.isNoEmpty(gUseList)) {
            GuaranteeUseHelper.saveGuaranteeUse(gUseList);
        }
    }

    private static void createCreditUses(DynamicObject bill) {
        if (EmptyUtil.isEmpty((DynamicObject)bill.getDynamicObject("creditlimit"))) {
            return;
        }
        CreditLimitUseBean useBean = new CreditLimitUseBean();
        useBean.setPkId(Long.valueOf(bill.getLong("id")));
        useBean.setEntityName(bill.getDataEntityType().getName());
        useBean.setOrgId(Long.valueOf(bill.getDynamicObject("org").getLong("id")));
        String loanType = bill.getString("loantype");
        useBean.setCreditFinType(CreditFinTypeEnum.FINORG.getValue());
        if (LoanTypeEnum.ENTRUSTLOAN.getValue().equals(loanType) || LoanTypeEnum.LINKLEND.getValue().equals(loanType)) {
            useBean.setCreditFinType(CreditFinTypeEnum.ORG.getValue());
        }
        useBean.setFinOrgId(Long.valueOf(bill.getLong("creditor")));
        useBean.setCurrencyId(Long.valueOf(bill.getDynamicObject("currency").getLong("id")));
        DynamicObject finproduct = bill.getDynamicObject("finproduct");
        DynamicObject creditType = finproduct != null ? finproduct.getDynamicObject("credittype") : null;
        useBean.setCreditTypeId(Long.valueOf(creditType != null ? creditType.getLong("id") : 0L));
        useBean.setCreditVariety(finproduct != null ? finproduct.getString("name") : "");
        useBean.setCreditRatio(Constants.ONE_HUNDRED);
        useBean.setCreditLimitNo(bill.getDynamicObject("creditlimit").getString("number"));
        useBean.setBizAmt(bill.getBigDecimal("drawamount"));
        useBean.setMaxAmt(bill.getBigDecimal("drawamount"));
        useBean.setStartDate(bill.getDate("bizdate"));
        useBean.setEndDate(bill.getDate("expiredate"));
        CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
    }

    private void setShareAmount(DynamicObject loanBill) {
        if (!BizTypeEnum.isSL((String)loanBill.getString("loantype"))) {
            return;
        }
        DynamicObjectCollection loanBillEntrys = loanBill.getDynamicObjectCollection("banksyndicate_entry");
        BigDecimal notDrawAmount = loanBill.getBigDecimal("notdrawamount");
        if (EmptyUtil.isEmpty((BigDecimal)notDrawAmount)) {
            return;
        }
        Map slBankNotdrawamount = LoanBillHelper.getSlBankNotdrawamount((long)loanBill.getLong("sourcebillid"), (long)0L);
        BigDecimal drawAmount = loanBill.getBigDecimal("drawamount");
        BigDecimal ratio = drawAmount.divide(notDrawAmount, 18, 4);
        DynamicObject currecny = loanBill.getDynamicObject("currency");
        int amtPrecision = currecny != null ? currecny.getInt("amtprecision") : 2;
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject loanBillEntryRow : loanBillEntrys) {
            loanBillEntryRow.set("e_bankcreditlimit", null);
            loanBillEntryRow.set("e_bankcreditcurrency", null);
            loanBillEntryRow.set("e_bankcreditamt", (Object)BigDecimal.ZERO);
            DynamicObject bank = loanBillEntryRow.getDynamicObject("e_bank");
            BigDecimal bankNotDrawamount = slBankNotdrawamount.getOrDefault(bank.getLong("id"), BigDecimal.ZERO);
            loanBillEntryRow.set("e_notdrawamount", (Object)bankNotDrawamount);
            if (notDrawAmount.compareTo(bankNotDrawamount) == 0) {
                loanBillEntryRow.set("e_shareamount", (Object)drawAmount);
                totalAmount = totalAmount.add(drawAmount);
                continue;
            }
            BigDecimal shareAmount = ratio.multiply(bankNotDrawamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            loanBillEntryRow.set("e_shareamount", (Object)shareAmount);
            totalAmount = totalAmount.add(shareAmount);
        }
        BigDecimal subAmount = drawAmount.subtract(totalAmount);
        DynamicObject mbEntry = loanBillEntrys.stream().filter(o -> "MB".equals(o.getString("e_bankrole"))).findFirst().orElseGet(null);
        if (mbEntry != null) {
            BigDecimal mbAmount = mbEntry.getBigDecimal("e_notdrawamount");
            BigDecimal shareAmt = mbEntry.getBigDecimal("e_shareamount").add(subAmount);
            if (mbAmount.compareTo(BigDecimal.ZERO) > 0 && mbAmount.compareTo(shareAmt) > 0) {
                mbEntry.set("e_shareamount", (Object)shareAmt);
            } else {
                this.setScaleAmount(loanBillEntrys, subAmount);
            }
        }
    }

    private void setScaleAmount(DynamicObjectCollection loanBillEntrys, BigDecimal subAmount) {
        for (DynamicObject loanBillEntry : loanBillEntrys) {
            if (EmptyUtil.isEmpty((BigDecimal)subAmount)) break;
            if ("MB".equals(loanBillEntry.getString("e_bankrole"))) continue;
            BigDecimal notAmount = loanBillEntry.getBigDecimal("e_notdrawamount");
            BigDecimal shareAmount = loanBillEntry.getBigDecimal("e_shareamount");
            BigDecimal eAmount = notAmount.subtract(shareAmount);
            if (subAmount.compareTo(BigDecimal.ZERO) > 0 && eAmount.compareTo(subAmount) < 0) {
                subAmount = subAmount.subtract(eAmount);
                loanBillEntry.set("e_shareamount", (Object)shareAmount.add(eAmount));
                continue;
            }
            loanBillEntry.set("e_shareamount", (Object)shareAmount.add(subAmount));
            break;
        }
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.handlerException(dataEntities);
        Object[] applyids = Arrays.stream(dataEntities).map(o -> o.getLong("id")).toArray();
        DeleteServiceHelper.delete((String)"cfm_loanbill", (QFilter[])new QFilter[]{new QFilter("drawapplybill", "in", (Object)applyids)});
    }
}

