/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.extendbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.ContractExtendStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmAttachmentHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.common.resource.CfmBondResource;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ExtendBillSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("sourcebillid");
        sic.add("datasource");
        sic.add("org");
        sic.add("creditorg");
        sic.add("registorg");
        sic.add("textdebtor");
        sic.add("textcreditor");
        sic.add("returnreason");
        sic.add("productfactory");
        sic.add("renewalexpiredate");
        sic.add("enddate");
        sic.add("prevrenewalexpiredate");
        sic.add("startdate");
        sic.add("creditortype");
        sic.add("creditor");
        sic.add("debtor");
        sic.add("debtortype");
        sic.add("lendernature");
        sic.add("loantype");
        sic.add("loanbilllist");
        sic.add("drawbillid");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObjectCollection loanBillList;
        String dataSource = "";
        CfmBillCommonHelper.setNeedSaveFieldValue((DynamicObject[])dataEntities);
        for (DynamicObject extendBill : dataEntities) {
            dataSource = extendBill.getString("datasource");
            BusinessHelper.clearReturnreason((DynamicObject)extendBill);
            DynamicObject contractBill = TmcDataServiceHelper.loadSingle((Object)extendBill.get("sourcebillid"), (String)"cfm_loancontractbill");
            if (!EmptyUtil.isNoEmpty((DynamicObject)contractBill)) continue;
            contractBill.set("extendstatus", (Object)ContractExtendStatusEnum.SUBMIT.getValue());
            BusinessDataServiceHelper.save((IDataEntityType)contractBill.getDataEntityType(), (Object[])new DynamicObject[]{contractBill});
        }
        if (this.getOperationResult().isSuccess() && EmptyUtil.isNoEmpty((DynamicObjectCollection)(loanBillList = dataEntities[0].getDynamicObjectCollection("loanbilllist"))) && loanBillList.size() > 0) {
            Object drawbillid = ((DynamicObject)loanBillList.get(0)).get("drawbillid");
            DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)drawbillid, (String)CfmEntityEnum.LOANBILL.getValue(), (String)"repaymentway,handinstplan");
            String repaymentWay = loanBill.getString("repaymentway");
            if (RepaymentWayEnum.bqhblsbq.getValue().equals(repaymentWay) || RepaymentWayEnum.bqhbdqhx.getValue().equals(repaymentWay)) {
                if (BizTypeEnum.isBond((String)dataSource) && loanBill.getBoolean("handinstplan")) {
                    this.getOperationResult().setMessage(CfmBondResource.getEbAuditSuccess());
                }
                return;
            }
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
            this.getOperationResult().setMessage(bizResource.getEbSubmitSuccess());
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        CfmAttachmentHelper.dealAttachment((DynamicObject[])dataEntities);
    }
}

