/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.feeshare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ShareTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class FeeShareAuditService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        if (EmptyUtil.isEmpty((Object[])(dataEntities = (DynamicObject[])Arrays.stream(dataEntities).filter(o -> o.getInt("day") == 0).toArray(DynamicObject[]::new)))) {
            return;
        }
        Set sbillID = Arrays.stream(dataEntities).map(o -> o.getLong("sourcebillid")).collect(Collectors.toSet());
        DynamicObject[] loands = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)"id,irr", (QFilter[])new QFilter[]{new QFilter("id", "in", sbillID)});
        Map<Object, DynamicObject> bondMap = Arrays.stream(loands).collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        for (DynamicObject bill : dataEntities) {
            Object sourceBillId = bill.get("sourcebillid");
            DynamicObject loand = bondMap.get(sourceBillId);
            if (!ShareTypeEnum.isInterest((String)bill.getString("freesharetype"))) continue;
            loand.set("irr", bill.get("irr"));
        }
        this.setEntryToBill(dataEntities);
        SaveServiceHelper.save((DynamicObject[])loands);
    }

    private void setEntryToBill(DynamicObject[] datas) {
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>();
        ArrayList<Pair> srcTarIds = new ArrayList<Pair>(datas.length);
        for (DynamicObject data : datas) {
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                DynamicObject entry = (DynamicObject)entrys.get(0);
                dataList.add(this.createBillFromEntry(entry, data));
                entrys.remove((Object)entry);
            }
            long[] idsArr = DB.genLongIds((String)data.getDynamicObjectType().getAlias(), (int)entrys.size());
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject newBill = TmcDataServiceHelper.clone((DynamicObject)data);
                newBill.set("id", (Object)idsArr[i]);
                newBill.getDynamicObjectCollection("entryentity").clear();
                dataList.add(this.createBillFromEntry(entry, newBill));
                srcTarIds.add(Pair.of((Object)data.getLong("sourcebillid"), (Object)newBill.getLong("id")));
            }
            entrys.clear();
        }
        if (srcTarIds.size() > 0) {
            TmcBotpHelper.batchSaveRelation((String)"cfm_loanbill", (String)"cfm_loanfeeshare", srcTarIds);
        }
        SaveServiceHelper.save((DynamicObject[])dataList.toArray(new DynamicObject[0]));
    }

    private DynamicObject createBillFromEntry(DynamicObject entry, DynamicObject data) {
        data.set("periodstartdate", (Object)entry.getDate("e_startdate"));
        data.set("periodenddate", (Object)entry.getDate("e_enddate"));
        data.set("accrualinterest", (Object)entry.getBigDecimal("e_accrualinterest"));
        data.set("payinterest", (Object)entry.getBigDecimal("e_payinterest"));
        data.set("shareamount", (Object)entry.getBigDecimal("e_shareamount"));
        data.set("adjustmentamount", (Object)entry.getBigDecimal("e_adjustmentamount"));
        data.set("actualamount", (Object)entry.getBigDecimal("e_actualamount"));
        data.set("day", (Object)entry.getInt("e_day"));
        return data;
    }
}

