/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.feeshare;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.bean.CostShareInfo;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.ShareTypeEnum;
import kd.tmc.fbp.common.helper.CostShareServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeShareCalculateService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        boolean isedit = this.operationVariable.containsKey("isedit");
        if (isedit) {
            return;
        }
        Set sbillID = Arrays.stream(dataEntities).map(o -> o.getLong("sourcebillid")).collect(Collectors.toSet());
        DynamicObject[] loands = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)"id,productfactory,feedetail.feeamt,bizdate,irr,org,currency,rateadjust_entry.ra_yearrate", (QFilter[])new QFilter[]{new QFilter("id", "in", sbillID)});
        Map<Object, DynamicObject> loandMap = Arrays.stream(loands).collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection rateJustEntrys;
            Long bondId = bill.getLong("sourcebillid");
            DynamicObject loandBill = loandMap.get(bondId);
            DynamicObject factory = loandBill.getDynamicObject("productfactory");
            Date startDate = bill.getDate("bizdate");
            Date endDate = bill.getDate("expiredate");
            List dateList = CostShareServiceHelper.getDateList((DynamicObject)factory, (Date)startDate, (Date)endDate, (String)bill.getString("sharefrequency"));
            BigDecimal feeAmt = CostShareServiceHelper.getFeeAmount((Long)loandBill.getLong("id"), (Long)loandBill.getDynamicObject("org").getLong("id"), (Long)loandBill.getDynamicObject("currency").getLong("id"), (String)"cfm");
            DynamicObjectCollection feeBills = CostShareServiceHelper.getFeeBills(Collections.singleton(bondId));
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)feeBills)) {
                bill.set("freesharetype", (Object)((DynamicObject)feeBills.get(0)).getString("sharetype"));
            }
            BigDecimal amount = bill.getBigDecimal("amount");
            DynamicObject currency = bill.getDynamicObject("currency");
            bill.set("feeamount", (Object)feeAmt);
            BigDecimal initCcbAmt = amount.subtract(feeAmt);
            String interestType = bill.getString("interesttype");
            BigDecimal loanRate = bill.getBigDecimal("loanrate");
            if (InterestTypeEnum.FLOAT.getValue().equals(interestType) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(rateJustEntrys = loandBill.getDynamicObjectCollection("rateadjust_entry")))) {
                loanRate = ((DynamicObject)rateJustEntrys.get(0)).getBigDecimal("ra_yearrate");
            }
            loanRate = loanRate.divide(Constants.ONE_HUNDRED);
            BasisEnum basisEnum = BasisEnum.getEnum((String)bill.getString("basis"));
            if (ShareTypeEnum.isStraight((String)bill.getString("freesharetype"))) {
                amount = feeAmt;
            }
            List costShareInfoList = CostShareServiceHelper.getCostShareList((List)dateList, (BigDecimal)amount, (BigDecimal)initCcbAmt, (BigDecimal)loanRate, (BasisEnum)basisEnum, (int)currency.getInt("amtprecision"), (String)bill.getString("freesharetype"));
            CostShareServiceHelper.dealCurrencyTailDiff((List)costShareInfoList, (BigDecimal)feeAmt, (int)currency.getInt("amtprecision"));
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            entrys.clear();
            BigDecimal ytm = BigDecimal.ZERO;
            for (CostShareInfo info : costShareInfoList) {
                ytm = info.getYtm();
                String startDateStr = DateUtils.formatString((Date)info.getStartDate(), (String)"yyyy-MM-dd");
                String endDateStr = DateUtils.formatString((Date)info.getEndDate(), (String)"yyyy-MM-dd");
                DynamicObject entry = entrys.addNew();
                entry.set("e_period", (Object)(startDateStr + "-" + endDateStr));
                entry.set("e_startdate", (Object)info.getStartDate());
                entry.set("e_enddate", (Object)info.getEndDate());
                entry.set("e_day", (Object)info.getDays());
                entry.set("e_accrualinterest", (Object)info.getEiInterestAmt());
                entry.set("e_payinterest", (Object)info.getAiInterestAmt());
                entry.set("e_shareamount", (Object)info.getAmAmt());
                entry.set("e_actualamount", (Object)info.getAmAmt());
            }
            ytm = ytm.multiply(Constants.ONE_HUNDRED);
            bill.set("irr", (Object)ytm);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }
}

