/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.initbill;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBillDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("loantype");
        selector.add("loanentry");
        selector.add("loanentry.loanbillid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashSet entryIds = new HashSet(dataEntities.length);
        for (DynamicObject initBill : dataEntities) {
            DynamicObjectCollection loanEntrys = initBill.getDynamicObjectCollection("loanentry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)loanEntrys) || !LoanTypeEnum.isBankLoan((String)initBill.getString("loantype")) && !LoanTypeEnum.isBond((String)initBill.getString("loantype"))) continue;
            entryIds.addAll(loanEntrys.parallelStream().map(o -> o.getLong("loanbillid")).collect(Collectors.toSet()));
        }
        if (entryIds.size() > 0) {
            DeleteServiceHelper.delete((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", entryIds), new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue())});
        }
    }
}

