/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.initbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.bean.RepayPlanInfo;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RepayStateEnum;
import kd.tmc.cfm.common.service.UpdateRepayPlanService;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RepayPlanRequest;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.inst.plan.RepayPlanCallStragety;

public class InitBillGenRepayPlanService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("org");
        sic.add("loanentry");
        sic.add("repaysubentry");
        sic.add("repayamount");
        sic.add("drawamount");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject initBill : dataEntities) {
            this.dealAutoRepayPlan(initBill);
        }
    }

    private void dealAutoRepayPlan(DynamicObject initBill) {
        DynamicObjectCollection loanEntrys = initBill.getDynamicObjectCollection("loanentry");
        String chooseParentEntrySeq = (String)this.operationVariable.get("chooseParentEntrySeq");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loanEntrys) || EmptyUtil.isEmpty((String)chooseParentEntrySeq)) {
            return;
        }
        for (DynamicObject loanEntry : loanEntrys) {
            if (!(loanEntry.get("seq") + "").equals(chooseParentEntrySeq)) continue;
            DynamicObjectCollection repaySubEntrys = loanEntry.getDynamicObjectCollection("repaysubentry");
            RepayPlanRequest request = this.genRepayPlanRequest(loanEntry, initBill);
            List repayPlanList = new RepayPlanCallStragety().callPlan(request);
            if (EmptyUtil.isEmpty((Collection)repayPlanList)) continue;
            repaySubEntrys.clear();
            BigDecimal repayAmt = loanEntry.getBigDecimal("repayamount");
            Date repayDate = loanEntry.getDate("repaydate");
            if (repayDate != null && EmptyUtil.isNoEmpty((BigDecimal)repayAmt)) {
                UpdateRepayPlanService updateRepayPlanService = new UpdateRepayPlanService();
                ArrayList<RepayPlanInfo> repayPlans = new ArrayList<RepayPlanInfo>(repayPlanList.size());
                RepayPlanInfo repayInfo = RepayPlanInfo.build((Date)repayDate, (BigDecimal)repayAmt);
                for (PlanCallResult planInfo : repayPlanList) {
                    repayPlans.add(RepayPlanInfo.build((Date)planInfo.getBizDate(), (BigDecimal)planInfo.getPrinciple(), (BigDecimal)planInfo.getPrinciple()));
                }
                List repayPlanInfos = updateRepayPlanService.updateRepayPlan(repayPlans, Collections.singletonList(repayInfo));
                for (int i = 0; i < repayPlanInfos.size(); ++i) {
                    RepayPlanInfo repayPlanInfo = (RepayPlanInfo)repayPlanInfos.get(i);
                    DynamicObject repayP = repaySubEntrys.addNew();
                    repayP.set("seq", (Object)(i + 1));
                    repayP.set("exrepaymentdate", (Object)repayPlanInfo.getRepayDate());
                    repayP.set("exdrawamount", (Object)repayPlanInfo.getRepayAmount());
                    if (!repayPlanInfo.repayed()) continue;
                    repayP.set("repaymentdesc", (Object)RepayStateEnum.PAYED.getName());
                }
                continue;
            }
            for (int i = 0; i < repayPlanList.size(); ++i) {
                PlanCallResult planCallResult = (PlanCallResult)repayPlanList.get(i);
                DynamicObject repayP = repaySubEntrys.addNew();
                repayP.set("seq", (Object)(i + 1));
                repayP.set("exrepaymentdate", (Object)planCallResult.getBizDate());
                repayP.set("exdrawamount", (Object)planCallResult.getPrinciple());
            }
        }
    }

    private RepayPlanRequest genRepayPlanRequest(DynamicObject loanEntry, DynamicObject initBill) {
        RepayPlanRequest request = new RepayPlanRequest();
        request.setLoanAmount(loanEntry.getBigDecimal("drawamount"));
        request.setLoanDate(loanEntry.getDate("loaddate"));
        request.setExpiredate(loanEntry.getDate("expiredate"));
        if (LoanTypeEnum.BOND.getValue().equals(initBill.getString("loantype"))) {
            request.setRepayScheme(loanEntry.getDynamicObject("loan_stageplan"));
            request.setRepayWay(RepaymentWayEnum.valueOf((String)loanEntry.getString("loan_repaymentway")));
        } else {
            request.setRepayScheme(initBill.getDynamicObject("stageplan"));
            request.setRepayWay(RepaymentWayEnum.valueOf((String)initBill.getString("repaymentway")));
        }
        request.setCurrency(initBill.getDynamicObject("currency"));
        return request;
    }
}

