/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.initbill;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmFinVarietyHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBillSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("org");
        sic.add("creditortype");
        sic.add("debtortype");
        sic.add("repaymentway");
        sic.add("registorg");
        sic.add("interesttype");
        sic.add("interestrate");
        sic.add("referencerate");
        sic.add("startdate");
        sic.add("ratefloatpoint");
        sic.add("ratesign");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject initBill : dataEntities) {
            DynamicObject org;
            boolean isInvestInit = "cim_invest_initbill".equals(initBill.getDataEntityType().getName());
            if (!isInvestInit) {
                this.dealCreditor(initBill);
                org = initBill.getDynamicObject("org");
                initBill.set("textdebtor", (Object)BusinessHelper.getLocalValue((DynamicObject)org, (String)"name"));
            } else {
                org = initBill.getDynamicObject("creditorg");
                initBill.set("textcreditor", (Object)BusinessHelper.getLocalValue((DynamicObject)org, (String)"name"));
            }
            initBill.set("registorg", (Object)org);
            InitBillSaveService.clearFieldValueOnSave(initBill);
            this.dealImp(initBill);
        }
    }

    private void dealCreditor(DynamicObject initBill) {
        if (!StringUtils.equals((CharSequence)initBill.getString("creditortype"), (CharSequence)CreditorTypeEnum.INNERUNIT.getValue())) {
            return;
        }
        String textCreditor = initBill.getString("textcreditor");
        QFilter filter = new QFilter("name", "=", (Object)textCreditor).and("fisbankroll", "=", (Object)true);
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{filter});
        initBill.set("creditor", org.get("id"));
    }

    private static void clearFieldValueOnSave(DynamicObject initBill) {
        String instType = initBill.getString("interesttype");
        if (InterestTypeEnum.FIXED.getValue().equals(instType) || InterestTypeEnum.AGREE.getValue().equals(instType)) {
            initBill.set("rateadjuststyle", null);
            initBill.set("referencerate", (Object)0);
            initBill.set("rateadjustcycle", (Object)0);
            initBill.set("rateadjustcycletype", null);
            initBill.set("rateadjustdate", null);
            initBill.set("ratesign", null);
            initBill.set("ratefloatpoint", null);
        } else if (InterestTypeEnum.FLOAT.getValue().equals(instType)) {
            InitBillSaveService.setContractInterestRate(initBill);
            String adjuststyle = initBill.getString("rateadjuststyle");
            if (!RateAdjustStyleEnum.CYCLE.getValue().equals(adjuststyle)) {
                initBill.set("rateadjustcycle", (Object)0);
                initBill.set("rateadjustcycletype", null);
                initBill.set("rateadjustdate", null);
            }
        }
    }

    private void dealImp(DynamicObject initBill) {
        boolean isInvestInit = "cim_invest_initbill".equals(initBill.getDataEntityType().getName());
        if ("ifm_initbill".equals(initBill.getDataEntityType().getName()) || isInvestInit) {
            return;
        }
        Boolean isImport = initBill.getBoolean("isimport");
        if (isImport.booleanValue()) {
            if (!BusinessHelper.isOutGroup((DynamicObject)initBill)) {
                return;
            }
            DynamicObjectCollection loanEntrys = initBill.getDynamicObjectCollection("loanentry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)loanEntrys)) {
                return;
            }
            Long orgId = (Long)initBill.getDynamicObject("org").getPkValue();
            Long finOrgId = initBill.getLong("creditor");
            Long currencyId = (Long)initBill.getDynamicObject("currency").getPkValue();
            long[] genLongIds = DB.genLongIds((String)EntityMetadataCache.getDataEntityType((String)"cfm_loanbill").getAlias(), (int)loanEntrys.size());
            int count = 0;
            for (DynamicObject loanEntry : loanEntrys) {
                DynamicObject creditLimit = loanEntry.getDynamicObject("creditlimit");
                if (EmptyUtil.isEmpty((DynamicObject)creditLimit)) continue;
                BigDecimal creditAmount = loanEntry.getBigDecimal("creditamount");
                BigDecimal drawAmount = loanEntry.getBigDecimal("drawamount");
                if (EmptyUtil.isEmpty((BigDecimal)creditAmount)) {
                    creditAmount = drawAmount;
                }
                CreditLimitUseBean useBean = new CreditLimitUseBean();
                Long loanBillId = genLongIds[count++];
                String loanBillNo = CodeRuleHelper.generateNumber((String)"cfm_loanbill", (DynamicObject)TmcDataServiceHelper.newDynamicObject((String)"cfm_loanbill"), (String)orgId.toString(), (String)"");
                loanEntry.set("loanbillid", (Object)loanBillId);
                loanEntry.set("loanbillno", (Object)loanBillNo);
                useBean.setPkId(loanBillId);
                useBean.setEntityName("cfm_loanbill");
                useBean.setOrgId(orgId);
                useBean.setFinOrgId(finOrgId);
                String loanType = initBill.getString("loantype");
                if (LoanTypeEnum.isEntrustLoan((String)loanType) || LoanTypeEnum.isLinklend((String)loanType)) {
                    useBean.setCreditFinType(CreditFinTypeEnum.ORG.getValue());
                }
                useBean.setCurrencyId(currencyId);
                DynamicObject finproduct = initBill.getDynamicObject("finproduct");
                useBean.setCreditTypeId(CfmFinVarietyHelper.getCreditTypeByFinVarietyId((Long)((Long)finproduct.getPkValue())));
                useBean.setCreditVariety(finproduct.getString("name"));
                useBean.setBizAmt(creditAmount);
                useBean.setMaxAmt(loanEntry.getBigDecimal("drawamount"));
                useBean.setStartDate(loanEntry.getDate("loaddate"));
                useBean.setEndDate(loanEntry.getDate("expiredate"));
                useBean.setCreditLimitNo(creditLimit.getString("number"));
                CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
            }
        }
    }

    private static void setContractInterestRate(DynamicObject initBill) {
        String interestType = initBill.getString("interesttype");
        if (!InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            return;
        }
        initBill.set("interestrate", (Object)InitBillSaveService.getRate(initBill));
    }

    private static BigDecimal getRate(DynamicObject initBill) {
        DynamicObject referenceRate = initBill.getDynamicObject("referencerate");
        Date startDate = initBill.getDate("startdate");
        BigDecimal rateFloatPoint = initBill.getBigDecimal("ratefloatpoint");
        String rateSign = initBill.getString("ratesign");
        if (EmptyUtil.isNoEmpty((DynamicObject)referenceRate) && EmptyUtil.isNoEmpty((Object)startDate)) {
            BigDecimal rate = MarketDataServiceHelper.referRate((String)referenceRate.getString("number"), (Date)startDate, (boolean)false);
            if (EmptyUtil.isEmpty((BigDecimal)rate)) {
                return BigDecimal.ZERO;
            }
            BigDecimal rateFloat = new BigDecimal(BigInteger.ZERO);
            if (EmptyUtil.isNoEmpty((BigDecimal)rateFloatPoint) && EmptyUtil.isNoEmpty((String)rateSign)) {
                rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
                if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                    rateFloat = rateFloat.negate();
                }
            }
            return rate.add(rateFloat);
        }
        return BigDecimal.ZERO;
    }
}

