/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.initbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.cfm.common.bean.RepayPlanBean;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.InitStatusEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.OverRateTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.CfmBillSDKHelper;
import kd.tmc.cfm.common.helper.EntityPropertyHelper;
import kd.tmc.cfm.common.helper.InitBillHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBondBillendInitService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(InitBondBillendInitService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.addAll(EntityPropertyHelper.getPropertys((String)"cfm_initbill_bond"));
        sic.add("loanentry");
        sic.addAll(EntityPropertyHelper.getEntryPropertys((String)"cfm_initbill_bond", (String)"loanentry"));
        sic.add("repaysubentry");
        sic.add("exrepaymentdate");
        sic.add("exdrawamount");
        sic.add("repaymentdesc");
        sic.add("confirmstatus");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("textdebtor");
        sic.add("datasource");
        sic.add("registorg");
        sic.add("feedetail");
        sic.add("feescheme");
        sic.add("feetype");
        sic.add("feecurrency");
        sic.add("feeamt");
        sic.add("feepaydate");
        sic.add("feerate");
        sic.add("feesettletype");
        sic.add("feeacctbank");
        sic.add("feeoppunittype");
        sic.add("feeoppunit");
        sic.add("feeoppunittext");
        sic.add("feeoppacctbank");
        sic.add("feeoppbebank");
        sic.add("feesource");
        sic.add("feeissettle");
        sic.add("feeremark");
        sic.add("excrate");
        sic.add("loan_feedetail");
        sic.add("lfeescheme");
        sic.add("lfeetype");
        sic.add("lfeecurrency");
        sic.add("lfeeamt");
        sic.add("lfeepaydate");
        sic.add("lfeerate");
        sic.add("lfeesettletype");
        sic.add("lfeeacctbank");
        sic.add("lfeeoppunittype");
        sic.add("lfeeoppunit");
        sic.add("lfeeoppunittext");
        sic.add("lfeeoppacctbank");
        sic.add("lfeeoppbebank");
        sic.add("lfeesource");
        sic.add("lfeeissettle");
        sic.add("lfeeremark");
        sic.add("lexcrate");
        sic.add("project_entry");
        sic.add("e_project");
        sic.add("e_projdescription");
        sic.add("bondtype");
        sic.add("shortname");
        sic.add("issuancemethod");
        sic.add("issuemarket");
        sic.add("ratingagency");
        sic.add("ratingscale");
        sic.add("debtratingscale");
        sic.add("custodianfinorg");
        sic.add("underwritemethod");
        sic.add("loan_interesttype");
        sic.add("loan_contractno");
        sic.add("loan_contractname");
        sic.add("loan_shortname");
        sic.add("loan_referencerate");
        sic.add("publishprice");
        sic.add("ticketamt");
        sic.add("loan_repaymentway");
        sic.add("loan_settleintmode");
        sic.add("loan_basis");
        sic.add("loan_stageplan");
        sic.add("loan_interestsettledplan");
        sic.add("loan_ratingagency");
        sic.add("loan_ratingscale");
        sic.add("loan_debtratingscale");
        sic.add("loan_custodianfinorg");
        sic.add("loan_underwritemethod");
        sic.add("loan_use");
        sic.add("lfeeoppunittext");
        sic.add("e_underwritertype");
        sic.add("e_isbookrunner");
        sic.add("e_underwriter");
        sic.add("e_underwriteratio");
        sic.add("e_underwriteamount");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject initBill : dataEntities) {
            initBill.set("initstatus", (Object)InitStatusEnum.INITED.getValue());
            initBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            logger.info(" 1: \u751f\u6210\u503a\u5238\u53d1\u884c\u8ba1\u5212\u5e76\u4e14\u4fdd\u5b58\u5165\u5e93.");
            DynamicObject contractBondBill = this.genBondContractBill(initBill);
            logger.info(" 2: \u751f\u6210\u503a\u5238\u53d1\u884c.");
            DynamicObjectCollection loans = initBill.getDynamicObjectCollection("loanentry");
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)loans)) {
                this.genLoanBills(initBill, contractBondBill, loans);
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)loans)) continue;
            logger.info("4. \u8c03\u7528\u7edf\u4e00\u7684writeBack\u65b9\u6cd5.");
            this.writeBack(contractBondBill);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private void writeBack(DynamicObject contractBondBill) {
        Long contractId = (Long)contractBondBill.getPkValue();
        QFilter contractFilter = new QFilter("sourcebillid", "=", (Object)contractId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter drawStatusFilter = new QFilter("drawtype", "in", (Object)new String[]{DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue()});
        DynamicObjectCollection loadBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id", (QFilter[])new QFilter[]{contractFilter, statusFilter, drawStatusFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loadBills)) {
            return;
        }
        LoanWriteBackHelper.writeBack(loadBills.stream().map(d -> d.getLong("id")).collect(Collectors.toList()), (LoanWBTypeEnum)LoanWBTypeEnum.REPAYMENT);
    }

    private void genLoanBills(DynamicObject initBill, DynamicObject contractBondBill, DynamicObjectCollection loanBills) {
        for (DynamicObject loan : loanBills) {
            OperateOption create = OperateOption.create();
            create.setVariableValue("byInit", "true");
            create.setVariableValue("bondbyInit", "true");
            create.setVariableValue("loan_contractno", loan.getString("loan_contractno"));
            create.setVariableValue("loan_contractname", loan.getString("loan_contractname"));
            create.setVariableValue("loan_shortname", loan.getString("loan_shortname"));
            create.setVariableValue("publishprice", String.valueOf(loan.getBigDecimal("publishprice")));
            create.setVariableValue("ticketamt", String.valueOf(loan.getBigDecimal("ticketamt")));
            create.setVariableValue("loan_interesttype", loan.getString("loan_interesttype"));
            create.setVariableValue("loan_repaymentway", loan.getString("loan_repaymentway"));
            create.setVariableValue("loan_settleintmode", loan.getString("loan_settleintmode"));
            create.setVariableValue("loan_basis", loan.getString("loan_basis"));
            create.setVariableValue("loan_stageplan", String.valueOf(loan.getLong("loan_stageplan.id")));
            create.setVariableValue("loan_interestsettledplan", String.valueOf(loan.getLong("loan_interestsettledplan.id")));
            create.setVariableValue("loan_ratingagency", String.valueOf(loan.getLong("loan_ratingagency.id")));
            create.setVariableValue("loan_ratingscale", loan.getString("loan_ratingscale"));
            create.setVariableValue("loan_debtratingscale", loan.getString("loan_debtratingscale"));
            create.setVariableValue("loan_custodianfinorg", String.valueOf(loan.getLong("loan_custodianfinorg.id")));
            create.setVariableValue("loan_underwritemethod", loan.getString("loan_underwritemethod"));
            create.setVariableValue("loan_use", String.valueOf(loan.getLong("loan_use.id")));
            create.setVariableValue("occupybondlimit", String.valueOf(loan.getLong("occupybondlimit.id")));
            create.setVariableValue("loanbillid", String.valueOf(loan.getLong("loanbillid")));
            create.setVariableValue("loanbillno", loan.getString("loanbillno"));
            create.setVariableValue("drawamount", String.valueOf(loan.getBigDecimal("drawamount")));
            create.setVariableValue("loaddate", this.getDatePro(loan, "loaddate"));
            create.setVariableValue("receivedate", this.getDatePro(loan, "receivedate"));
            create.setVariableValue("startinstdate", this.getDatePro(loan, "startinstdate"));
            create.setVariableValue("loanterm", loan.getString("loanterm"));
            create.setVariableValue("expiredate", this.getDatePro(loan, "expiredate"));
            create.setVariableValue("loanrate", String.valueOf(loan.getBigDecimal("loanrate")));
            create.setVariableValue("loadacctbank", loan.getDynamicObject("loadacctbank").getPkValue().toString());
            create.setVariableValue("repayamount", String.valueOf(loan.getBigDecimal("repayamount")));
            create.setVariableValue("repaydate", this.getDatePro(loan, "repaydate"));
            create.setVariableValue("payinterestamount", String.valueOf(loan.getBigDecimal("payinterestamount")));
            create.setVariableValue("endinstdate", this.getDatePro(loan, "endinstdate"));
            create.setVariableValue("endpreinstdate", this.getDatePro(loan, "endpreinstdate"));
            create.setVariableValue("initid", String.valueOf(initBill.getPkValue()));
            if (InterestTypeEnum.FLOAT.getValue().equals(loan.getString("loan_interesttype"))) {
                create.setVariableValue("interesttype", InterestTypeEnum.FLOAT.getValue());
                create.setVariableValue("loan_referencerate", String.valueOf(loan.getLong("loan_referencerate.id")));
                create.setVariableValue("loanratesign", String.valueOf(loan.getString("loanratesign")));
                create.setVariableValue("loanratefloatpoint", String.valueOf(loan.get("loanratefloatpoint")));
                create.setVariableValue("loanrateadjuststyle", String.valueOf(loan.getString("loanrateadjuststyle")));
                if (RateAdjustStyleEnum.CYCLE.getValue().equals(loan.getString("loanrateadjuststyle"))) {
                    create.setVariableValue("loanrateadjustdate", this.getDatePro(loan, "loanrateadjustdate"));
                    create.setVariableValue("loanrateadjusttype", String.valueOf(loan.get("loanrateadjusttype")));
                    create.setVariableValue("loanrateadjustcycle", String.valueOf(loan.get("loanrateadjustcycle")));
                }
            }
            if (contractBondBill.getBoolean("isextend")) {
                create.setVariableValue("loanexpiredate", this.getDatePro(loan, "loanexpiredate"));
                create.setVariableValue("extrateajustdate", this.getDatePro(loan, "extrateajustdate"));
                create.setVariableValue("renewalinterestrate", String.valueOf(initBill.getBigDecimal("renewalinterestrate")));
            }
            DynamicObjectCollection plans = loan.getDynamicObjectCollection("repaysubentry");
            ArrayList<RepayPlanBean> planList = new ArrayList<RepayPlanBean>();
            for (DynamicObject plan : plans) {
                RepayPlanBean rp = new RepayPlanBean();
                planList.add(rp);
                rp.setExrepaymentdate(plan.getDate("exrepaymentdate"));
                rp.setExdrawamount(plan.getBigDecimal("exdrawamount"));
                rp.setRepaymentdesc(plan.getString("repaymentdesc"));
            }
            create.setVariableValue("repaysubentry", SerializationUtils.toJsonString(planList));
            create.setVariableValue("datasource", initBill.getString("datasource"));
            IAppCache iAppCache = TmcAppCache.get((String)"cfm", (String)"initbill", (String)"init");
            HashMap<String, String> loanBillInfo = new HashMap<String, String>();
            loanBillInfo.put("loanBillId", String.valueOf(loan.getLong("loanbillid")));
            loanBillInfo.put("loanBillNo", loan.getString("loanbillno"));
            iAppCache.put("tmc_cfm_init_loanbill:" + String.valueOf(contractBondBill.getPkValue()), loanBillInfo, 300);
            String loanType = initBill.getString("loantype");
            this.dealLoanUnderWriter(loan, create);
            this.dealLoanInvestor(loan, create);
            this.dealLoanFeeEntry(loan, loanType, create);
            InitBillHelper.dealGmSubEntry((DynamicObject)loan, (DynamicObject)initBill, (String)loanType, (OperateOption)create);
            TmcOperateServiceHelper.execOperate((String)"loanbillinitpushandsave", (String)"cfm_loancontract_bo", (DynamicObject[])new DynamicObject[]{contractBondBill}, (OperateOption)create);
        }
    }

    private DynamicObject genBondContractBill(DynamicObject initBill) {
        DynamicObject contractBondBill = BusinessDataServiceHelper.newDynamicObject((String)"cfm_loancontract_bo");
        contractBondBill.set("confirmstatus", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        contractBondBill.set("confirmer", (Object)RequestContext.get().getUserId());
        contractBondBill.set("confirmtime", (Object)DateUtils.getCurrentTime());
        contractBondBill.set("creator", (Object)RequestContext.get().getUserId());
        contractBondBill.set("createtime", (Object)DateUtils.getCurrentTime());
        contractBondBill.set("datasource", initBill.get("datasource"));
        contractBondBill.set("registorg", initBill.get("registorg"));
        contractBondBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        contractBondBill.set("org", initBill.get("org"));
        contractBondBill.set("contractstatus", (Object)LoanContractStatusEnum.EXECUTING.getValue());
        contractBondBill.set("loantype", (Object)initBill.getString("loantype"));
        contractBondBill.set("region", initBill.get("region"));
        contractBondBill.set("creditortype", initBill.get("creditortype"));
        contractBondBill.set("textcreditor", initBill.get("textcreditor"));
        contractBondBill.set("creditor", initBill.get("creditor"));
        contractBondBill.set("creditorg", initBill.get("creditorg"));
        contractBondBill.set("clientorg", initBill.get("clientorg"));
        contractBondBill.set("bondtype", initBill.get("bondtype"));
        contractBondBill.set("finproduct", initBill.get("finproduct"));
        contractBondBill.set("lendernature", initBill.get("lendernature"));
        contractBondBill.set("textdebtor", initBill.get("textdebtor"));
        contractBondBill.set("contractno", initBill.get("contractno"));
        contractBondBill.set("shortname", initBill.get("shortname"));
        contractBondBill.set("contractname", initBill.get("contractname"));
        contractBondBill.set("bizdate", initBill.get("bizdate"));
        contractBondBill.set("startdate", initBill.get("startdate"));
        contractBondBill.set("currency", initBill.get("currency"));
        contractBondBill.set("amount", initBill.get("amount"));
        contractBondBill.set("enddate", initBill.get("enddate"));
        contractBondBill.set("term", initBill.get("term"));
        contractBondBill.set("accountbank", initBill.get("accountbank"));
        contractBondBill.set("loaneracctbank", initBill.get("loaneracctbank"));
        contractBondBill.set("drawway", initBill.get("drawway"));
        contractBondBill.set("issuancemethod", initBill.get("issuancemethod"));
        contractBondBill.set("loanuse", initBill.get("loanuse"));
        contractBondBill.set("issuemarket", initBill.get("issuemarket"));
        contractBondBill.set("ratingagency", initBill.get("ratingagency"));
        contractBondBill.set("ratingscale", initBill.get("ratingscale"));
        contractBondBill.set("debtratingscale", initBill.get("debtratingscale"));
        contractBondBill.set("custodianfinorg", initBill.get("custodianfinorg"));
        contractBondBill.set("underwritemethod", initBill.get("underwritemethod"));
        contractBondBill.set("guarantee", initBill.get("guarantee"));
        contractBondBill.set("description", initBill.get("description"));
        contractBondBill.set("intcalmethod", (Object)IntCalMethodEnum.onecallint.getValue());
        contractBondBill.set("overratetype", initBill.get("overratetype"));
        String overRateType = initBill.getString("overratetype");
        if (OverRateTypeEnum.isPercent((String)overRateType)) {
            contractBondBill.set("floatingratio", initBill.get("floatingratio"));
        } else {
            contractBondBill.set("overrate", initBill.get("overrate"));
        }
        contractBondBill.set("isinit", (Object)"1");
        contractBondBill.set("initid", initBill.getPkValue());
        contractBondBill.set("isextend", initBill.get("isextend"));
        this.dealContractSumAmt(initBill, contractBondBill);
        OperateOption create = OperateOption.create();
        create.setVariableValue("byInit", "true");
        this.dealContractFeeBill(initBill, contractBondBill, create);
        CfmBillSDKHelper.dealInitBillSecondDevFields((DynamicObject)initBill, (DynamicObject)contractBondBill);
        this.dealContractBizInfo(initBill, contractBondBill);
        this.dealContractUnderWriter(initBill, contractBondBill);
        TmcOperateServiceHelper.execOperate((String)"save", (String)"cfm_loancontract_bo", (DynamicObject[])new DynamicObject[]{contractBondBill}, (OperateOption)create);
        return contractBondBill;
    }

    private void dealLoanUnderWriter(DynamicObject loanBill, OperateOption create) {
        logger.info("  2.1 \u503a\u5238\u53d1\u884c\u7684\u627f\u9500\u5546.");
        DynamicObjectCollection underWriterEntrys = loanBill.getDynamicObjectCollection("underwriter_entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)underWriterEntrys)) {
            String loanUnderWriterEntrySeriStr = DynamicObjectSerializeUtil.serialize((Object[])underWriterEntrys.toArray(), (DynamicObjectType)((DynamicObject)underWriterEntrys.get(0)).getDynamicObjectType());
            create.setVariableValue("loanUnderWriterEntrySeriStr", loanUnderWriterEntrySeriStr);
        }
    }

    private void dealLoanInvestor(DynamicObject loanBill, OperateOption create) {
        logger.info("  2.2 \u503a\u5238\u53d1\u884c\u7684\u4e3b\u8981\u6295\u8d44\u4eba.");
        DynamicObjectCollection investorEntrys = loanBill.getDynamicObjectCollection("investor_entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)investorEntrys)) {
            String loaninvestorEntrySeriStr = DynamicObjectSerializeUtil.serialize((Object[])investorEntrys.toArray(), (DynamicObjectType)((DynamicObject)investorEntrys.get(0)).getDynamicObjectType());
            create.setVariableValue("loaninvestorEntrySeriStr", loaninvestorEntrySeriStr);
        }
    }

    private void dealLoanFeeEntry(DynamicObject loanBill, String loanType, OperateOption create) {
        logger.info("  2.2 \u503a\u5238\u53d1\u884c\u7684\u8d39\u7528\u660e\u7ec6.");
        DynamicObjectCollection loanLBs = loanBill.getDynamicObjectCollection("loan_feedetail");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)loanLBs)) {
            String loanFeeEntrySeriStr = DynamicObjectSerializeUtil.serialize((Object[])loanLBs.toArray(), (DynamicObjectType)((DynamicObject)loanLBs.get(0)).getDynamicObjectType());
            create.setVariableValue("loanFeeEntrySeriStr", loanFeeEntrySeriStr);
            String formId = "cfm_loanbill_e_l";
            if (LoanTypeEnum.BANKLOAN.getValue().equals(loanType) || LoanTypeEnum.BANKSLOAN.getValue().equals(loanType)) {
                formId = "cfm_loanbill_b_l";
            } else if (LoanTypeEnum.BOND.getValue().equals(loanType)) {
                formId = "cfm_loanbill_bond";
            }
            create.setVariableValue("FeeDetailEditPageSaveOp", formId);
        }
    }

    private void dealContractBizInfo(DynamicObject initBill, DynamicObject contractBondBill) {
        DynamicObjectCollection projectInfos = initBill.getDynamicObjectCollection("project_entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)projectInfos)) {
            DynamicObjectCollection projectCs = contractBondBill.getDynamicObjectCollection("project_entry");
            projectCs.clear();
            int seq = 1;
            for (DynamicObject projectInfo : projectInfos) {
                DynamicObject projectC = projectCs.addNew();
                projectC.set("seq", (Object)seq++);
                projectC.set("e_project", projectInfo.get("e_project"));
                projectC.set("e_projdescription", projectInfo.get("e_projdescription"));
            }
        }
    }

    private void dealContractUnderWriter(DynamicObject initBill, DynamicObject contractBondBill) {
        DynamicObjectCollection loanEntrys = initBill.getDynamicObjectCollection("loanentry");
        DynamicObjectCollection underWriterEntrys = contractBondBill.getDynamicObjectCollection("underwriter_entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)loanEntrys)) {
            underWriterEntrys.clear();
            if (loanEntrys.size() == 1) {
                DynamicObjectCollection initUnderWriterEntrys = ((DynamicObject)loanEntrys.get(0)).getDynamicObjectCollection("underwriter_entry");
                this.setUnderWriterByOne(initUnderWriterEntrys, underWriterEntrys);
            } else {
                BigDecimal amount = initBill.getBigDecimal("amount");
                this.setUnderWriterByOther(loanEntrys, underWriterEntrys, amount);
                this.dealIsBookRunner(underWriterEntrys);
            }
        }
    }

    private void setUnderWriterByOne(DynamicObjectCollection initUnderWriterEntrys, DynamicObjectCollection underWriterEntrys) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)initUnderWriterEntrys)) {
            return;
        }
        int seq = 1;
        for (DynamicObject initUnderWriterEntry : initUnderWriterEntrys) {
            DynamicObject underWriterEntry = underWriterEntrys.addNew();
            underWriterEntry.set("seq", (Object)seq++);
            underWriterEntry.set("e_underwritertype", initUnderWriterEntry.get("e_underwritertype"));
            underWriterEntry.set("e_underwriter", initUnderWriterEntry.get("e_underwriter"));
            underWriterEntry.set("e_underwriteratio", initUnderWriterEntry.get("e_underwriteratio"));
            underWriterEntry.set("e_underwriteamount", initUnderWriterEntry.get("e_underwriteamount"));
            underWriterEntry.set("e_isbookrunner", initUnderWriterEntry.get("e_isbookrunner"));
        }
    }

    private void setUnderWriterByOther(DynamicObjectCollection loanEntrys, DynamicObjectCollection underWriterEntrys, BigDecimal totalMoney) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(4);
        HashMap<Long, DynamicObject> underwriterInfo = new HashMap<Long, DynamicObject>(4);
        BigDecimal totalRate = BigDecimal.ZERO;
        BigDecimal totalUnderWriteAmount = loanEntrys.stream().flatMap(row -> row.getDynamicObjectCollection("underwriter_entry").stream()).map(o -> o.getBigDecimal("e_underwriteamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal billRate = totalUnderWriteAmount.multiply(new BigDecimal(100)).divide(totalMoney, 2, 4);
        for (DynamicObject loanEntry : loanEntrys) {
            DynamicObjectCollection initUnderWriterEntrys = loanEntry.getDynamicObjectCollection("underwriter_entry");
            for (DynamicObject initUnderWriterEntry : initUnderWriterEntrys) {
                String underWriterType = initUnderWriterEntry.getString("e_underwritertype");
                DynamicObject underWriter = initUnderWriterEntry.getDynamicObject("e_underwriter");
                Long underWriterId = underWriter.getLong("id");
                underwriterInfo.put(underWriterId, underWriter);
                String isBookrUnner = initUnderWriterEntry.getString("e_isbookrunner");
                BigDecimal underWriteAmount = initUnderWriterEntry.getBigDecimal("e_underwriteamount");
                String key = underWriterType + ";" + String.valueOf(underWriterId) + ";" + isBookrUnner;
                if (map.containsKey(key)) {
                    BigDecimal beforeMoney = (BigDecimal)map.get(key);
                    BigDecimal nowMoney = beforeMoney.add(underWriteAmount);
                    map.put(key, nowMoney);
                    continue;
                }
                map.put(key, underWriteAmount);
            }
        }
        int seq = 1;
        for (Map.Entry entry : map.entrySet()) {
            BigDecimal rate;
            String key = (String)entry.getKey();
            String[] infos = key.split(";");
            BigDecimal money = (BigDecimal)entry.getValue();
            DynamicObject underWriterEntry = underWriterEntrys.addNew();
            underWriterEntry.set("seq", (Object)seq++);
            underWriterEntry.set("e_underwritertype", (Object)infos[0]);
            underWriterEntry.set("e_underwriter", underwriterInfo.get(Long.parseLong(infos[1])));
            underWriterEntry.set("e_isbookrunner", (Object)infos[2]);
            underWriterEntry.set("e_underwriteamount", (Object)money);
            if (seq - 1 == map.size()) {
                rate = billRate.subtract(totalRate);
                underWriterEntry.set("e_underwriteratio", (Object)(rate.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : rate));
                continue;
            }
            rate = money.multiply(new BigDecimal(100)).divide(totalMoney, 2, 4);
            totalRate = totalRate.add(rate);
            underWriterEntry.set("e_underwriteratio", (Object)rate);
        }
    }

    private void dealIsBookRunner(DynamicObjectCollection underWriterEntrys) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)underWriterEntrys)) {
            return;
        }
        List bookEntrys = underWriterEntrys.stream().filter(row -> row.getBoolean("e_isbookrunner")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(bookEntrys) && bookEntrys.size() > 1) {
            Collections.sort(bookEntrys, (s1, s2) -> s2.getBigDecimal("e_underwriteratio").compareTo(s1.getBigDecimal("e_underwriteratio")));
            for (int i = 1; i < bookEntrys.size(); ++i) {
                ((DynamicObject)bookEntrys.get(i)).set("e_isbookrunner", (Object)false);
            }
        }
    }

    private void dealContractFeeBill(DynamicObject initBill, DynamicObject contractBondBill, OperateOption create) {
        logger.info(" 1.1 \u5408\u540c\u7684\u8d39\u7528\u660e\u7ec6.");
        DynamicObjectCollection initCBs = initBill.getDynamicObjectCollection("feedetail");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)initCBs)) {
            String loanType = initBill.getString("loantype");
            String formId = "cfm_loancontract_ic_l";
            if (LoanTypeEnum.BANKLOAN.getValue().equals(loanType) || LoanTypeEnum.BANKSLOAN.getValue().equals(loanType)) {
                formId = "cfm_loancontract_bl_l";
            } else if (LoanTypeEnum.BOND.getValue().equals(loanType)) {
                formId = "cfm_loancontract_bo";
            }
            create.setVariableValue("FeeDetailEditPageSaveOp", formId);
            DynamicObjectCollection feeDetails = contractBondBill.getDynamicObjectCollection("feedetail");
            feeDetails.clear();
            int seq = 1;
            for (DynamicObject initCB : initCBs) {
                DynamicObject feeDetail = feeDetails.addNew();
                feeDetail.set("seq", (Object)seq++);
                feeDetail.set("loanbillno", null);
                feeDetail.set("feescheme", initCB.get("feescheme"));
                feeDetail.set("feetype", initCB.get("feetype"));
                feeDetail.set("feepaydate", initCB.get("feepaydate"));
                feeDetail.set("feecurrency", initCB.get("feecurrency"));
                feeDetail.set("feeamt", initCB.get("feeamt"));
                feeDetail.set("feerate", initCB.get("feerate"));
                feeDetail.set("feesettletype", initCB.get("feesettletype"));
                feeDetail.set("feeacctbank", initCB.get("feeacctbank"));
                feeDetail.set("feeoppunittype", initCB.get("feeoppunittype"));
                feeDetail.set("feeoppunit", initCB.get("feeoppunit"));
                feeDetail.set("feeoppunittext", initCB.get("feeoppunittext"));
                feeDetail.set("feeoppacctbank", initCB.get("feeoppacctbank"));
                feeDetail.set("feeoppbebank", initCB.get("feeoppbebank"));
                feeDetail.set("feeissettle", (Object)"1");
                feeDetail.set("feesource", initCB.get("feesource"));
                feeDetail.set("feeremark", initCB.get("feeremark"));
                feeDetail.set("excrate", initCB.get("excrate"));
            }
        }
    }

    private void dealContractSumAmt(DynamicObject initBill, DynamicObject contractBondBill) {
        DynamicObjectCollection loanEntrys = initBill.getDynamicObjectCollection("loanentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loanEntrys)) {
            contractBondBill.set("contractstatus", (Object)LoanContractStatusEnum.REGISTERED.getValue());
            return;
        }
        BigDecimal drawTAmt = BigDecimal.ZERO;
        BigDecimal repayTAmt = BigDecimal.ZERO;
        BigDecimal payInterestTAmt = BigDecimal.ZERO;
        for (DynamicObject loanEntry : loanEntrys) {
            BigDecimal drawAmt = loanEntry.getBigDecimal("drawamount");
            BigDecimal repayAmt = loanEntry.getBigDecimal("repayamount");
            BigDecimal payInterestAmt = loanEntry.getBigDecimal("payinterestamount");
            drawTAmt = drawTAmt.add(drawAmt);
            repayTAmt = repayTAmt.add(repayAmt);
            payInterestTAmt = payInterestTAmt.add(payInterestAmt);
        }
        contractBondBill.set("drawamount", (Object)drawTAmt);
        contractBondBill.set("notdrawamount", (Object)contractBondBill.getBigDecimal("amount").subtract(drawTAmt));
        contractBondBill.set("repayamount", (Object)repayTAmt);
        contractBondBill.set("notrepayamount", (Object)drawTAmt.subtract(repayTAmt));
        contractBondBill.set("payinterestamount", (Object)payInterestTAmt);
        contractBondBill.set("notpayinterestamount", (Object)BigDecimal.ZERO);
    }

    private String getDatePro(DynamicObject loan, String property) {
        Object date = loan.get(property);
        if (date == null) {
            return "";
        }
        return DateUtils.formatString((Date)loan.getDate(property), (String)"yyyyMMdd");
    }
}

