/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.initbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.constant.DBRouteConst;

public class InitGuaranteeUseUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(InitGuaranteeUseUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle handle = TX.requiresNew();){
            try {
                result.setLog("start upgrade initguaranteeuse type and value");
                this.dataUpgradeLoanInit();
                result.setLog("end upgrade initguaranteeuse type and value");
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private int dataUpgradeLoanInit() {
        List valueList;
        String slGcQuerySql = "select tcig.fdetailid,tclb.fid,tgg.fguaranteecontractid,tgg.fgratio,tclb.fbankrole,tclb.ffinorginfoid,tclb.fcreditlimitid,tclb.fshareamount from t_gm_guaranteeuse tgg,t_cfm_loancontractbill_ba tclb,t_cfm_initbill_gmentry tcig,t_cfm_initbill_entry tcie where tgg.fgsrcbillid=tclb.fcreditlimitid and tgg.fgsrcbilltype='cfm_creditlimit' and tcig.fentryid=tcie.fentryid and tcie.fid=tclb.fid and tcig.fgcontract=tgg.fguaranteecontractid and (tcig.fgcreditortype is null or tcig.fgcreditortype = ' ') and (tcig.fgcreditor is null or tcig.fgcreditor=0)";
        DataSet slGcData = DB.queryDataSet((String)"InitGuaranteeUseUpgradeService", (DBRoute)DBRouteConst.TMC, (String)slGcQuerySql);
        HashMap<Long, ArrayList<Row>> slGcMap = new HashMap<Long, ArrayList<Row>>();
        HashSet<Long> finOrgInfoIdSet = new HashSet<Long>();
        if (!slGcData.isEmpty()) {
            for (Row slGcDatum : slGcData.copy()) {
                Long fEntryId = slGcDatum.getLong("fid");
                List<Object> listTemp = (List)slGcMap.get(fEntryId);
                if (listTemp == null) {
                    listTemp = new ArrayList<Row>();
                }
                listTemp.add(slGcDatum);
                slGcMap.put(fEntryId, (ArrayList<Row>)listTemp);
                finOrgInfoIdSet.add(slGcDatum.getLong("ffinorginfoid"));
            }
        }
        String bondGcQuerySql = "select tcig.fdetailid,tciv.fentryid,tgg.fguaranteecontractid,tgg.fgratio,tciv.finvestortype,tciv.finvestorid,tciv.finvestorname,tciv.fcreditlimitid,tciv.finvestamount from t_gm_guaranteeuse tgg,t_cfm_initbill_vr tciv,t_cfm_initbill_gmentry tcig where tgg.fgsrcbillid=tciv.fcreditlimitid and tgg.fgsrcbilltype='cfm_creditlimit' and tcig.fentryid=tciv.fentryid and tcig.fgcontract=tgg.fguaranteecontractid and (tcig.fgcreditortype is null or tcig.fgcreditortype = ' ') and (tcig.fgcreditor is null or tcig.fgcreditor=0)";
        DataSet bondGcData = DB.queryDataSet((String)"InitGuaranteeUseUpgradeService", (DBRoute)DBRouteConst.TMC, (String)bondGcQuerySql);
        HashMap bondGcMap = new HashMap();
        if (!bondGcData.isEmpty()) {
            for (Row bondGcDatum : bondGcData.copy()) {
                Long fid = bondGcDatum.getLong("fentryid");
                ArrayList<Row> listTemp = (ArrayList<Row>)bondGcMap.get(fid);
                if (listTemp == null) {
                    listTemp = new ArrayList<Row>();
                }
                listTemp.add(bondGcDatum);
                bondGcMap.put(fid, listTemp);
            }
        }
        DynamicObjectCollection finOrgCol = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", finOrgInfoIdSet)});
        HashMap<Long, String> finOrgDsMap = new HashMap<Long, String>();
        for (DynamicObject finOrgInfo : finOrgCol) {
            finOrgDsMap.put(finOrgInfo.getLong("id"), finOrgInfo.getString("name"));
        }
        for (Map.Entry entry : slGcMap.entrySet()) {
            Long fid = (Long)entry.getKey();
            valueList = (List)entry.getValue();
            for (Row gcRow : valueList) {
                this.updateGcSql(gcRow, (String)finOrgDsMap.get(gcRow.getLong("ffinorginfoid")), fid);
            }
        }
        for (Map.Entry entry : bondGcMap.entrySet()) {
            Long fEntryId = (Long)entry.getKey();
            valueList = (List)entry.getValue();
            for (Row gcRow : valueList) {
                this.updateGcSql(gcRow, fEntryId);
            }
        }
        String loanInitQuerySql = "select tcig.fdetailid,tcie.fcreditortype,tcie.fcreditorid,tcie.ftextcreditor from t_cfm_initbill_e tcie,t_cfm_initbill_entry tcie2,t_cfm_initbill_gmentry tcig where tcie.fid=tcie2.fid and tcie2.fentryid=tcig.fentryid and tcie.fcreditortype is not null and tcie.fcreditortype != ' ' and tcie.fcreditorid is not null and tcie.fcreditorid != 0 and (tcig.fgcreditortype is null or tcig.fgcreditortype = ' ') and (tcig.fgcreditor is null or tcig.fgcreditor=0)";
        DataSet loanInitData = DB.queryDataSet((String)"InitGuaranteeUseUpgradeService", (DBRoute)DBRouteConst.TMC, (String)loanInitQuerySql);
        if (!loanInitData.isEmpty()) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(100);
            for (Row loanInitDatum : loanInitData.copy()) {
                Object[] params = new Object[]{loanInitDatum.getString("fcreditortype"), loanInitDatum.getLong("fcreditorid"), loanInitDatum.getString("ftextcreditor"), loanInitDatum.getLong("fdetailid")};
                paramList.add(params);
            }
            if (!paramList.isEmpty()) {
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)"update t_cfm_initbill_gmentry set fgcreditortype=?,fgcreditor=?,fgcreditortext=? where fdetailid=? and (fgcreditortype is null or fgcreditortype = ' ') and (fgcreditor is null or fgcreditor=0)", paramList);
            }
        }
        return 1;
    }

    private void updateGcSql(Row gcRow, String creditorText, Long fid) {
        String creditorType = gcRow.getString("fbankrole");
        Long creditorId = gcRow.getLong("ffinorginfoid");
        Long guaranteeContractId = gcRow.getLong("fguaranteecontractid");
        BigDecimal gRatio = gcRow.getBigDecimal("fgratio");
        BigDecimal bizAmount = gcRow.getBigDecimal("fshareamount");
        BigDecimal gAmount = bizAmount.multiply(gRatio).divide(Constants.ONE_HUNDRED);
        String gcQuerySql = "select tcig.fdetailid from t_cfm_initbill_gmentry tcig,t_cfm_initbill_entry tcie where tcig.fentryid=tcie.fentryid and tcie.fid=" + fid + " and fgcontract=" + guaranteeContractId + " and (fgcreditortype is null or fgcreditortype = ' ' or fgcreditortype = '" + creditorType + "') and (fgcreditor is null or fgcreditor = 0 or fgcreditor = " + creditorId + ")";
        DataSet gcData = DB.queryDataSet((String)"InitGuaranteeUseUpgradeService", (DBRoute)DBRouteConst.TMC, (String)gcQuerySql);
        if (!gcData.isEmpty()) {
            Row gcDatum = gcData.copy().next();
            Object[] params = new Object[]{gRatio, gAmount, creditorType, creditorId, creditorText, gcDatum.getLong("fdetailid")};
            DB.execute((DBRoute)DBRouteConst.TMC, (String)"update t_cfm_initbill_gmentry set fgratio=?, fgamount=?, fgcreditortype=?, fgcreditor=?, fgcreditortext=? where fdetailid=?", (Object[])params);
        } else {
            String querySql = "select tcig.fentryid,tcig.fseq,tcig.fgcontract,tcig.fgcreditguarantee,tcig.fgcontractcurrency,tcig.fgcontractamount,tcig.fgexchrate,tcig.fgcomment,tcig.fgautoshow from t_cfm_initbill_gmentry tcig,t_cfm_initbill_entry tcie where tcig.fentryid=tcie.fentryid and tcie.fid=" + gcRow.getLong("fid") + " and fgcontract=" + guaranteeContractId;
            DataSet queryData = DB.queryDataSet((String)"InitGuaranteeUseUpgradeService", (DBRoute)DBRouteConst.TMC, (String)querySql);
            Long id = DB.genLongId((String)"t_cfm_initbill_gmentry");
            if (queryData.isEmpty()) {
                return;
            }
            Row queryDatum = queryData.copy().next();
            String insertSql = "insert into t_cfm_initbill_gmentry(fdetailid,fentryid,fseq,fgcontract,fgcreditguarantee,fgamount,fgratio,fgcontractcurrency,fgcontractamount,fgexchrate,fgcomment,fgautoshow,fgcreditortype,fgcreditor,fgcreditortext) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            Object[] params = new Object[]{id, queryDatum.getLong("fentryid"), queryDatum.getInteger("fseq") + 1, guaranteeContractId, queryDatum.getString("fgcreditguarantee"), gAmount, gRatio, queryDatum.getLong("fgcontractcurrency"), queryDatum.getBigDecimal("fgcontractamount"), queryDatum.getBigDecimal("fgexchrate"), queryDatum.getString("fgcomment"), queryDatum.getString("fgautoshow"), creditorType, creditorId, creditorText};
            DB.execute((DBRoute)DBRouteConst.TMC, (String)insertSql, (Object[])params);
        }
    }

    private void updateGcSql(Row gcRow, Long fEntryId) {
        String creditorType = gcRow.getString("finvestortype");
        Long creditorId = gcRow.getLong("finvestorid");
        Long guaranteeContractId = gcRow.getLong("fguaranteecontractid");
        BigDecimal bizAmount = gcRow.getBigDecimal("finvestamount");
        String creditorText = gcRow.getString("finvestorname");
        BigDecimal gRatio = gcRow.getBigDecimal("fgratio");
        BigDecimal gAmount = bizAmount.multiply(gRatio).divide(Constants.ONE_HUNDRED);
        String gcQuerySql = "select tcig.fdetailid from t_cfm_initbill_gmentry tcig,t_cfm_initbill_entry tcie where tcig.fentryid=tcie.fentryid and tcie.fentryId=" + fEntryId + " and fgcontract=" + guaranteeContractId + " and (fgcreditortype is null or fgcreditortype = ' ' or fgcreditortype = '" + creditorType + "') and (fgcreditor is null or fgcreditor = 0 or fgcreditor = " + creditorId + ")";
        DataSet gcData = DB.queryDataSet((String)"InitGuaranteeUseUpgradeService", (DBRoute)DBRouteConst.TMC, (String)gcQuerySql);
        if (!gcData.isEmpty()) {
            Row gcDatum = gcData.copy().next();
            Object[] params = new Object[]{gRatio, gAmount, creditorType, creditorId, creditorText, gcDatum.getLong("fdetailid")};
            DB.execute((DBRoute)DBRouteConst.TMC, (String)"update t_cfm_initbill_gmentry set fgratio=?, fgamount=?, fgcreditortype=?, fgcreditor=?, fgcreditortext=? where fdetailid=?", (Object[])params);
        } else {
            String querySql = "select fentryid,fseq,fgcontract,fgcreditguarantee,fgcontractcurrency,fgcontractamount,fgexchrate,fgcomment,fgautoshow from t_cfm_initbill_gmentry where fentryid=" + gcRow.getLong("fentryid") + " and fgcontract=" + guaranteeContractId;
            DataSet queryData = DB.queryDataSet((String)"InitGuaranteeUseUpgradeService", (DBRoute)DBRouteConst.TMC, (String)querySql);
            Long id = DB.genLongId((String)"t_cfm_initbill_gmentry");
            if (queryData.isEmpty()) {
                return;
            }
            Row queryDatum = queryData.copy().next();
            String insertSql = "insert into t_cfm_initbill_gmentry(fdetailid,fentryid,fseq,fgcontract,fgcreditguarantee,fgamount,fgratio,fgcontractcurrency,fgcontractamount,fgexchrate,fgcomment,fgautoshow,fgcreditortype,fgcreditor,fgcreditortext) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
            Object[] params = new Object[]{id, queryDatum.getLong("fentryid"), queryDatum.getInteger("fseq") + 1, guaranteeContractId, queryDatum.getString("fgcreditguarantee"), gAmount, gRatio, queryDatum.getLong("fgcontractcurrency"), queryDatum.getBigDecimal("fgcontractamount"), queryDatum.getBigDecimal("fgexchrate"), queryDatum.getString("fgcomment"), queryDatum.getString("fgautoshow"), creditorType, creditorId, creditorText};
            DB.execute((DBRoute)DBRouteConst.TMC, (String)insertSql, (Object[])params);
        }
    }
}

