/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.interestbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.InterestServiceHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(InterestBillAuditService.class);

    public List<String> getSelector() {
        List ias = super.getSelector();
        ias.addAll(InterestServiceHelper.getAuditSelector());
        ias.add("creditortype");
        ias.add("settlestatus");
        ias.add("instbillctg");
        ias.add("sourcebillid");
        ias.add("datasource");
        ias.add("creditortype");
        ias.add("creditorg");
        ias.add("org");
        ias.add("loanbillno");
        ias.add("combineinst");
        ias.add("repaymentid");
        ias.add("isrelcash");
        ias.add("eassrcid");
        ias.add("bankcheckflag");
        ias.add("convertintamt");
        return ias;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> autoConfirmBills = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject intBill : dataEntities) {
            intBill.set("confirmstatus", (Object)ConfirmStatusEnum.WAITCONFIRM.getValue());
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(intBill.getString("creditortype"))) {
                String entityName = intBill.getDataEntityType().getName();
                if ("cfm_interestbill".equals(entityName)) {
                    intBill.set("settlestatus", (Object)SettleCenterStatusEnum.SUBMIT.getValue());
                    continue;
                }
                intBill.set("settlestatus", (Object)SettleCenterStatusEnum.ACCEPT.getValue());
                continue;
            }
            if (!this.isAutoConfirm(intBill)) continue;
            autoConfirmBills.add(intBill);
        }
        if (!autoConfirmBills.isEmpty()) {
            BusinessHelper.fillConfirmInfo(autoConfirmBills);
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        List interestBills = Arrays.stream(dataEntities).filter(this::isAutoConfirmBill).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(interestBills)) {
            Set loanBillIds = interestBills.stream().map(d -> d.getLong("sourcebillid")).collect(Collectors.toSet());
            LoanWriteBackHelper.writeBack(new ArrayList(loanBillIds), (LoanWBTypeEnum)LoanWBTypeEnum.INTEREST);
            String settleInfoStr = (String)this.getOperationVariable().get("settleinfo");
            for (DynamicObject intBill : interestBills) {
                LoanBillHelper.autoWriteOff((DynamicObject)intBill, (String)settleInfoStr);
            }
        }
    }

    private boolean isAutoConfirmBill(DynamicObject intBill) {
        return !CreditorTypeEnum.SETTLECENTER.getValue().equals(intBill.getString("creditortype")) && this.isAutoConfirm(intBill);
    }

    private boolean isAutoConfirm(DynamicObject intBill) {
        String repayAutoConfirm = (String)this.getOperationVariable().get("repayAutoConfirm");
        logger.info("repayAutoConfirm:" + repayAutoConfirm);
        String instBillCtg = intBill.getString("instbillctg");
        boolean autoConfirm = InterestbillctgEnum.isPayinterst((String)instBillCtg) && BusinessHelper.isAutoConfirm((DynamicObject)intBill);
        autoConfirm = autoConfirm || InterestbillctgEnum.isPayprinandinte((String)instBillCtg) && "true".equals(repayAutoConfirm);
        autoConfirm = autoConfirm || InterestbillctgEnum.isPayprinandinte((String)instBillCtg) && EmptyUtil.isEmpty((String)repayAutoConfirm) && BusinessHelper.isAutoConfirm((DynamicObject)intBill);
        autoConfirm = autoConfirm || LoanBillHelper.isPrePayint((String)instBillCtg);
        return autoConfirm;
    }
}

