/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.interestbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmAttachmentHelper;
import kd.tmc.cfm.common.helper.InterestServiceHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class InterestBillConfirmService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(InterestBillConfirmService.class);

    public List<String> getSelector() {
        List ias = super.getSelector();
        ias.addAll(InterestServiceHelper.getAuditSelector());
        ias.add("settlestatus");
        ias.add("creditortype");
        ias.add("instbillctg");
        ias.add("sourcebillid");
        ias.add("datasource");
        ias.add("creditortype");
        ias.add("creditorg");
        ias.add("org");
        ias.add("loanbillno");
        ias.add("calcoverint");
        ias.add("convertintamt");
        return ias;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject interestEntity : dataEntities) {
            logger.info("interestEntity \u786e\u8ba4:" + interestEntity.getString("billno"));
            interestEntity.set("settlestatus", (Object)SettleCenterStatusEnum.ACCEPT.getValue());
        }
        BusinessHelper.fillConfirmInfo(Arrays.asList(dataEntities));
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        Set loanBillIds = Arrays.stream(dataEntities).map(d -> d.getLong("sourcebillid")).collect(Collectors.toSet());
        LoanWriteBackHelper.writeBack(new ArrayList(loanBillIds), (LoanWBTypeEnum)LoanWBTypeEnum.INTEREST);
        String settleInfoStr = (String)this.getOperationVariable().get("settleinfo");
        for (DynamicObject interestEntity : dataEntities) {
            LoanBillHelper.autoWriteOff((DynamicObject)interestEntity, (String)settleInfoStr);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        CfmAttachmentHelper.dealAttachment((DynamicObject[])dataEntities);
    }
}

