/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.interestbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class InterestBillUnAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(InterestBillUnAuditService.class);

    public List<String> getSelector() {
        List ias = super.getSelector();
        ias.add("sourcebillid");
        ias.add("billno");
        ias.add("billstatus");
        ias.add("repaymentid");
        ias.add("actualinstamt");
        ias.add("endinstdate");
        ias.add("instbillctg");
        ias.add("confirmstatus");
        ias.add("lendernature");
        ias.add("confirmer");
        ias.add("confirmtime");
        ias.add("creditortype");
        ias.add("datasource");
        ias.add("settlestatus");
        ias.add("datasource");
        ias.add("creditortype");
        ias.add("debtortype");
        ias.add("creditorg");
        ias.add("org");
        ias.add("writeoffstatus");
        ias.add("bankcheckflag");
        ias.add("bitbackinfo");
        ias.add("calcoverint");
        ias.add("isrelcash");
        ias.add("eassrcid");
        return ias;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject interestEntity : dataEntities) {
            if (EmptyUtil.isEmpty((String)((String)this.getOperationVariable().get("back")))) {
                BusinessHelper.clearConfirmInfoForUnAudit((DynamicObject)interestEntity);
            } else {
                BusinessHelper.clearConfirmInfoForBack((DynamicObject)interestEntity);
            }
            String creditorType = interestEntity.getString("creditortype");
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
                String entityName = interestEntity.getDataEntityType().getName();
                if ("cfm_interestbill".equals(entityName)) {
                    interestEntity.set("settlestatus", (Object)"");
                    interestEntity.set("bitbackinfo", null);
                } else {
                    interestEntity.set("settlestatus", (Object)SettleCenterStatusEnum.ADDNEW.getValue());
                    interestEntity.set("bankcheckflag", null);
                }
            }
            this.autoUnWriteOff(interestEntity);
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        List interestBills = Arrays.stream(dataEntities).filter(d -> BusinessHelper.isOutGroup((DynamicObject)d) || LoanBillHelper.isPrePayint((String)d.getString("instbillctg"))).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(interestBills)) {
            Set loanBillIds = interestBills.stream().map(d -> d.getLong("sourcebillid")).collect(Collectors.toSet());
            LoanWriteBackHelper.writeBack(new ArrayList(loanBillIds), (LoanWBTypeEnum)LoanWBTypeEnum.INTEREST);
        }
    }

    private void autoUnWriteOff(DynamicObject intBill) {
        String writeOffStatus = intBill.getString("writeoffstatus");
        if (StringUtils.equals((CharSequence)WriteOffStatusEnum.WRITEOFF.getValue(), (CharSequence)writeOffStatus)) {
            String entityName = intBill.getDynamicObjectType().getName();
            OperateOption option = OperateOption.create();
            option.setVariableValue("back", "back");
            TmcOperateServiceHelper.execOperate((String)"unwriteoff", (String)entityName, (Object[])new Object[]{intBill.getPkValue()}, (OperateOption)option);
        }
    }
}

