/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.interestbill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.constant.CfmBizConstant;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.cfm.common.helper.IntBillWriteOffHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillWriteOffService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(InterestBillWriteOffService.class);

    public List<String> getSelector() {
        List ias = super.getSelector();
        ias.add("sourcebillid");
        ias.add("billno");
        ias.add("billstatus");
        ias.add("repaymentid");
        ias.add("actualinstamt");
        ias.add("startinstdate");
        ias.add("bizdate");
        ias.add("bechargeinstamt");
        ias.add("afterchargeinstamt");
        ias.add("endinstdate");
        ias.add("confirmstatus");
        ias.add("org");
        ias.add("datasource");
        ias.add("writeoffdate");
        ias.add("loanbillno");
        ias.add("batchnoid");
        ias.add("thischargeinstamt");
        ias.add("nowriteoffamt");
        ias.add("convertintamt");
        return ias;
    }

    public void process(DynamicObject[] interestBills) throws KDException {
        Map<String, List<DynamicObject>> groupByLoanNo = Arrays.stream(interestBills).collect(Collectors.groupingBy(v -> v.getString("loanbillno")));
        for (Map.Entry<String, List<DynamicObject>> entry : groupByLoanNo.entrySet()) {
            List<DynamicObject> g = entry.getValue();
            String loanBillNo = entry.getKey();
            this.autoWriteOffForWard(loanBillNo);
            boolean isAllWriteOff = this.isAllWriteOff(loanBillNo);
            this.writeOff(g.toArray(new DynamicObject[g.size()]), isAllWriteOff);
        }
    }

    private boolean isAllWriteOff(String loanBillNo) {
        String selects = "id, drawtype, endpreinstdate, lastrepaydate, org, creditorg, creditortype, datasource";
        QFilter filter = new QFilter("billno", "=", (Object)loanBillNo);
        DynamicObject[] loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)selects, (QFilter[])filter.toArray());
        if (loanBills.length == 0) {
            return false;
        }
        DynamicObject loanBill = loanBills[0];
        Date endPreInstDate = loanBill.getDate("endpreinstdate");
        Date lastRepayDate = loanBill.getDate("lastrepaydate");
        if (lastRepayDate == null || endPreInstDate == null) {
            return false;
        }
        lastRepayDate = DateUtils.getDataFormat((Date)lastRepayDate, (boolean)true);
        boolean isLastPreIntEndDate = IntBillWriteOffHelper.isLastPreIntEndDate((DynamicObject)loanBill);
        boolean isCloseout = DrawTypeEnum.isCloseout((String)loanBill.getString("drawtype"));
        boolean isAllPreint = DateUtils.getNextDay((Date)endPreInstDate, (int)1).compareTo(lastRepayDate) >= 0;
        boolean isLastWriteOff = this.isLastWriteOff(loanBillNo);
        return isLastPreIntEndDate && isCloseout && isAllPreint && isLastWriteOff;
    }

    private boolean isLastWriteOff(String loanBillNo) {
        QFilter filter = new QFilter("loanbillno", "=", (Object)loanBillNo);
        filter.and("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
        DynamicObjectCollection intBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"id", (QFilter[])filter.toArray());
        return intBills.size() == 1;
    }

    private void autoWriteOffForWard(String loanBillNo) {
        QFilter filter = new QFilter("loanbillno", "=", (Object)loanBillNo);
        filter.and("writeoffstatus", "=", (Object)WriteOffStatusEnum.WRITEOFF.getValue());
        filter.and(QFilter.of((String)"convertintamt > thischargeinstamt", (Object[])new Object[0]));
        Object[] instBills = TmcDataServiceHelper.load((String)"cfm_interestbill", (String)"writeoffdate,convertintamt,loanbillno,actualinstamt,writeoffstatus,writeoffdate,batchnoid,bechargeinstamt,thischargeinstamt,afterchargeinstamt", (QFilter[])filter.toArray(), (String)"startinstdate asc");
        if (EmptyUtil.isEmpty((Object[])instBills)) {
            return;
        }
        filter = new QFilter("loanbillno", "=", (Object)loanBillNo);
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue());
        filter.and("writeoffstatus", "in", (Object)new String[]{WriteOffStatusEnum.NO_WRITEOFF.getValue(), WriteOffStatusEnum.PART_WRITEOFF.getValue()});
        Object[] preInstBills = TmcDataServiceHelper.load((String)"cfm_preinterestbill", (String)"billno,currency,operatetype,prestartdate,nowriteoffamt,writeoffstatus,writeoffamt,actpreinstamt,beforewriteoffamt", (QFilter[])filter.toArray(), (String)"prestartdate asc");
        if (EmptyUtil.isEmpty((Object[])preInstBills)) {
            return;
        }
        List<DynamicObject> preIntBills = Arrays.stream(preInstBills).sorted(Comparator.comparing(o -> o.getDate("prestartdate"))).collect(Collectors.toList());
        for (Object instBill : instBills) {
            BigDecimal thisChargeInstAmt = instBill.getBigDecimal("thischargeinstamt");
            BigDecimal convertIntAmt = instBill.getBigDecimal("convertintamt");
            BigDecimal noWriteOffAmt = convertIntAmt.subtract(thisChargeInstAmt);
            BigDecimal totalPreIntBillAmt = IntBillWriteOffHelper.getTotalPreIntBillAmt((DynamicObject[])preInstBills);
            BigDecimal writeOffAmt = noWriteOffAmt.min(totalPreIntBillAmt);
            BigDecimal actPreInstAmt = preIntBills.stream().map(v -> v.getBigDecimal("actpreinstamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            instBill.set("bechargeinstamt", (Object)actPreInstAmt);
            instBill.set("thischargeinstamt", (Object)thisChargeInstAmt.add(writeOffAmt));
            instBill.set("writeoffdate", (Object)DateUtils.getCurrentDate());
            BigDecimal afterChargeInstAmt = actPreInstAmt.subtract(thisChargeInstAmt.add(writeOffAmt));
            instBill.set("afterchargeinstamt", (Object)(afterChargeInstAmt.compareTo(BigDecimal.ZERO) > 0 ? afterChargeInstAmt : BigDecimal.ZERO));
            long batchNoId = instBill.getLong("batchnoid");
            IntBillWriteOffHelper.writeOff((DynamicObject[])preIntBills.toArray(new DynamicObject[0]), (BigDecimal)writeOffAmt, (long)batchNoId, (boolean)false);
            preIntBills = preIntBills.stream().filter(v -> !WriteOffStatusEnum.isCompleteWriteOff((String)v.getString("writeoffstatus"))).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(preIntBills)) break;
        }
        SaveServiceHelper.update((DynamicObject[])instBills);
        SaveServiceHelper.update((DynamicObject[])preInstBills);
    }

    private void writeOff(DynamicObject[] interestBills, boolean isAllWriteOff) {
        BigDecimal writeOffAmt = this.getOperationVariable().containsKey(CfmBizConstant.PREINTBILLIDS) ? new BigDecimal((String)this.getOperationVariable().get("writeoffamt")) : Arrays.stream(interestBills).map(v -> v.getBigDecimal("convertintamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        List preIntBillIds = null;
        if (this.getOperationVariable().containsKey(CfmBizConstant.PREINTBILLIDS)) {
            preIntBillIds = (List)JSON.parseObject((String)((String)this.getOperationVariable().get(CfmBizConstant.PREINTBILLIDS)), List.class);
        }
        Object[] preInstBills = IntBillWriteOffHelper.getPreIntBills((DynamicObject[])interestBills, preIntBillIds);
        BigDecimal noWriteOffAmt = IntBillWriteOffHelper.getTotalPreIntBillAmt((DynamicObject[])preInstBills);
        List<DynamicObject> preIntBills = Arrays.stream(preInstBills).sorted(Comparator.comparing(o -> o.getDate("prestartdate"))).collect(Collectors.toList());
        List interestBillList = Arrays.stream(interestBills).sorted(Comparator.comparing(o -> o.getDate("startinstdate"))).collect(Collectors.toList());
        for (DynamicObject interestBill : interestBillList) {
            long batchNoId = DBServiceHelper.genGlobalLongId();
            interestBill.set("writeoffstatus", (Object)WriteOffStatusEnum.WRITEOFF.getValue());
            interestBill.set("writeoffdate", (Object)DateUtils.getCurrentDate());
            interestBill.set("batchnoid", (Object)batchNoId);
            interestBill.set("bechargeinstamt", (Object)noWriteOffAmt);
            BigDecimal intamt = interestBill.getBigDecimal("convertintamt");
            intamt = EmptyUtil.isNoEmpty((BigDecimal)intamt) ? intamt : interestBill.getBigDecimal("actualinstamt");
            BigDecimal thisChargeInstAmt = writeOffAmt.min(noWriteOffAmt).min(intamt);
            interestBill.set("thischargeinstamt", (Object)thisChargeInstAmt);
            BigDecimal afterChargeInstAmt = noWriteOffAmt.subtract(thisChargeInstAmt);
            interestBill.set("afterchargeinstamt", (Object)(afterChargeInstAmt.compareTo(BigDecimal.ZERO) > 0 ? afterChargeInstAmt : BigDecimal.ZERO));
            IntBillWriteOffHelper.writeOff((DynamicObject[])preIntBills.toArray(new DynamicObject[0]), (BigDecimal)thisChargeInstAmt, (long)batchNoId, (boolean)isAllWriteOff);
            writeOffAmt = writeOffAmt.subtract(thisChargeInstAmt);
            noWriteOffAmt = noWriteOffAmt.subtract(thisChargeInstAmt);
            preIntBills = preIntBills.stream().filter(v -> !WriteOffStatusEnum.isCompleteWriteOff((String)v.getString("writeoffstatus"))).collect(Collectors.toList());
            if (writeOffAmt.compareTo(BigDecimal.ZERO) > 0 && noWriteOffAmt.compareTo(BigDecimal.ZERO) > 0 && !EmptyUtil.isEmpty(preIntBills)) continue;
            break;
        }
        if (EmptyUtil.isNoEmpty((Object[])interestBills) && EmptyUtil.isNoEmpty((Object[])preInstBills)) {
            SaveServiceHelper.save((DynamicObject[])interestBills);
            SaveServiceHelper.save((DynamicObject[])preInstBills);
        }
    }
}

