/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.interestbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.bean.InterestCalcRequest;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestCalService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List ias = super.getSelector();
        ias.add("sourcebillid");
        ias.add("predictinstamt");
        ias.add("actualinstamt");
        ias.add("endinstdate");
        ias.add("entrys");
        ias.add("billstatus");
        ias.add("entrys.seq");
        ias.add("inststartdate");
        ias.add("instenddate");
        ias.add("instdays");
        ias.add("instprincipalamt");
        ias.add("rate");
        ias.add("ratetrandays");
        ias.add("benchmarkrate");
        ias.add("benchmarkint");
        ias.add("instamt");
        ias.add("floatrate");
        ias.add("floatint");
        ias.add("totalint");
        ias.add("lasttotalint");
        ias.add("curtotalint");
        ias.add("confirmratedate");
        ias.add("lookdays");
        ias.add("instctg");
        ias.add("datasource");
        ias.add("calcoverint");
        ias.add("isinit");
        ias.add("convertrate");
        ias.add("convertintamt");
        return ias;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Set loanBillIds = Arrays.stream(dataEntities).map(d -> d.getLong("sourcebillid")).collect(Collectors.toSet());
        Map loanBillMap = TmcDataServiceHelper.loadDataAndMapById((String)"cfm_loanbill", loanBillIds);
        for (DynamicObject interestEntity : dataEntities) {
            Long sourcebillid = interestEntity.getLong("sourcebillid");
            Date beginDate = interestEntity.getDate("startinstdate");
            Date endDate = interestEntity.getDate("bizdate");
            DynamicObject loanBill = (DynamicObject)loanBillMap.get(sourcebillid);
            InterestCalcRequest request = InterestCalcRequest.build((DynamicObject)loanBill, (Date)beginDate, (Date)(endDate = InterestCalcHelper.getEndIntDate((DynamicObject)loanBill, (Date)endDate)), (boolean)false).setCalcOverInt(interestEntity.getBoolean("calcoverint"));
            IntBillExtInfo intBill = InterestCalcHelper.callInt((InterestCalcRequest)request);
            if (!EmptyUtil.isNoEmpty((Object)intBill) || !EmptyUtil.isNoEmpty((Object)intBill.getDetails())) continue;
            interestEntity.set("predictinstamt", (Object)intBill.getAmount());
            if (EmptyUtil.isEmpty((BigDecimal)interestEntity.getBigDecimal("actualinstamt"))) {
                interestEntity.set("actualinstamt", (Object)intBill.getAmount());
                BigDecimal convertRate = interestEntity.getBigDecimal("convertrate");
                convertRate = convertRate.compareTo(BigDecimal.ZERO) > 0 ? convertRate : BigDecimal.ONE;
                interestEntity.set("convertintamt", (Object)intBill.getAmount().multiply(convertRate));
            }
            DynamicObjectCollection entrys = interestEntity.getDynamicObjectCollection("entrys");
            InterestCalcHelper.addDetail((DynamicObjectCollection)entrys, (List)intBill.getExtDetails(), (DynamicObject)loanBill);
            if (interestEntity.containsProperty("intyearrate")) {
                interestEntity.set("intyearrate", (Object)intBill.calcIntYearRate(interestEntity.getBigDecimal("actualinstamt")));
            }
            if (!interestEntity.containsProperty("preintyearrate")) continue;
            interestEntity.set("preintyearrate", (Object)intBill.calcIntYearRate(interestEntity.getBigDecimal("predictinstamt")));
        }
    }
}

