/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.interestbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.bean.InterestCalcRequest;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.cfm.common.service.calcint.LoanBillRepaymentPlanHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestReCalService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List ias = super.getSelector();
        ias.add("sourcebillid");
        ias.add("predictinstamt");
        ias.add("actualinstamt");
        ias.add("endinstdate");
        ias.add("entrys");
        ias.add("billstatus");
        ias.add("entrys.seq");
        ias.add("inststartdate");
        ias.add("instenddate");
        ias.add("instdays");
        ias.add("instprincipalamt");
        ias.add("rate");
        ias.add("ratetrandays");
        ias.add("instamt");
        ias.add("instctg");
        ias.add("datasource");
        ias.add("calcoverint");
        return ias;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject interestEntity : dataEntities) {
            Long sourcebillid = interestEntity.getLong("sourcebillid");
            Date beginDate = interestEntity.getDate("startinstdate");
            Date endDate = interestEntity.getDate("bizdate");
            DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)sourcebillid, (String)"cfm_loanbill");
            InterestCalcRequest request = InterestCalcRequest.build((DynamicObject)loanBill, (Date)beginDate, (Date)endDate, (boolean)false).setCalcOverInt(interestEntity.getBoolean("calcoverint"));
            request.setRepayList(LoanBillRepaymentPlanHelper.getAllRepayList((Long)loanBill.getLong("id"), (Date)endDate));
            IntBillExtInfo intBill = InterestCalcHelper.callInt((InterestCalcRequest)request);
            if (!EmptyUtil.isNoEmpty((Object)intBill) || !EmptyUtil.isNoEmpty((Object)intBill.getDetails())) continue;
            interestEntity.set("predictinstamt", (Object)intBill.getAmount());
            if (EmptyUtil.isEmpty((BigDecimal)interestEntity.getBigDecimal("actualinstamt"))) {
                interestEntity.set("actualinstamt", (Object)intBill.getAmount());
            }
            DynamicObjectCollection entrys = interestEntity.getDynamicObjectCollection("entrys");
            InterestCalcHelper.addDetail((DynamicObjectCollection)entrys, (List)intBill.getExtDetails(), (DynamicObject)loanBill);
            if (interestEntity.containsProperty("intyearrate")) {
                interestEntity.set("intyearrate", (Object)intBill.calcIntYearRate(interestEntity.getBigDecimal("actualinstamt")));
            }
            if (!interestEntity.containsProperty("preintyearrate")) continue;
            interestEntity.set("preintyearrate", (Object)intBill.calcIntYearRate(interestEntity.getBigDecimal("predictinstamt")));
        }
    }
}

