/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.interestbill;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class LoanIntBillBatchAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("loanbillid");
        selector.add("bizdate");
        selector.add("interestamt");
        selector.add("intdetailnum");
        selector.add("intcomment");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("intbillid");
        selector.add("bizdealno");
        selector.add("settlecenter");
        selector.add("org");
        selector.add("company");
        selector.add("datasource");
        selector.add("loantype");
        selector.add("status");
        selector.add("actualinstamt");
        selector.add("payee");
        selector.add("payeetype");
        selector.add("payeetext");
        selector.add("payeebank");
        selector.add("payeeaccttext");
        selector.add("e_isrelcash");
        selector.add("businessdate");
        selector.add("creator");
        selector.add("calcoverint");
        selector.add("currency");
        selector.add("loancurrency");
        selector.add("convertrate");
        selector.add("convertintamt");
        selector.add("accountbank");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String datasource = dataEntities[0].getString("datasource");
        if (StringUtils.equals((CharSequence)datasource, (CharSequence)"ifm")) {
            this.dealIfmBatchInt(dataEntities);
        } else {
            this.dealCfmBatchInt(dataEntities);
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        for (DynamicObject batchIntBill : dataEntities) {
            LoanIntBillBatchAuditService.writeBackIfmBatchBill(batchIntBill);
        }
    }

    private void dealCfmBatchInt(DynamicObject[] dataEntities) {
        for (DynamicObject batchIntBill : dataEntities) {
            String dataSource = batchIntBill.getString("datasource");
            Date businessDate = batchIntBill.getDate("businessdate");
            Pair intBotpPair = BatchIntBillHelper.getBatchIntBotpPair((String)dataSource);
            DynamicObjectCollection batchInEntrys = batchIntBill.getDynamicObjectCollection("entry");
            Set loanBillIds = batchInEntrys.stream().map(v -> v.getLong("loanbillid")).collect(Collectors.toSet());
            Map loanBillMap = LoanBillRepository.getLoanBillByIds(loanBillIds, (String)"id,creditortype");
            List intBillIds = batchInEntrys.stream().map(v -> v.getLong("intbillid")).collect(Collectors.toList());
            String entityName = (String)intBotpPair.getRight();
            Map interestBillMap = TmcDataServiceHelper.loadDataAndMapById((String)entityName, intBillIds);
            for (DynamicObject batchIntEntry : batchInEntrys) {
                DynamicObject loanBill = (DynamicObject)loanBillMap.get(batchIntEntry.getLong("loanbillid"));
                DynamicObject interestBill = (DynamicObject)interestBillMap.get(batchIntEntry.getLong("intbillid"));
                String creditorType = loanBill.getString("creditortype");
                if (StringUtils.equals((CharSequence)CreditorTypeEnum.SETTLECENTER.getValue(), (CharSequence)creditorType)) {
                    interestBill.set("confirmstatus", (Object)ConfirmStatusEnum.WAITCONFIRM.getValue());
                } else {
                    interestBill.set("confirmstatus", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
                    interestBill.set("confirmer", (Object)RequestContext.get().getCurrUserId());
                }
                this.setInterestBill(batchIntEntry, interestBill, businessDate);
            }
            this.auditInterestBill(entityName, interestBillMap.values().toArray(new DynamicObject[0]));
        }
    }

    private void auditInterestBill(String entityName, DynamicObject[] targetBills) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        try {
            TmcOperateServiceHelper.execOperate((String)"audit", (String)entityName, (DynamicObject[])targetBills, (OperateOption)operateOption, (boolean)false);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5229\u606f\u5355\u5ba1\u6838\u5931\u8d25\uff1a%s", (String)"LoanIntBillBatchSaveService_1", (String)"tmc-cfm-business", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void dealIfmBatchInt(DynamicObject[] dataEntities) {
        for (DynamicObject batchIntBill : dataEntities) {
            Date businessDate = batchIntBill.getDate("businessdate");
            DynamicObjectCollection batchInEntrys = batchIntBill.getDynamicObjectCollection("entry");
            List intBillIds = batchInEntrys.stream().map(v -> v.getLong("intbillid")).collect(Collectors.toList());
            Map interestBillMap = TmcDataServiceHelper.loadDataAndMapById((String)"ifm_interestbill", intBillIds);
            for (DynamicObject batchIntEntry : batchInEntrys) {
                DynamicObject interestBill = (DynamicObject)interestBillMap.get(batchIntEntry.getLong("intbillid"));
                interestBill.set("confirmstatus", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
                this.setInterestBill(batchIntEntry, interestBill, businessDate);
            }
            this.auditInterestBill("ifm_interestbill", interestBillMap.values().toArray(new DynamicObject[0]));
        }
    }

    private static void writeBackIfmBatchBill(DynamicObject batchIntBill) {
        DynamicObjectCollection batchInEntrys = batchIntBill.getDynamicObjectCollection("entry");
        for (DynamicObject batchIntEntry : batchInEntrys) {
            Object[] prebatchIntBills;
            QFilter preFilter = new QFilter("sourcebillid", "=", (Object)batchIntEntry.getLong("intbillid"));
            DynamicObjectCollection preInstBills = QueryServiceHelper.query((String)"cfm_preinterestbill", (String)"id,billno", (QFilter[])preFilter.toArray());
            if (EmptyUtil.isEmpty((DynamicObjectCollection)preInstBills)) continue;
            QFilter filter = new QFilter("entry.intbillid", "in", (Object)preInstBills.stream().map(d -> d.get("id")).toArray());
            for (Object prebatchIntBill : prebatchIntBills = TmcDataServiceHelper.load((String)"ifm_intbill_batch_pre", (String)"id,entry,entry.intbillid,entry.isinterest,entry.intsetnum", (QFilter[])filter.toArray())) {
                for (DynamicObject entry : prebatchIntBill.getDynamicObjectCollection("entry")) {
                    if (entry.getLong("intbillid") != ((DynamicObject)preInstBills.get(0)).getLong("id")) continue;
                    entry.set("isinterest", (Object)Boolean.TRUE);
                    entry.set("intsetnum", (Object)batchIntBill.getString("billno"));
                }
            }
            if (!EmptyUtil.isNoEmpty((Object[])prebatchIntBills)) continue;
            TmcDataServiceHelper.save((DynamicObject[])prebatchIntBills);
        }
    }

    private void setInterestBill(DynamicObject batchIntEntry, DynamicObject interestBill, Date businessDate) {
        interestBill.set("businessdate", (Object)businessDate);
        interestBill.set("currency", (Object)batchIntEntry.getDynamicObject("currency"));
        interestBill.set("actualinstamt", (Object)batchIntEntry.getBigDecimal("actualinstamt"));
        interestBill.set("convertrate", (Object)batchIntEntry.getBigDecimal("convertrate"));
        interestBill.set("convertintamt", (Object)batchIntEntry.getBigDecimal("convertintamt"));
        interestBill.set("instbankacct", (Object)batchIntEntry.getDynamicObject("accountbank"));
    }
}

