/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.interestbill;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanIntBillBatchUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("intbillid");
        selector.add("loanbillid");
        selector.add("interestamt");
        selector.add("intdetailnum");
        selector.add("intcomment");
        selector.add("datasource");
        selector.add("status");
        selector.add("loantype");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject batchIntBill : dataEntities) {
            this.dealBatchPreBill(batchIntBill);
            String dataSource = batchIntBill.getString("datasource");
            String entityName = (String)BatchIntBillHelper.getBatchIntBotpPair((String)dataSource).getRight();
            DynamicObjectCollection batchEntryIntBills = batchIntBill.getDynamicObjectCollection("entry");
            List intBillIds = batchEntryIntBills.stream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong("intbillid"))).map(d -> d.getLong("intbillid")).collect(Collectors.toList());
            DynamicObjectCollection intBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"id,billstatus", (QFilter[])new QFilter("id", "in", intBillIds).toArray());
            Map<String, List<DynamicObject>> intBillMap = intBills.stream().collect(Collectors.groupingBy(d -> d.getString("billstatus")));
            for (Map.Entry<String, List<DynamicObject>> entry : intBillMap.entrySet()) {
                Object[] interestBillIds = entry.getValue().stream().map(d -> d.getLong("id")).toArray();
                if (BillStatusEnum.isAudit((String)entry.getKey())) {
                    TmcOperateServiceHelper.execOperate((String)"unaudit", (String)entityName, (Object[])interestBillIds, (OperateOption)OperateOption.create());
                }
                if (BillStatusEnum.isSubmit((String)entry.getKey())) {
                    TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)entityName, (Object[])interestBillIds, (OperateOption)OperateOption.create());
                }
                TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (Object[])interestBillIds, (OperateOption)OperateOption.create());
            }
            for (DynamicObject batchIntEntry : batchEntryIntBills) {
                batchIntEntry.set("intdetailnum", null);
                batchIntEntry.set("intbillid", null);
                batchIntEntry.set("status", (Object)"");
            }
        }
    }

    private void dealBatchPreBill(DynamicObject batchIntBill) {
        Object[] prebatchIntBills;
        String billno = batchIntBill.getString("billno");
        QFilter filter = new QFilter("entry.intsetnum", "=", (Object)billno);
        for (Object prebatchIntBill : prebatchIntBills = TmcDataServiceHelper.load((String)"ifm_intbill_batch_pre", (String)"id,entry,entry.intbillid,entry.isinterest,entry.intsetnum", (QFilter[])filter.toArray())) {
            for (DynamicObject entry : prebatchIntBill.getDynamicObjectCollection("entry")) {
                if (!entry.getString("intsetnum").equals(billno)) continue;
                entry.set("isinterest", (Object)Boolean.FALSE);
                entry.set("intsetnum", null);
            }
        }
        if (EmptyUtil.isNoEmpty((Object[])prebatchIntBills)) {
            TmcDataServiceHelper.save((DynamicObject[])prebatchIntBills);
        }
    }
}

