/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.interestbill.save;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.cfm.business.opservice.interestbill.save.InterestBillSaveParam;
import kd.tmc.cfm.common.bean.InterestCalcRequest;
import kd.tmc.cfm.common.helper.CfmSecondFieldDevHelper;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.fbp.business.opservice.common.chain.AbstractBusinessBatchHandler;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandleParam;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillSaveByHbfxHandler
extends AbstractBusinessBatchHandler {
    public void doProcess(DynamicObject[] bizBills, BusinessHandleParam param) {
        InterestBillSaveParam inParam = (InterestBillSaveParam)param.getInParam();
        Map<String, String> operationVariable = inParam.getOperationVariable();
        for (DynamicObject interestEntity : bizBills) {
            this.doPayprinandinteBotp(interestEntity, operationVariable);
        }
    }

    public void doBeforeCommit(DynamicObject[] bizBills, BusinessHandleParam param) {
    }

    private void doPayprinandinteBotp(DynamicObject interestEntity, Map<String, String> operationVariable) {
        IntBillExtInfo intBill;
        String loanerAcctBank;
        interestEntity.set("instbillctg", (Object)InterestbillctgEnum.PAYPRINANDINTE.getValue());
        interestEntity.set("combineinst", (Object)operationVariable.get("e_combineinst"));
        interestEntity.set("isrelcash", (Object)operationVariable.get("isrelcash"));
        interestEntity.set("repaymentid", (Object)Long.parseLong(operationVariable.get("repaymentId")));
        Date repaymentDate = DateUtils.stringToDate((String)operationVariable.get("bizDate"), (String)"yyyyMMdd");
        interestEntity.set("bizdate", (Object)repaymentDate);
        interestEntity.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        Date endinstdate = DateUtils.getLastDay((Date)repaymentDate, (int)1);
        if (Boolean.parseBoolean(operationVariable.get("isFinleaseInit"))) {
            interestEntity.set("isinit", (Object)"1");
        }
        interestEntity.set("endinstdate", (Object)endinstdate);
        String accountBank = operationVariable.get("accountbank");
        if (EmptyUtil.isNoEmpty((String)accountBank)) {
            DynamicObject accountBankF7 = TmcDataServiceHelper.loadSingle((Object)Long.parseLong(accountBank), (String)"bd_accountbanks", (String)"id");
            interestEntity.set("instbankacct", (Object)accountBankF7);
        }
        if (EmptyUtil.isNoEmpty((String)(loanerAcctBank = operationVariable.get("loaneracctbank")))) {
            DynamicObject loanerAcctBankF7 = TmcDataServiceHelper.loadSingle((Object)Long.parseLong(loanerAcctBank), (String)"bd_accountbanks", (String)"id");
            interestEntity.set("loaneracctbank", (Object)loanerAcctBankF7);
        }
        interestEntity.set("actualinstamt", (Object)new BigDecimal(operationVariable.get("actinterest")));
        interestEntity.set("convertrate", (Object)BigDecimal.ONE);
        interestEntity.set("convertintamt", (Object)new BigDecimal(operationVariable.get("actinterest")));
        Long sourcebillid = interestEntity.getLong("sourcebillid");
        DynamicObject loandBill = TmcDataServiceHelper.loadSingle((Object)sourcebillid, (String)"cfm_loanbill");
        Date newEndInstDate = loandBill.getDate("endinstdate");
        if (EmptyUtil.isNoEmpty((Object)newEndInstDate)) {
            interestEntity.set("startinstdate", (Object)DateUtils.getNextDay((Date)newEndInstDate, (int)1));
        } else {
            interestEntity.set("startinstdate", (Object)loandBill.getDate("startintdate"));
        }
        CfmSecondFieldDevHelper.dealTarBillSecondDev((DynamicObject)interestEntity, operationVariable);
        this.setInerestSlBankEntry(interestEntity, operationVariable.get("slbankamount"));
        if (RepaymentbillHelper.checkRepayWay((String)loandBill.getString("repaymentway"))) {
            intBill = RepaymentbillHelper.getLoanRepayIntBillInfo((DynamicObject)loandBill, (String)RepaymentbillHelper.getRepaySeqNo((Long)sourcebillid));
        } else {
            BigDecimal notRepayAmt = loandBill.getBigDecimal("notrepayamount");
            String repayAmtParam = operationVariable.get("repayAmt");
            if (EmptyUtil.isNoEmpty((String)repayAmtParam) && new BigDecimal(repayAmtParam).compareTo(notRepayAmt) != 0) {
                Date endDate = interestEntity.getDate("bizdate");
                intBill = InterestCalcHelper.callInt((DynamicObject)loandBill, (Date)endDate, (BigDecimal)new BigDecimal(repayAmtParam));
            } else {
                Date beginDate = interestEntity.getDate("startinstdate");
                Date endDate = interestEntity.getDate("bizdate");
                intBill = InterestCalcHelper.callInt((InterestCalcRequest)InterestCalcRequest.build((DynamicObject)loandBill, (Date)beginDate, (Date)endDate));
            }
        }
        if (intBill == null) {
            return;
        }
        interestEntity.set("predictinstamt", (Object)intBill.getAmount());
        DynamicObjectCollection entrys = interestEntity.getDynamicObjectCollection("entrys");
        if (EmptyUtil.isNoEmpty((Object)intBill.getDetails())) {
            InterestCalcHelper.addDetail((DynamicObjectCollection)entrys, (List)intBill.getExtDetails(), (DynamicObject)loandBill);
        }
    }

    public boolean doFilter(DynamicObject[] dynamicObjects, BusinessHandleParam param) {
        return ((InterestBillSaveParam)param.getInParam()).isByHbfx();
    }

    private void setInerestSlBankEntry(DynamicObject interestEntity, String slBankAmountMap) {
        Map slAmountMap = (Map)JSON.parseObject((String)slBankAmountMap, Map.class);
        if (EmptyUtil.isEmpty((Object)slAmountMap)) {
            return;
        }
        DynamicObjectCollection slBankEntrys = interestEntity.getDynamicObjectCollection("slentryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)slBankEntrys) || EmptyUtil.isEmpty((Object)slAmountMap)) {
            return;
        }
        for (DynamicObject slBankEntry : slBankEntrys) {
            Object value;
            DynamicObject bank = slBankEntry.getDynamicObject("s_bank");
            if (EmptyUtil.isEmpty((DynamicObject)bank) || EmptyUtil.isEmpty(value = slAmountMap.get(bank.getLong("id")))) continue;
            BigDecimal intAmount = BigDecimal.ZERO;
            if (value instanceof Integer) {
                intAmount = new BigDecimal(String.valueOf(value));
            } else if (value instanceof BigDecimal) {
                intAmount = (BigDecimal)value;
            }
            slBankEntry.set("s_repayinst", (Object)intAmount);
            slBankEntry.set("s_convertintamt", (Object)intAmount);
        }
    }
}

