/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.interestbill.save;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cfm.business.opservice.interestbill.save.InterestBillSaveParam;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.opservice.common.chain.AbstractBusinessBatchHandler;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandleParam;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillSaveInitHandler
extends AbstractBusinessBatchHandler {
    public void doProcess(DynamicObject[] bizBills, BusinessHandleParam param) {
        this.doByInitOnProcess(bizBills, (InterestBillSaveParam)param.getInParam());
    }

    private void doByInitOnProcess(DynamicObject[] dataEntities, InterestBillSaveParam param) {
        Map<String, String> operationVariable = param.getOperationVariable();
        for (DynamicObject interest : dataEntities) {
            String dataSource = interest.getString("datasource");
            if (DataSourceEnum.IFM.getValue().equals(dataSource)) {
                interest.set("settlestatus", (Object)SettleCenterStatusEnum.ACCEPT.getValue());
            }
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
            interest.set("confirmstatus", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
            interest.set("confirmer", (Object)RequestContext.get().getUserId());
            interest.set("confirmtime", (Object)DateUtils.getCurrentTime());
            interest.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            interest.set("auditor", (Object)RequestContext.get().getUserId());
            interest.set("auditdate", (Object)DateUtils.getCurrentTime());
            String codeNumber = CodeRuleHelper.generateNumber((String)this.getInstEntityName(interest), (DynamicObject)interest, (String)interest.getDynamicObject("org").getPkValue().toString(), (String)"");
            if (StringUtils.isEmpty((CharSequence)codeNumber)) {
                throw new KDBizException(bizResource.getInbEndinitNoibill());
            }
            interest.set("billno", (Object)codeNumber);
            interest.set("bizdate", (Object)DateUtils.getNextDay((Date)this.getDatePro(operationVariable, "endinstdate"), (int)1));
            interest.set("endinstdate", (Object)this.getDatePro(operationVariable, "endinstdate"));
            interest.set("actualinstamt", (Object)this.getBigDecimalPro(operationVariable, "payinterestamount"));
            interest.set("convertrate", (Object)BigDecimal.ONE);
            interest.set("convertintamt", (Object)this.getBigDecimalPro(operationVariable, "payinterestamount"));
            DynamicObject accountbank = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(operationVariable.get("loadacctbank")), (String)"bd_accountbanks", (String)"id");
            interest.set("instbankacct", (Object)accountbank);
            interest.set("isinit", (Object)"1");
            String instbillctg = operationVariable.get("instbillctg");
            interest.set("instbillctg", (Object)(EmptyUtil.isEmpty((String)instbillctg) ? InterestbillctgEnum.PAYINTERST.getValue() : instbillctg));
            OperateOption create = OperateOption.create();
            create.setVariableValue("byInit", "true");
            create.setVariableValue("renewalinterestrate", operationVariable.get("renewalinterestrate"));
            TmcOperateServiceHelper.execOperate((String)"calinterest", (String)interest.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{interest}, (OperateOption)create);
            if (!LoanTypeEnum.isBanksLoan((String)interest.getString("loantype"))) {
                return;
            }
            DynamicObjectCollection slBankEntrys = interest.getDynamicObjectCollection("slentryentity");
            List slBankEntryList = slBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno"))).collect(Collectors.toList());
            BatchIntBillHelper.setSlBankEntryAmount(slBankEntryList, (BigDecimal)interest.getBigDecimal("actualinstamt"), (String)"s_repayinst", (DynamicObject)interest.getDynamicObject("currency"), (boolean)true);
        }
    }

    private BigDecimal getBigDecimalPro(Map<String, String> operationVariable, String pro) {
        return new BigDecimal(operationVariable.get(pro));
    }

    private Date getDatePro(Map<String, String> operationVariable, String pro) {
        if (EmptyUtil.isEmpty((String)operationVariable.get(pro))) {
            return null;
        }
        return DateUtils.stringToDate((String)operationVariable.get(pro), (String)"yyyyMMdd");
    }

    private String getInstEntityName(DynamicObject instBill) {
        String dataSource = instBill.getString("datasource");
        if (DataSourceEnum.IFM.getValue().equals(dataSource)) {
            return "ifm_interestbill";
        }
        return "cfm_interestbill";
    }

    public void doBeforeCommit(DynamicObject[] bizBills, BusinessHandleParam param) {
        for (DynamicObject interest : bizBills) {
            long instId = interest.getLong("id");
            if (DataSourceEnum.IFM.getValue().equals(interest.getString("datasource"))) {
                TmcBotpHelper.saveRelation((String)"cfm_loanbill", (Long)interest.getLong("sourcebillid"), (String)"cfm_interestbill", (Long)instId);
            }
            BusinessHelper.fillConfirmInfo((DynamicObject)interest);
        }
    }

    public boolean doFilter(DynamicObject[] dynamicObjects, BusinessHandleParam param) {
        return ((InterestBillSaveParam)param.getInParam()).isByInit();
    }
}

