/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.tmc.cfm.common.enums.BillTypeEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LenderNatureEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.enums.PrePeriodParamEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BatchExecutePush2PreInstService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(BatchExecutePush2PreInstService.class);
    protected List<Object> batchBillIds = new ArrayList<Object>();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("org");
        selector.add("textdebtor");
        selector.add("textcreditor");
        selector.add("billno");
        selector.add("currency");
        selector.add("loancontractbill");
        selector.add("endpreinstdate");
        selector.add("startintdate");
        selector.add("notrepayamount");
        selector.add("lastrepaydate");
        selector.add("loantype");
        selector.add("datasource");
        selector.add("creditortype");
        selector.add("lendernature");
        selector.add("creditortype");
        selector.add("loaneracctbank");
        selector.add("creditorg");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String preperiod = (String)this.operationVariable.get("preperiod");
        logger.info("\u671f\u95f4:preperiod=" + preperiod);
        String preinstbillstatus = (String)this.operationVariable.get("preinstbillstatus");
        logger.info("\u72b6\u6001:preinstbillstatus=" + preinstbillstatus);
        String autoPre = (String)this.operationVariable.get("auto");
        logger.info("\u81ea\u52a8\u9884\u63d0:autoPre=" + autoPre);
        ArrayList<DynamicObject> batchPreObjList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject data : dataEntities) {
            if (this.validateOnWayBill(data, true)) continue;
            String entity = "cfm_intbill_batch_pre";
            if ("ifm".equals(data.getString("datasource"))) {
                entity = "ifm_intbill_batch_pre";
            }
            DynamicObject batchPreObj = BusinessDataServiceHelper.newDynamicObject((String)entity);
            String mainOrgField = BatchIntBillHelper.getMainOrgFeild((DynamicObject)data);
            String codeNumber = CodeRuleServiceHelper.getNumber((String)entity, (DynamicObject)batchPreObj, (String)data.getDynamicObject(mainOrgField).getPkValue().toString());
            batchPreObj.set("billno", (Object)codeNumber);
            batchPreObj.set("operateType", (Object)PreIntOperateTypeEnum.PREINT.getValue());
            batchPreObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            batchPreObj.set("createtime", (Object)new Date());
            batchPreObj.set("bizdate", (Object)DateUtils.getCurrentDate());
            batchPreObj.set("businessdate", (Object)DateUtils.getCurrentDate());
            batchPreObj.set("issettleadd", (Object)Boolean.FALSE);
            batchPreObj.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            batchPreObj.set("org", (Object)data.getDynamicObject(mainOrgField));
            batchPreObj.set("biztype", (Object)BillTypeEnum.PREINT.getValue());
            boolean investType = this.isInvestType(data);
            String dataSource = data.getString("datasource");
            dataSource = investType ? DataSourceEnum.INVEST.getValue() : (DataSourceEnum.isInvest((String)dataSource) ? DataSourceEnum.CFM.getValue() : dataSource);
            String loanType = data.getString("loantype");
            batchPreObj.set("loantype", (Object)loanType);
            batchPreObj.set("datasource", (Object)dataSource);
            batchPreObj.set("interesttype", (Object)"preint");
            if ("ifm".equals(data.getString("datasource"))) {
                DynamicObject loanBill = TmcDataServiceHelper.loadSingle((String)"ifm_loanbill", (String)"id, settlecenter", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)data.getLong("id"))});
                batchPreObj.set("settlecenter", loanBill.get("settlecenter"));
                batchPreObj.set("interesttype", (Object)"preint");
            }
            batchPreObj.set("comment", (Object)"auto");
            batchPreObj.set("isauto", (Object)true);
            DynamicObjectCollection entryList = batchPreObj.getDynamicObjectCollection("entry");
            DynamicObject entry = entryList.addNew();
            entry.set("loanbillid", data.getPkValue());
            entry.set("company", (Object)data.getDynamicObject("org"));
            entry.set("textdebtor", (Object)data.getString("textdebtor"));
            entry.set("textcreditor", (Object)data.getString("textcreditor"));
            entry.set("loannum", (Object)data.getString("billno"));
            entry.set("currency", (Object)data.getDynamicObject("currency"));
            Date startDate = data.getDate("endpreinstdate");
            startDate = EmptyUtil.isNoEmpty((Object)startDate) ? DateUtils.getNextDay((Date)startDate, (int)1) : data.getDate("startintdate");
            entry.set("startdate", (Object)startDate);
            Date endDate = DateUtils.getCurrentDate();
            if (PrePeriodParamEnum.THISMONTH.getValue().equals(preperiod)) {
                endDate = DateUtils.getLastDayOfMonth((Date)DateUtils.getCurrentDate());
            } else if (PrePeriodParamEnum.LASTMONTH.getValue().equals(preperiod)) {
                endDate = DateUtils.getLastDayOfMonth((Date)DateUtils.getLastMonth((Date)DateUtils.getCurrentDate(), (int)1));
            } else if (PrePeriodParamEnum.THISSEASON.getValue().equals(preperiod)) {
                endDate = DateUtils.getQuarterEnd((Date)DateUtils.getCurrentDate());
            }
            endDate = InterestCalcHelper.getEndIntDate((DynamicObject)data, (Date)endDate);
            endDate = EmptyUtil.isNoEmpty((Object)endDate) ? endDate : DateUtils.getCurrentDate();
            batchPreObj.set("preintdate", (Object)DateUtils.getNextDay((Date)endDate, (int)1));
            entry.set("enddate", (Object)endDate);
            if (EmptyUtil.isEmpty((Object)endDate) || EmptyUtil.isEmpty((Object)startDate) || endDate.compareTo(startDate) < 0) continue;
            IntBillExtInfo intBill = InterestCalcHelper.callInt((Long)data.getLong("id"), (Date)startDate, (Date)DateUtils.getNextDay((Date)endDate, (int)1), (boolean)true);
            if (EmptyUtil.isNoEmpty((Object)intBill)) {
                entry.set("interestamt", (Object)intBill.getAmount());
                entry.set("actualinstamt", (Object)intBill.getAmount());
                entry.set("intdetail", (Object)intBill);
                entry.set("intdetail_tag", (Object)SerializationUtils.toJsonString((Object)intBill));
                List details = intBill.getDetails();
                entry.set("rate", (Object)((IntBillDetailInfo)details.get(0)).getRate());
                entry.set("principle", (Object)((IntBillDetailInfo)details.get(0)).getPrinciple());
                int days = details.stream().mapToInt(IntBillDetailInfo::getDays).sum();
                entry.set("intdays", (Object)days);
            }
            entry.set("loancontractbillno", (Object)data.getDynamicObject("loancontractbill").getString("number"));
            entry.set("contractnum", (Object)data.getDynamicObject("loancontractbill").getString("contractno"));
            batchPreObjList.add(batchPreObj);
        }
        if (EmptyUtil.isNoEmpty(batchPreObjList)) {
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_intbill_batch_pre", (DynamicObject[])batchPreObjList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create(), (boolean)true);
            if ("submit".equals(preinstbillstatus) || "audit".equals(preinstbillstatus)) {
                this.batchBillIds.addAll(operationResult.getSuccessPkIds());
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("auto", "true");
                operateOption.setVariableValue("WF", "TRUE");
                OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)"ifm_intbill_batch_pre", (Object[])operationResult.getSuccessPkIds().toArray(), (OperateOption)operateOption, (boolean)true);
                if ("audit".equals(preinstbillstatus) && submitResult.isSuccess()) {
                    TmcOperateServiceHelper.execOperate((String)"audit", (String)"ifm_intbill_batch_pre", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)operateOption, (boolean)true);
                }
            }
        }
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.handlerException(dataEntities);
        if (EmptyUtil.isNoEmpty(this.batchBillIds)) {
            Object[] ids;
            QFilter filter = new QFilter("id", "in", this.batchBillIds).and("billstatus", "in", (Object)new String[]{BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.SAVE.getValue()});
            DynamicObjectCollection batchBills = QueryServiceHelper.query((String)"ifm_intbill_batch_pre", (String)"id,billstatus", (QFilter[])filter.toArray());
            Object[] submitIds = batchBills.stream().filter(v -> BillStatusEnum.isSubmit((String)v.getString("billstatus"))).map(r -> r.get("id")).toArray();
            if (EmptyUtil.isNoEmpty((Object[])submitIds)) {
                TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"ifm_intbill_batch_pre", (Object[])submitIds, (OperateOption)OperateOption.create(), (boolean)true);
            }
            if (EmptyUtil.isNoEmpty((Object[])(ids = batchBills.stream().map(v -> v.get("id")).toArray()))) {
                TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_intbill_batch_pre", (Object[])ids, (OperateOption)OperateOption.create(), (boolean)true);
            }
        }
    }

    protected boolean validateOnWayBill(DynamicObject loanBill, boolean isPreInt) {
        QFilter qfilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        qfilter.and(new QFilter("entry.loanbillid", "=", loanBill.getPkValue()));
        String bizType = isPreInt ? "preint" : "loan";
        qfilter.and(new QFilter("biztype", "=", (Object)bizType));
        return TmcDataServiceHelper.exists((String)"cfm_intbill_batch_pre", (QFilter[])qfilter.toArray());
    }

    private boolean isInvestType(DynamicObject loanBill) {
        boolean isInvest = false;
        String dataSource = loanBill.getString("datasource");
        if (DataSourceEnum.isInvest((String)dataSource)) {
            String lenderNature = loanBill.getString("lendernature");
            isInvest = LenderNatureEnum.INGROUP.getValue().equals(lenderNature) ? loanBill.getDynamicObjectType().getName().equals("cim_invest_loanbill") : true;
        } else if (DataSourceEnum.isCfm((String)dataSource)) {
            String loanType = loanBill.getString("loantype");
            String lenderNature = loanBill.getString("lendernature");
            if ((LoanTypeEnum.isLinklend((String)loanType) || LoanTypeEnum.isEntrustLoan((String)loanType)) && LenderNatureEnum.INGROUP.getValue().equals(lenderNature)) {
                isInvest = loanBill.getDynamicObjectType().getName().equals("cim_invest_loanbill");
            }
        }
        return isInvest;
    }
}

