/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmAttachmentHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.cfm.common.helper.UnifyLoanRepayHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;

public class LoanBillAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(LoanBillAuditService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("drawtype");
        sic.add("sourcebillid");
        sic.add("confirmstatus");
        sic.add("lendernature");
        sic.add("loantype");
        sic.add("datasource");
        sic.add("creditorg");
        sic.add("org");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("accountbank");
        sic.add("loaneracctbank");
        sic.add("calculaterateamount");
        sic.add("notrepayamount");
        sic.add("amount");
        sic.add("drawamount");
        sic.add("productfactory");
        sic.add("isinit");
        sic.add("creditor");
        sic.add("creditortype");
        sic.add("textcreditor");
        sic.add("debtortype");
        sic.add("debtor");
        sic.add("textdebtor");
        sic.add("loancontractbill");
        sic.add("settlestatus");
        sic.add("currency");
        sic.add("bizdate");
        sic.add("convertdrawamt");
        sic.add("convertrate");
        sic.add("calculaterateamount");
        sic.add("notrepayamount");
        sic.add("loanrate");
        sic.add("startintdate");
        sic.add("term");
        sic.add("expiredate");
        sic.add("isunifyloanreturn");
        sic.add("unifyloanfrom_entry");
        sic.add("unifyloanfrom_entry.e_loanbillid");
        sic.add("unifyloanfrom_entry.e_useamt");
        sic.add("unifyloanfrom_entry.e_payamt");
        sic.add("unifyloanfrom_entry.e_notpayint");
        sic.add("unifyloanfrom_entry.e_payint");
        sic.add("unifyloanfrom_entry.e_useloanamt");
        sic.add("issofrrate");
        sic.add("iscallcompint");
        sic.add("intcalmethod");
        sic.add("workcalendar");
        sic.add("rateresetadjustrule");
        sic.add("drawapplybill");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        boolean isSyncDraw = Boolean.TRUE.toString().equalsIgnoreCase((String)this.getOperationVariable().get("issyncdraw"));
        ArrayList<DynamicObject> autoConfirmBills = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject loanBill : dataEntities) {
            loanBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            loanBill.set("confirmstatus", (Object)ConfirmStatusEnum.WAITCONFIRM.getValue());
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(loanBill.getString("creditortype"))) {
                String entityName = loanBill.getDataEntityType().getName();
                if ("cfm_loanbill".equals(entityName)) {
                    loanBill.set("settlestatus", (Object)SettleCenterStatusEnum.SUBMIT.getValue());
                    continue;
                }
                loanBill.set("settlestatus", (Object)SettleCenterStatusEnum.ACCEPT.getValue());
                continue;
            }
            if (!this.isAutoConfirm(loanBill, isSyncDraw)) continue;
            loanBill.set("drawtype", (Object)DrawTypeEnum.DRAWED.getValue());
            autoConfirmBills.add(loanBill);
        }
        if (!autoConfirmBills.isEmpty()) {
            BusinessHelper.fillConfirmInfo(autoConfirmBills);
            CfmBillCommonHelper.updateApplyBizStatus(autoConfirmBills, (String)"drawapplybill", (String)"cfm_draw_apply", (String)ApplyBusinessStatusEnum.HANDED.getValue());
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        boolean isSyncDraw = Boolean.TRUE.toString().equalsIgnoreCase((String)this.getOperationVariable().get("issyncdraw"));
        List<DynamicObject> loanBills = Arrays.stream(dataEntities).filter(d -> this.isAutoConfirm((DynamicObject)d, isSyncDraw)).collect(Collectors.toList());
        LoanWriteBackHelper.writeBack((LoanWriteParam)LoanWriteParam.buildLoanBill(loanBills, (LoanWBTypeEnum)LoanWBTypeEnum.UPDATECONTRACT));
        UnifyLoanRepayHelper.updateRelateLoanUnify((DynamicObject[])loanBills.toArray(new DynamicObject[0]));
    }

    private boolean isAutoConfirm(DynamicObject loanBill, boolean isSyncDraw) {
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(loanBill.getString("creditortype"))) {
            return false;
        }
        return isSyncDraw || BusinessHelper.isAutoConfirm((DynamicObject)loanBill);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        CfmAttachmentHelper.dealAttachment((DynamicObject[])dataEntities);
    }
}

